
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.sql.*;

class CommonServlet extends HttpServlet
{
	
	Connection conn = null;
	String codedir = null, htmldir = null, hostname = null, sqlport = null, 
		user = null, password = null, serverport = null;

	public void putHtml(PrintWriter toClient, String fn, Vector termlist)
	{
		BufferedReader inp = null;
		try
		{	
			fn = htmldir + fn;
			inp =
				new BufferedReader(new InputStreamReader(new DataInputStream
					(new BufferedInputStream(new FileInputStream(fn)))));
		}
		catch (Exception e)
		{
			System.out.println("Exception: " + e);
			toClient.println("<title>Error</title>Error: The webpage requested does not exist");
			return;
		}
		String s = null;
		try
		{
		  while ((s = inp.readLine()) != null)
		  {
			int i;
			while ((i = s.indexOf("$HOST$")) != -1)
				s = s.substring(0, i) + hostname + s.substring(i + 6);
			while ((i = s.indexOf("$PORT$")) != -1)
				s = s.substring(0, i) + serverport + s.substring(i + 6);
			if (termlist != null)
				for (Enumeration e = termlist.elements();
					e.hasMoreElements();)
				{
					String item = (String)e.nextElement();
					String code = item.substring(1, item.indexOf(':')),
						val = item.substring(item.indexOf(':') + 1);
					while ((i = s.indexOf(code)) != -1)
						s = s.substring(0, i - 1) + val + 
							s.substring(i + code.length());
				}
			if (s.trim().equals("$OPTDESGN$"))
			{
				putOptions(toClient, "select Post from Designation");
			}
			else if (s.trim().equals("$OPTLOANS$"))
			{
				putOptions(toClient, "select loantype from loannames");
			}
			else toClient.println(s);
		  }
		}
		catch (IOException e)
		{
			System.out.println("IOException: " + e);
			toClient.println("IOException: " + e);
		}
	}
	void initCommon() throws Exception
	{
		String fs = System.getProperty("file.separator");
		htmldir = getInitParameter("htmldir") + fs;
		hostname = getInitParameter("host");
		sqlport = getInitParameter("sqlport");
		serverport = getInitParameter("serverport");
		user = getInitParameter("user");
		password = getInitParameter("password");
	  	if (htmldir == null || hostname == null || sqlport == null || 
		  user == null || password == null || serverport == null)
			throw new Exception("All parameters(htmldir, host, sqlport," + 
				"user, password, serverport) not given");
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		conn = DriverManager.getConnection ("jdbc:oracle:thin:@" + 
			hostname + ":"+sqlport+":GEN",user,password);
	}
	Connection getNewConnection() throws SQLException
	{
		Connection c = DriverManager.getConnection ("jdbc:oracle:thin:@" + 
			hostname + ":"+sqlport+":GEN",user,password);
		return c;
	}
	void putOptions(PrintWriter toClient, String query)
	{
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			while (rs.next())
				toClient.println("	<option value=\"" + rs.getString(1) +
				"\">" + rs.getString(1));
		}
		catch (Exception e)
		{
			toClient.println("    <option value=\"Error\"> Error");
		}
		try
		{
			stmt.close();
			rs.close();
		} catch (Exception e) {}
	}
}

