

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;

class DeptAdmin extends Admin
{
	String adeptname = null, adeptcode = null;
	//Assumption:no more than 99999 bills per day
	//On the day of salary payment, too many new bills may be created
	public DeptAdmin(String i, PrintWriter toClient, AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		id = i;
		//Find out the department of this admin
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select deptname, deptcode from " + 
			"department where deptadminid = '" + id + "'");
		rs.next();
		adeptname = rs.getString(1); adeptcode = rs.getString(2);
		termlist.addElement("$USER$:" + id);
		termlist.addElement("$DEPT$:" + adeptname);
		as.putHtml(toClient, "deptamain.html", termlist);
	  }
	  catch(Exception e)
	  {
	  	toClient.println("Error: " + e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	
	public void doPost(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String formname;
		if ((formname = req.getParameter("formname")) == null)
		{
			toClient.println("Error: Invalid form");
			return;
		}
		if (formname.equals("newempl"))
			NewEmpl(req, toClient, as);
		else if (formname.equals("chpwadmin"))
			ModifyPasswd(req, toClient, as);
		else if (formname.equals("newstudent"))
			NewStudent(req, toClient, as);
		else if (formname.equals("newbill"))
			NewBill(req, toClient, as);
		else if (formname.equals("emplpromote"))
			EmplPromote(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid form");
			return;
		}
	}

	public void doGet(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String action;
		if ((action = req.getParameter("action")) == null)
		{
			toClient.print("Error: Invalid form");
			return;
		}
		else if (action.equals("allemplinfo"))
			AllEmplInfo(req, toClient, as);
		else if (action.equals("allstudentinfo"))
			AllStudentInfo(req, toClient, as);
		else if (action.equals("allpbillsinfo"))
			AllPBillsInfo(req, toClient, as);
		else if (action.equals("allnbillsinfo"))
			AllNBillsInfo(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid action");
			return;
		}
	}
		

	void AllEmplInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Id, name, salarycode, " + 
			"dob, sex, hasownhouse, email, post, curpaystage, prvincrdate, " +
			"address from employee where deptcode = '" + adeptcode + "'");

		toClient.println("<html><head><title>Details of all Employees of " +
			"department " + adeptname + 
			"</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<table>" +
			"<tr><th>Id<th>Name<th>Salary Code<th>DOB<th>Sex<th>" + 
			"HasOwnHouse<th>EMail<th>Post<th>Current PayStage" + 
			"<th>Last Increment<th>Address");
		while (rs.next()) 
		{
			toClient.println("<tr>");
			for (int i = 1; i <= 11; i++)
			{
				if (i != 4 && i != 10)
					toClient.print("<td>" + rs.getString(i));
				else
					toClient.print("<td>" + Utility.toString(rs.getDate(i)));
			}
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	
	void AllStudentInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select id, name, acctno, email, " +
			"address from student where deptcode = '" + adeptcode + "'");

		toClient.println("<html><head><title>Details of all Students of " +
			"department " + adeptname + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<table><tr><th>Id<th>Name<th>Account No<th>EMail<th>" + 
			"Address");
		while (rs.next()) 
		{
			toClient.println("<tr>");
			for (int i = 1; i <= 5; i++)
				toClient.print("<td>" + rs.getString(i));
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	void AllPBillsInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of all pending bills" +
			" of department " + adeptname + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select BillNo, EntryDate," + 
			"description, type, payeetype, payeeid, amount from " +
			"bills where deptcode = '" + adeptcode + 
			"' and (status = 'N' or (status = 'P' and (BillNo, EntryDate)" +
			 	" in (select BillNo, EntryDate from PayDetails where " +
				"chequestatus = 'B'))) " +
			" order by EntryDate, BillNo");

		toClient.println("<table><tr><th>BillNo<th>EntryDate<th>Description"+
			"<th>Type<th>Payee Type<th>Payee Id<th>Amount");
		while (rs.next()) 
		{
			String d = Utility.toString(rs.getDate(2)), n = rs.getString(1),
				t = "";
			if (rs.getString(4).equals("P"))
				t = "Payement";
			else
				t = "Recipt";
			toClient.println("<tr><td>" + Utility.toBillNo(d, n) + 
				"<td>"+ d + "<td>" + rs.getString(3) + "<td>" + t + "<td>");
			if (rs.getString(5).equals("S"))
				toClient.print("Student");
			else if (rs.getString(5).equals("E"))
				toClient.print("Employee");
			else 
				toClient.print("Company");
			toClient.print("<td>" + rs.getString(6) + "<td>" + rs.getString(7));
		}
		toClient.println("</table><br><br>Note:type indicated role of" +
			" department. This list does not include bills for which " +
			" clearance of cheque is necessary from bank</body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	//To be updated
	void NewEmpl(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
	  	//--------------------------------------------------
		//Ask details necessary for IT calculation here.
		toClient.println("<html><head><title>Response to Create Employee</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String id = req.getParameter("id").trim().toLowerCase(), 
			password = req.getParameter("emppasswd").trim().toLowerCase(), 
			name = req.getParameter("emplname").trim().toLowerCase(),
			acctno = req.getParameter("acctno").trim().toLowerCase(), 
			address = req.getParameter("address").trim().toLowerCase(), 
			dob = req.getParameter("dob").trim().toLowerCase(), 
			sex = req.getParameter("sex").trim().toUpperCase(), 
			post = req.getParameter("post").trim().toLowerCase(), 
			tisincemarch = req.getParameter("tisincemarch"), 
			hrasincemarch = req.getParameter("hrasincemarch"), 
			itpaid = req.getParameter("itpaid"), 
			curpaystage = req.getParameter("curpaystage").trim().toLowerCase(), 
			prvincrdate = req.getParameter("prvincrdate").trim().toLowerCase(), 
			hasownhouse = req.getParameter("hasownhouse").trim().toUpperCase(), 
			salarycode = req.getParameter("salarycode").trim().toUpperCase(), 
			email = req.getParameter("email").trim().toLowerCase(); 
		if (id.length() == 0 || password.length() == 0 || 
		  name.length() == 0)
			throw new Exception("You have not filled the form properly");
		
		stmt.executeUpdate("insert into People (ID, Type, password) values ('" +
			id + "', 'E', '" + password + "')");
		//try
		//{
		stmt.executeUpdate("insert into Employee (Id, name, " +
			"address, acctno, deptcode, email, dob, sex, hasownhouse, post, " + 
			"curpaystage, prvincrdate, salarycode, TISinceMarch," + 
			"HRASinceMarch, itpaid) " + 
			"values ('" + id + "', '" + name + "', '" +
			address + "', " + acctno + ", '" + adeptcode + "', '" + email +
			"', to_date('" + dob + "', 'DD-MM-YYYY'), '" + sex + "', '" +
			hasownhouse + "', '" + post + "', " + curpaystage + 
			", to_Date('" + prvincrdate + "', 'DD-MM-YYYY'), " + 
			salarycode + ", " + tisincemarch + ", " + hrasincemarch + ", " + 
			itpaid + ")");
	  	//}
		//catch (Exception e)
		//{
		//	stmt.executeUpdate("delete from People where ID = '" + id + "'");
		//	throw e;
		//}
		try
		{
			toClient.print("Employee <b>" + name + "</b>" +
		  		"</b> has been succesfully created<br><br>");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	try
		{
			stmt.executeUpdate("delete from People where ID = '" + id + "'");
			stmt.executeUpdate("delete from employee where id = '" + id + "'");
			//stmt.executeUpdate("delete from ITaxDetails where SalaryCode =" + salarycode);
	  	} catch (Exception e1) {}
		Utility.printError(toClient,e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	void NewStudent(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Create Student</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String id = req.getParameter("id").trim().toLowerCase(), 
			password = req.getParameter("passwd").trim().toLowerCase(), 
			name = req.getParameter("studentname").trim().toLowerCase(),
			acctno = req.getParameter("acctno").trim().toLowerCase(), 
			address = req.getParameter("address").trim().toLowerCase(), 
			email = req.getParameter("email").trim().toLowerCase();
		if (id.length() == 0 || password.length() == 0 || 
		  name.length() == 0)
			throw new Exception("You have not filled the form properly");
			
		stmt.executeUpdate("insert into People (ID, Type, password) values ('" +
			id + "', 'S', '" + password + "')");
		try
		{
			stmt.executeUpdate("insert into Student(Id, name, " +
				"address, acctno, deptcode, email) " + 
				"values ('" + id + "', '" + name + "', '" +
				address + "', " + acctno + ", '" + adeptcode + "', '" + email +
				"')");
		}
		catch (Exception e)
		{
			stmt.executeUpdate("delete from People where ID = '" + id + "'");
			throw e;
		}
	  	try
		{
			toClient.print("Student <b>" + name + "</b>" +
		  		"</b> has been succesfully created<br><br>");
		}
		catch (Exception e)
		{
			System.out.println("Exception: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	synchronized void NewBill(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		
		toClient.println("<html><head><title>Response to Create New Bill</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String personid = req.getParameter("personid").trim().toLowerCase(), 
			persontype = req.getParameter("persontype").trim().toLowerCase(),
			amount = req.getParameter("amount").trim().toLowerCase(), 
			type = req.getParameter("type").trim().toLowerCase(), 
			description = req.getParameter("description").trim().toLowerCase();
		if (personid.length() == 0 || description.length() == 0 || 
		  (!type.equals("r") && !type.equals("p")))
			throw new Exception("You have not filled the form properly");
		//Make sure all info is proper
		String query = null;
		if (persontype.equals("s"))
			query = "select id from student where id = '" + personid + "'";
		else if (persontype.equals("e"))
			query = "select id from employee where id = '" + 
				personid + "'";
		//else "c"....
		rs = stmt.executeQuery(query);
		if (!rs.next())
			throw new Exception("Invalid Id for person given");
		try
		{
			if (Utility.toFloat(amount) < 0)
				throw new Exception("Negative amount not allowed");
		}
		catch (NumberFormatException e)
		{
			throw new Exception("Invalid number entered for amount");
		}
		//Get new bill number
		int billno = as.getNewBillNo();
		String dt = Utility.toString(new java.util.Date());
		stmt.executeUpdate("insert into Bills(billno, amount, entrydate, " +
			"status, type, deptcode, payeetype, payeeid, description) " + 
			"values (" + billno + ", " + amount +  ", to_date('" + dt + 
			"', 'dd-mm-yyyy'), 'N', '" + type.toUpperCase() + "', '" + 
			adeptcode + "', '" + persontype.toUpperCase() + "', '" + 
			personid + "', '" + description + "')");
	  	try
		{
			toClient.print("Bill number <b>" +  
				Utility.toBillNo(dt, ""+ billno) +
				"</b> on " + personid + " of amount " + amount + "(" + type +
				") has been succesfully created<br><br>");
		}
		catch (Exception e)
		{
			System.out.println("Exception: " + e);
		}
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	    rs.close();
	  } catch (Exception e) {}
	}
	void EmplPromote(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Promote Employee</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String salarycode = req.getParameter("salarycode"),
			promotedate = req.getParameter("promotedate"),
			newpost = req.getParameter("newpost"),
			isreshigher = req.getParameter("isreshigher");
		rs = stmt.executeQuery("select oldpaystage, " +
			"oldgrade, curpaystage, grade, withholdincfrom from employee, " +
			"designation where salarycode=" + salarycode + 
			" and employee.deptcode = '" + adeptcode + 
			"' and employee.post = designation.post");
		if (!rs.next())
			throw new Exception("No employee with salary-code " + salarycode +
				" under you");
		stmt.executeUpdate("insert into promotion (SalaryCode, NewPost, " +
			" IsResHigher, DateOfPromotion) values (" +
			salarycode + ", '" + newpost + "', '" + isreshigher + "', " +
			" to_date('" + promotedate +
			"', 'dd-mm-yyyy'))");
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	    rs.close();
	  } catch (Exception e) {}
	}
	void AllNBillsInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of all Bills " +
			"settled in last 31 days" +
			" of department " + adeptname + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Bills.BillNo, Bills.EntryDate," + 
			"description, type, payeetype, payeeid, amount, RecptNo, " +
			"PaytDate, PaytMode, ChequeNo from " +
			"bills, paydetails where deptcode = '" + adeptcode +
			"' and status = 'P' and (chequestatus is null or " +
			" chequestatus = 'C') and to_Date('" + 
			Utility.toString(new java.util.Date()) + "', 'dd-mm-yyyy')" +
			" - PaytDate <= 31 and Bills.BillNo = PayDetails.BillNo and " +
			" Bills.EntryDate = PayDetails.EntryDate " + 
			" order by PaytDate, RecptNo");

		toClient.println("<table><tr><th>BillNo<th>EntryDate<th>Description"+
			"<th>Type<th>Payee Type<th>Payee Id<th>Amount<td>Recipt No" +
			"<td>Payment Mode<td>ChequeNo");
		while (rs.next()) 
		{
			String d = Utility.toString(rs.getDate(2)), n = rs.getString(1),
				t = "";
			if (rs.getString(4).equals("P"))
				t = "Payement";
			else
				t = "Recipt";
			toClient.println("<tr><td>" + Utility.toBillNo(d, n) + 
				"<td>"+ d + "<td>" + rs.getString(3) + "<td>" + t + "<td>");
			if (rs.getString(5).equals("S"))
				toClient.print("Student");
			else if (rs.getString(5).equals("E"))
				toClient.print("Employee");
			else 
				toClient.print("Company");
			toClient.print("<td>" + rs.getString(6) + "<td>" + rs.getString(7));
			toClient.println("<td>" + 
				Utility.toBillNo(rs.getDate(9), rs.getString(8)) + "<td>" +
				(rs.getString(10).equals("Q") ? "Cheque" : "Cash") + "<td>" +
				rs.getString(11));
		}
		toClient.println("</table><br><br>Note:type indicated role of" +
			" department</body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	    rs.close();
	  } catch (Exception e) {}
	}
		
}
