/* This servlet handles actions related the the students, employees and
 * company */



import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;


public class PersonServlet extends CommonServlet
{
    public String SName()
	{
		return "http://" + hostname + ":" + serverport +
			"/servlet/PersonServlet";
	}
	
	public synchronized void init(ServletConfig config) throws ServletException
	{
		try
		{
			super.init(config);
			initCommon();
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
			System.exit(0);
		}
	}
	
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
        PrintWriter toClient = res.getWriter();
		FileInputStream inp = null;
		String fn;
		try
		{	
			String s = req.getParameter("httpfile"),
				ss = req.getParameter("cssfile"),
				axn = req.getParameter("action");
        	HttpSession session = req.getSession(true);
      		Object obj = session.getValue("object");
			Vector termlist = null;
			if (obj != null && obj instanceof Person) 
				termlist = ((Person)obj).termlist;
			if (s != null || (axn == null && ss == null))
			{
   			    res.setContentType("text/html");
				if (s == null)
					fn = "personlogin.html";
				else if (obj == null || !(obj instanceof Person))
					throw new Exception("You have not been logged in");
				else
					fn = s;
				putHtml(toClient, fn, termlist);
			}
			else if (axn != null)
			{
        		res.setContentType("text/html");
				if (obj == null)
					throw new Exception("You have not been logged in");
				else if (obj instanceof Student)
					((Student)obj).doGet(req, toClient, this);
				else if (obj instanceof Employee)
					((Employee)obj).doGet(req, toClient, this);
				/*else if (obj instanceof Company)
					((Company)obj).doGet(req, toClient, this);*/
				else
					throw new Exception("You have not been logged in");
			}
			else if (ss != null)
			{
        		res.setContentType("text/css");
				//if (obj == null)
				//	throw new Exception("You have not been logged in");
				putHtml(toClient, ss, termlist);
				
			}
		}
		catch (Exception e)
		{
			toClient.println("<html><head><title>Error</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + SName() + "?cssfile=MyStyle1.css\"><body>");
			Utility.printError(toClient, e);
		}
	}
		
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
      PrintWriter toClient = res.getWriter();
	  try
	  {
        res.setContentType("text/html");
        HttpSession session = req.getSession(true);
        Object obj = session.getValue("object");
		
		String formname = req.getParameter("formname");
		if (formname == null)
			throw new Exception("Invalid form");
		if (formname.equals("personlogin"))
		{	
			Object slogin = LoginValid(toClient, req.getParameter("id"),
				                        req.getParameter("passwd"));
			if (slogin != null)
				session.putValue("object", slogin);
		}	
		else if (obj == null || !(obj instanceof Person))
			throw new Exception("You have not been logged in");
		
		else if (obj instanceof Student)
			((Student)obj).doPost(req, toClient, this);
		else if (obj instanceof Employee)
			((Employee)obj).doPost(req, toClient, this);
		//else if (obj instanceof Company)
			//((Company)obj).doPost(req, toClient, this);
	  }
	  catch (Exception e)
	  {
		toClient.println("<html><head><title>Error</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + SName() + "?cssfile=MyStyle1.css\"><body>");
	  	Utility.printError(toClient, e);
	  }
	}
	
	Object LoginValid(PrintWriter toClient, String id, String passwd)
		throws Exception
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		id  = id.toLowerCase();
		passwd = passwd.toLowerCase();
		String s = "select Password, Type from People where ID = '" +
			        id + "'";
		stmt = conn.createStatement();
		rs = stmt.executeQuery(s);
		if (rs.next())
		{
			String p = rs.getString(1),
				type = rs.getString(2); 
			stmt.close();
			if (p.equals(passwd))
			{
				if (type.equals("S"))
					return new Student(id, toClient, this);
				else if (type.equals("E"))
					return new Employee(id, toClient, this);
				//else if (p.equals("C"))
				//	return new Company(id, toClient, this);
	
			}
			else
				throw new Exception("Invalid Password");
		}
		else
			throw new Exception("Invalid LoginId");
	  }
	  catch (Exception e)
	  {
	    try
	    {
		  	stmt.close();
			rs.close();
	    } catch (Exception e1) {}
	  	throw e;
	  }
	  return null;
	}
}


