
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;

class RootAdmin extends Admin
{
	public RootAdmin(String i, PrintWriter toClient, AdminServlet as)
	{
		id = i;
		termlist.addElement("$USER$:" + id);
		as.putHtml(toClient, "rootmain.html", termlist);
	}
	public void doPost(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String formname;
		if ((formname = req.getParameter("formname")) == null)
		{
			toClient.println("Error: Invalid form");
			return;
		}
		if (formname.equals("newadmin"))
			NewAdmin(req, toClient, as);
		else if (formname.equals("deladmin"))
			DelAdmin(req, toClient, as);
		else if (formname.equals("modifyadmin"))
			ModifyAdmin(req, toClient, as);
		else if (formname.equals("chpwadmin"))
			ModifyPasswd(req, toClient, as);
		else if (formname.equals("newdept"))
			NewDept(req, toClient, as);
		else if (formname.equals("deldept"))
			DelDept(req, toClient, as);
		else if (formname.equals("calcsalary"))
			CalcSalary(req, toClient, as);
		else if (formname.equals("rateofda"))
			putRateOfDA(req, toClient, as);
		else if (formname.equals("newltype"))
			NewLoanType(req, toClient, as);
		else if (formname.equals("interestrate"))
			InterestRate(req, toClient, as);
		else if (formname.equals("modifyiratereq"))
			InterestRateReq(req, toClient, as);
		//else if (formname.equals("modifydept"))
		//	ModifyDept(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid form");
			return;
		}
	}

	public void doGet(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String action;
		if ((action = req.getParameter("action")) == null)
		{
			toClient.print("Error: Invalid form");
			return;
		}
		else if (action.equals("alladmininfo"))
			AllAdminInfo(req, toClient, as);
		else if (action.equals("alldeptinfo"))
			AllDeptInfo(req, toClient, as);
		else if (action.equals("loanratesinfo"))
			LoanRatesInfo(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid action");
			return;
		}
	}
		

	void AllAdminInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select AdminId, AdminType from Admin");

		toClient.println("<html><head><title>Details of all Administrators" +
			"</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<table><tr><th>Admin Id" + 
			"<th> Admin Type");
		while (rs.next()) 
			toClient.println("<tr><td>" + rs.getString(1) + "<td>" + 
				rs.getString(2));
		toClient.println("</table></body></html>");
		stmt.close();
	  }
	  catch (Exception e)
	  {
		toClient.print("Exception: " + e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	
	void AllDeptInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select DeptName, DeptCode, AcctNo, " +
				"description, salaryadminid, deptadminid from department");

		toClient.println("<html><head><title>Details of all Departments" +
			"</title></head>" + 
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<table><tr><th>Department Name" + 
			"<th> Department Code<th>Account No<th>Description" +
			"<th>Salary Admin<th>Department Admin");
		while (rs.next()) 
			toClient.println("<tr><td>" + rs.getString(1) + 
				"<td>" + rs.getString(2) + "<td>" + rs.getString(3) +
				"<td>" + rs.getString(4) + "<td>" + rs.getString(5) +
				"<td>" + rs.getString(6));
		toClient.println("</table></body></html>");
		stmt.close();
	  }
	  catch (Exception e)
	  {
		toClient.print("Exception: " + e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	
	void LoanRatesInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select LoanType, ApplicableFrom, InterestRate from LoanRates order by LoanType,ApplicableFrom");

		toClient.println("<html><head><title>Details of Loan Rates" +
			"</title></head>" + 
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<table><tr><th>Type of Loan" + 
			"<th>Applicable From<th>Interest Rate");
		while (rs.next()) 
			toClient.println("<tr><td>" + rs.getString(1) + 
				"<td>" + Utility.toString(rs.getDate(2)) + "<td>" + rs.getString(3));
		toClient.println("</table></body></html>");
		stmt.close();
	  }
	  catch (Exception e)
	  {
		toClient.print("Exception: " + e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}

	
	void NewAdmin(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Add New Admin</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String id = req.getParameter("id").trim().toLowerCase(), 
			password = req.getParameter("passwd").trim().toLowerCase(), 
			admintype = req.getParameter("admintype").trim().toLowerCase();
		if (id.length() == 0 || password.length() == 0 ||admintype.length() == 0)
			throw new Exception("You cant leave any of the fields blank");
		if (id.equals("dept"))
			throw new Exception("You cant create department admin");
			
		stmt.executeUpdate("insert into Admin(AdminId, AdminType, Password) " +
			"values ('" + id + "', '" + admintype +  "', '" + password + "')");
	  	try
		{
			toClient.print("Admin <b>" + id + "</b> of type <b>" + admintype +
		  		"</b> has been succesfully created<br><br>");
		}
		catch (Exception e)
		{
			toClient.print("Exception: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	void DelAdmin(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Delete Admin</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String delid = req.getParameter("id").trim().toLowerCase();
		if (delid.length() == 0)
			throw new Exception("You cant leave any of the fields blank");
		delid = delid.toLowerCase();
		if (delid.equals(id))
			throw new Exception("You cant delete yourself");
		rs = stmt.executeQuery("select AdminType from Admin where " +
			"AdminId = '" + delid + "'");
		if (!rs.next())
			throw new Exception("Given Id is invalid");
		if (rs.getString(1).equals("dept"))
			throw new Exception("You cant delete dept admin");
		stmt.executeUpdate("delete from Admin where adminid = '" + delid + "'");
	  	//Log out the admin if he is logged in
		//........................................
		//...........................................
		try
		{
			toClient.print("Admin <b>" + delid  + "</b> has been succesfully" + 
				" deleted<br><br>");
		}
		catch (Exception e)
		{
			toClient.print("Exception: " + e);
		}
		stmt.close();
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  	rs.close();
	  } catch (Exception e) {}
	}
	
	void ModifyAdmin(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Modify Details of Admin</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String id = req.getParameter("id").trim().toLowerCase(), 
			password = req.getParameter("passwd").trim().toLowerCase(),
			password2 = req.getParameter("passwd2").trim().toLowerCase();
		if (id.length() == 0 || password.length() == 0)
			throw new Exception("You cant leave any of the fields blank");
		if (!password.equals(password2))
			throw new Exception("Both new passwords dont match");
		rs = stmt.executeQuery("select Adminid from Admin where " +
			"AdminId = '" + id + "'");
		if (!rs.next())
			throw new Exception("No such administrator exists");
		stmt.executeUpdate("update Admin set password='" + password +
			"' where AdminId='" + id + "'");
	  	try
		{
			toClient.print("Admin <b>" + id + "</b>'s details have been " +
				"succesfully changed<br><br>");
		}
		catch (Exception e)
		{
			toClient.print("Exception: " + e);
		}
		stmt.close();
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  	rs.close();
	  } catch (Exception e) {}
	}
	  	
	void NewDept(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Create New Department</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String deptname = req.getParameter("deptname").trim().toLowerCase(), 
			deptcode = req.getParameter("deptcode").trim().toLowerCase(), 
			acctno = req.getParameter("acctno").trim().toLowerCase(),
			desc = req.getParameter("desc").trim().toLowerCase(), 
			dapasswd = req.getParameter("dapasswd").trim().toLowerCase(), 
			sadmin = req.getParameter("sadmin").trim().toLowerCase();
		String deptadmin = deptcode + "admin";
		if (deptname.length() == 0 || deptcode.length() != 2 || 
		  acctno.length() == 0 || desc.length() == 0 || dapasswd.length() == 0
		  || sadmin.length() == 0)
			throw new Exception("The data is not in proper format");
		rs = stmt.executeQuery("select * from department where " +
			"deptcode = '" + deptcode + "'");
		if (rs.next())
			throw new Exception("Department code is already in use");
		rs = stmt.executeQuery("select * from admin where " +
			"adminid = '" + sadmin + "' and admintype = 'salary'");
		if (!rs.next())
			throw new Exception("Salary AdminId is invalid");
		//Check that <deptcode>admin does not exist already
		stmt.executeUpdate("insert into Admin(AdminId, AdminType, Password) " +
			"values ('" + deptadmin + "', 'dept', '" + dapasswd + "')");
		try
		{
			stmt.executeUpdate("insert into Department (DeptName, DeptCode," +
				" Acctno, description, SalaryAdminId, DeptAdminId) values ('" +
					deptname + "', '" + deptcode + "', " + acctno +  ", '" +
					desc + "', '" + sadmin + "', '" + deptadmin + "')");
	  	} 
		catch (SQLException e)
		{
			stmt.executeUpdate("delete from Admin where adminid = '" + 
				deptadmin + "'");
			throw e;
		}
		try
		{
			toClient.print("Department <b>" + deptname + "</b>(code <b>" + 
				deptcode +"</b>) has been succesfully created<br><br>");
		}
		catch (Exception e)
		{
			toClient.print("Exception: " + e);
		}
		stmt.close();
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  	rs.close();
	  } catch (Exception e) {}
	}
	void DelDept(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Delete Department</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String deptcode = req.getParameter("deptcode").trim().toLowerCase();
		if (deptcode.length() == 0)
			throw new Exception("You cant leave any of the fields blank");
		deptcode = deptcode.toLowerCase();
		rs = stmt.executeQuery("select deptname from department " + 
			" where deptcode = '" + deptcode + "'");
		if (!rs.next())
			throw new Exception("Department code is invalid");
		String deptname = rs.getString(1);
		//Check if dept has persons under it
		stmt.executeUpdate("delete from Department where deptcode = '" +
			deptcode + "'");
		//Log out admin
		stmt.executeUpdate("delete from admin where adminid = '" + deptcode +
			"admin'");
		toClient.print("Department <b>" + deptname + "</b> has been deleted" +
			" successfully<br><br>");
		stmt.close();
	  }
	  catch (Exception e)
	  {
	 	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  	rs.close();
	  } catch (Exception e) {}
	}
	void CalcSalary(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
      Connection conn = null;
	  Statement stmt1 = null;
	  ResultSet rs= null;
	  try
	  {
	  	String action = req.getParameter("action");
		if (action == null)
			throw new Exception("Make a choice on the previous form");
		conn = as.getNewConnection();
		conn.setAutoCommit(false);
		stmt1 = conn.createStatement();
	  	java.util.Date CurrentMonth = Utility.getCurrentMonthDate();
		String currentmonth = Utility.toString(CurrentMonth);
	  	rs = stmt1.executeQuery("select SalaryCode,PrvIncrDate," +
			"CurPayStage, LowerLimit, Increment1, MiddleLimit, Increment2, " +
			" UpperLimit, HasWorkedAfterIncr, LastIncrAmount, " +
			" LastCalculated, HasOwnHouse, Employee.Post, designation.Grade, " +
			" Sex, Address, TISinceMarch, HRASinceMarch, ITPaid " +
			" from Employee,Designation,Payscale " +
	  		" where Employee.post = Designation.post and " +
			" Designation.grade = Payscale.grade");
		SalaryClass.CalcSalary(req, toClient, as, conn, rs, action, null, 
			CurrentMonth, "table");
		rs.close();
		conn.close();
	  }
	  catch (Exception e)
	  {
	  	try
		{
			conn.rollback();
			conn.close();
			stmt1.close();
			rs.close();
		}
		catch (Exception e1) {}
		toClient.println("<br>Error" + e);
		e.printStackTrace();
 	  }
	}
	void putRateOfDA(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Add New DA-Rate</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String rateofda = req.getParameter("rateofda").trim().toLowerCase();
		java.util.Date d = new java.util.Date();
		d.setDate(1);
		int m = d.getMonth();
		if (m <= 5)
			m = 0;
		else
			m = 6;
		d.setDate(1);
		d.setMonth(m);
		stmt.executeUpdate("insert into RateOfDA (ForMonth, Rate) values " +
			"(to_Date('" + Utility.toString(d) + "', 'dd-mm-yyyy'), " +
			rateofda + ")");
		try
		{
			toClient.println("Entry has been made");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	    String err = e.toString().toLowerCase();
		try
		{
			if (err.indexOf("unique constraint") != -1)
			  	throw new Exception("Rate of DA has been entered");
			else
				throw e;
		}
		catch (Exception e2)
		{
			Utility.printError(toClient, e2);
		}
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	void InterestRateReq(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  try
	  {
		IRateReq(req.getParameter("loanname").toLowerCase(), toClient, as);
	  }
	  catch (Exception e) 
	  {
		toClient.println("<html><head><title>Error</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
	  	Utility.printError(toClient, e);
	  }
	}
	void IRateReq(String loanname, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Interest Rates for Loan</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		toClient.println("<form action=" +
			"\"http://" + as.hostname + ":" + as.serverport + 
			"/servlet/AdminServlet\" method=POST>");
		toClient.println("<input type=hidden name=formname " +
			"value=\"interestrate\">");
		toClient.println("<input type=hidden name=loanname " +
			"value=\"" + loanname + "\">");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select applicablefrom, interestrate from " +
			"loanrates where loantype = '" + loanname + "'");
		int i = 1, j = 1;
		toClient.println("<table>");
		while (i <= j + 10)
		{
			String adate = "", rate = "";
			if (rs.next())
			{
				j++;
				adate = Utility.toString(rs.getDate(1));
				rate = rs.getString(2);
			}
			toClient.println("<tr><th>From<th><input type=text name=afrom" + i + 
				" value=\"" + adate +
				"\"><th>Rate <th><input type=text " +
				"name=irate" + i +" value=\"" + rate +
				"\"></tr>");
			i++;
		}
		toClient.println("</table><table><tr><td><input type=submit value=\"Update\"><td>" +
			"<input type=reset></tr></table></form></body></html>");
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	
	void InterestRate(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Update Loan Rates</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = as.conn.createStatement();
		String loanname = req.getParameter("loanname");
		stmt.executeUpdate("delete from loanrates where loantype = '" +
			loanname + "'");
	  	for (int i = 1; req.getParameter("afrom" + i) != null; i++)
		{
			String afrom = req.getParameter("afrom" + i),
				rate = req.getParameter("irate" + i);
			if (afrom.trim().length() == 0)
				continue;
			stmt.executeUpdate("insert into loanrates (loantype ," +
				"applicablefrom, interestrate) values ('" + loanname +
				"', to_date('" + afrom + "', 'dd-mm-yyyy'), " + 
				rate + ")");
		}
		try
		{
			toClient.println("Database updated successfully");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	void NewLoanType(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {
		String loanname = req.getParameter("loanname");
		stmt = as.conn.createStatement();
		stmt.executeUpdate("insert into loannames(loantype) " +
			"values ('" + loanname + "')");
		IRateReq(loanname, toClient, as);
	  }
	  catch (Exception e)
	  {
		toClient.println("<html><head><title>Error</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	

}
	
