

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;

class SalaryAdmin extends Admin
{
	Vector adeptcodes = null, adeptnames = null;
	String sdeptcodes = null;
	public SalaryAdmin(String i, PrintWriter toClient, AdminServlet as)
	{
	  try
	  {
	  	adeptcodes = new Vector(4, 4);
		adeptnames = new Vector(4, 4);
		
		id = i;
		//Find out the departments under this salary-admin
		Statement stmt = as.conn.createStatement();
		ResultSet rs = stmt.executeQuery("select deptname, deptcode from " + 
			"department where salaryadminid = '" + id + "'");
		while (rs.next())
		{	
			adeptnames.addElement(rs.getString(1)); 
			adeptcodes.addElement(rs.getString(2));
		}
		sdeptcodes = Utility.toString(adeptcodes);
		termlist.addElement("$USER$:" + id);
		as.putHtml(toClient, "salaryamain.html", termlist);
	  }
	  catch(Exception e)
	  {
	  	toClient.println("Error: " + e);
	  }
	}
	
	public void doPost(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String formname;
		if ((formname = req.getParameter("formname")) == null)
		{
			toClient.println("Error: Invalid form");
			return;
		}
		if (formname.equals("emplholiday"))
			EmplHoliday(req, toClient, as);
		else if (formname.equals("emplloan"))
			EmplLoan(req, toClient, as);
		else if (formname.equals("chpwadmin"))
			ModifyPasswd(req, toClient, as);
		else if (formname.equals("emplsalaryinforeq"))
			EmplSalaryInfoReq(req, toClient, as);
		else if (formname.equals("emplsalaryinfo"))
			EmplSalaryInfo(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid form");
			return;
		}
	}

	public void doGet(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String action;
		if ((action = req.getParameter("action")) == null)
		{
			toClient.print("Error: Invalid form");
			return;
		}
		else if (action.equals("allemplholidayinfo"))
			AllEmplHolidayInfo(req, toClient, as);
		else if (action.equals("allemplinfo"))
			AllEmplInfo(req, toClient, as);
		else if (action.equals("calcsalary"))
			CalcSalary(req, toClient, as);
		else if (action.equals("alldeptunderme"))
			AllDeptUnderMe(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid action");
			return;
		}
	}
		
	void AllEmplInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of all Employees of " +
			"under " + id + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Id, name, salarycode, " + 
			"dob, sex, hasownhouse, email, post, curpaystage, prvincrdate, " +
			"address, deptname from employee, department where " +
			"employee.deptcode=department.deptcode and salaryAdminId='" + 
			id + "'");

		toClient.println("<table>" +
			"<tr><th>Id<th>Name<th>Salary Code<th>DOB<th>Sex<th>" + 
			"HasOwnHouse<th>EMail<th>Post<th>Current PayStage" + 
			"<th>Last Increment<th>Address<th>Department");
		while (rs.next()) 
		{
			toClient.println("<tr>");
			for (int i = 1; i <= 12; i++)
			{
				if (i != 4 && i != 10)
				  {if(i == 7)
					 toClient.print("<td><a href=mailto:" + rs.getString(i) + ">" + rs.getString(i) + "</a>"); 
					else
					 toClient.print("<td>" + rs.getString(i));
				  }	 
				else
					toClient.print("<td>" + Utility.toString(rs.getDate(i)));
			}
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}

	void AllEmplHolidayInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of leaves of " +
			"employees under " + id + " that were entered this month" +
			"</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Leave.SalaryCode, " +
			"employee.Name, DeptName, LeaveType, FromD, toD" +
			" from leave, employee, department where leave.salarycode = employee.salarycode" +
			" and employee.deptcode = department.deptcode and " +
			"department.SalaryAdminId='" + id + "' " +
			" and (MonthConsidered is null or MonthConsidered=to_Date('" +
			Utility.getCurrentMonth() + "', 'DD-MM-YYYY')) " +
			"order by department.deptcode, employee.name, FromD");

		toClient.println("<table>" +
			"<tr><th>SalaryCode<th>Name<th>Department<th>Leave Type<th>" +
			"From<th>To");
		while (rs.next()) 
		{
			toClient.println("<tr>");
			for (int i = 1; i <= 6; i++)
			{
				if (i == 4)
					//Give actual names of leaves
					toClient.print("<td>" + rs.getString(i));
				else if (i < 5)
					toClient.print("<td>" + rs.getString(i));
				else
					toClient.print("<td>" + Utility.toString(rs.getDate(i)));
			}
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}

	
	void AllDeptUnderMe(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Departments under " + id +
			"</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<b>The following are the departments " +
			"under you:</b><br><br>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select deptname, deptcode" +
			" from department where salaryAdminId='" + id + "'");
		toClient.println("<table border=1><tr><th>Department Name" +
			"<th>Department Code");
		while (rs.next())
		{
			toClient.println("<tr><td>" + rs.getString(1) + "<td>" +
				rs.getString(2));
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}

	}
	
	void EmplHoliday(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Add New Leave Entry</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		String salarycode = req.getParameter("salarycode"),
			fromd = req.getParameter("fromd"),
			tod = req.getParameter("tod"),
			type = req.getParameter("ltype");
		if (salarycode == null || fromd == null || tod == null || type == null)
			throw new Exception("Invalid Form");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select salarycode from employee," +
			" department where salarycode=" + salarycode + 
			" and employee.deptcode = department.deptcode and " +
			"department.salaryadminid='" + id + "'");
		if (!rs.next())
			throw new Exception("No employee with salary-code " + salarycode +
				" under you");
		//Check that this does not overlap with leave an employee has
		//previously taken
		String dtod = "to_Date('" + tod + "', 'DD-MM-YYYY')",
			dfromd = "to_Date('" + fromd + "', 'DD-MM-YYYY')";
		/*rs = stmt.executeQuery("select FromD, toD from Leave where " +
			"salarycode = " + salarycode + " and ((FromD < fromD*/

		//After above check, insert
		stmt.executeUpdate("insert into leave (SalaryCode, LeaveType, " +
			"FromD, ToD) values (" + salarycode + ", '" + type +
			"', " + dfromd + ", " + dtod + ")");
	  	try
		{
			toClient.println("Entry has been successfully made");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	void EmplLoan(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Add New Loan Entry</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
	    //If Loan is new, ask if it is to be credited to salary
		//and start deduction from next month
		String salarycode = req.getParameter("salarycode"),
			loanid = req.getParameter("loanid"),
			type = req.getParameter("ltype"),
			isnewloan = req.getParameter("isnewloan"),
			amounttaken = req.getParameter("amounttaken"),
			dedquantum = req.getParameter("dedquantum"),
			recoverystart = req.getParameter("recoverystart"),
			payinsalary = req.getParameter("payinsalary"),
			dueamount = req.getParameter("dueamount"),
			interestaccumulated = req.getParameter("interestaccumulated"),
			datetaken = req.getParameter("datetaken");
		//Error check
		if (isnewloan.equals("Y"))
		{
			dueamount = amounttaken;
			datetaken = Utility.toString(new java.util.Date());
			interestaccumulated = "0";
		}
		else
		{
			payinsalary = "N";
		}
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select salarycode from employee," +
			" department where salarycode=" + salarycode + 
			" and employee.deptcode = department.deptcode and " +
			"department.salaryadminid='" + id + "'");
		if (!rs.next())
			throw new Exception("No employee with salary-code " + salarycode +
			"', " + interestaccumulated + ")");
		stmt.executeUpdate("insert into loan (SalaryCode, LoanID, " +
			"Type, DateTaken, AmountTaken, DueAmount, " +
			"DedQuantum, RecoveryStart, MonthPaid, PayInSalary, " +
			"InterestAccumulated)" +
			" values (" + salarycode + ", '" + loanid + "', '" + type +
			"', to_Date('" + datetaken + "', 'DD-MM-YYYY'), " + 
			amounttaken + ", " + dueamount + ", " +
			dedquantum +  ", " + recoverystart +  ", null, '" + payinsalary + 
			"', " + interestaccumulated + ")");
	  	try
		{
			toClient.println("Entry has been successfully made");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	void EmplSalaryInfoReq(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		String salarycode = req.getParameter("salarycode");
		stmt = as.conn.createStatement();
		String currentmonth = Utility.getCurrentMonth();
		rs = stmt.executeQuery("select salarycode from employee," +
			" department where salarycode=" + salarycode + 
			" and employee.deptcode = department.deptcode and " +
			"department.salaryadminid='" + id + "'");
		if (!rs.next())
		{
			toClient.println("<html><head><title>Error</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
			throw new Exception("No employee with salary-code " + salarycode +
				" under you");
		}
		toClient.println("<html><head><title>Enter salary details for " +
			salarycode + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>" +
			"<form action=" +
			"\"http://" + as.hostname + ":" + as.serverport + 
			"/servlet/AdminServlet\" method=POST>");
		toClient.println("<input type=hidden name=formname " +
			"value=\"emplsalaryinfo\"><input type=hidden name=salarycode " +
			"value=\"" + salarycode + "\"><br>");
		rs = stmt.executeQuery("select TransAllowance, ConsulHon, OTA, CEA, " +
			" cpfsubs, CPFAdvRefund, NPA, LicenseFee, WaterCharge, " +
			" currentcharge, LIP, PayAndAllowance, ProfessionTax, GroupIns" +
			" from salaryDetails " +
			" where salarycode = " + salarycode + " and salarydate is null");
		String transallowance = "0", consulhon = "0", ota = "0", cea = "0",
			cpfsubs = "0",  licensefee = "0", watercharge = "0", 
			currentcharge = "0", lip = "0", professiontax = "0", groupins = "0";
		if (!rs.next())
		{
			//Create a new blank record
			stmt.executeUpdate("insert into SalaryDetails (SalaryCode, " +
				"SalaryDate, BasicPay, DA, HRA, CCA, TransAllowance, ConsulHon, " +
				"OTA, CEA, otherpays, grosspay, cpfsubs, CPFAdvRefund, " + 
				"NPA, ITax, LicenseFee," +
				"WaterCharge,  currentcharge, LIP, PayAndAllowance, " + 
				"ProfessionTax, GroupIns, OtherDeds, TotalDed, NetSalary)"  +
				" values (" + salarycode + 
				", null, 0, 0, 0, 0, 0, 0, " +
				"0, 0, 0, 0, 0, 0, 0, 0, 0, " +
				"0, 0, 0, 0, 0, 0, 0, 0, 0)");
		}
		else
		{
			transallowance = rs.getString(1); consulhon = rs.getString(2);
			ota = rs.getString(3); cea = rs.getString(4);
			cpfsubs = rs.getString(5); licensefee = rs.getString(8);
			watercharge = rs.getString(9); currentcharge = rs.getString(10);
			lip = rs.getString(11);
			professiontax = rs.getString(13); groupins = rs.getString(14);
		}
	    toClient.println("<table>");
		toClient.println("<tr><th>Transfer Allowance <td><input type=text " + 
			"name=transallowance value=\"" +  transallowance + "\"></tr>");
		toClient.println("<tr><th> Consultancy/Honarary Fees<td> <input type=text " + 
			"name=consulhon value=\"" + consulhon + "\"></tr>");
		toClient.println("<tr><th>  OTA<td> <input type=text " + 
			"name=ota value=\"" + ota + "\"></tr>");
		toClient.println("<tr><th> CEA <td><input type=text " + 
			"name=cea value=\"" + cea + "\"></tr>");
		toClient.println("<tr><th> CPF Subs<td><input type=text " + 
			"name=cpfsubs value=\"" + cpfsubs + "\"></tr>");
		toClient.println("<tr><th> License Fee <td><input type=text " + 
			"name=licensefee value=\"" + licensefee + "\"></tr>");
		toClient.println("<tr><th> Water Charge <td><input type=text " + 
			"name=watercharge value=\"" + watercharge + "\"></tr>");
		toClient.println("<tr><th> Electricity Charge<td> <input type=text " + 
			"name=currentcharge value=\"" + currentcharge + "\"></tr>");
		toClient.println("<tr><th> LIP <td><input type=text " + 
			"name=lip value=\"" + lip + "\"></tr>");
		toClient.println("<tr><th> Profession Tax <td><input type=text " + 
			"name=professiontax value=\"" + professiontax + "\"></tr>");
		toClient.println("<tr><th> Group Insurance<td> <input type=text " + 
			"name=groupins value=\"" + groupins + "\"></tr></table><table>");
		rs = stmt.executeQuery("select 'a' as type, description, amount" +
			" from otherpay where salarycode = " + salarycode + 
			" and salarydate is null" +
			" union select 'd' as type, description, amount" +
			" from otherded where salarycode = " + salarycode +
			" and salarydate is null");
		int i = 1, j = 1;
		while (i <= j + 10)
		{
			String selecteda = " selected", selectedb = "",  payname ="", 
				payamount = "0";
			if (rs.next())
			{
				j++;
				if (rs.getString(1).equals("d"))
				{
					selecteda = "";
					selectedb = " selected";
				}
				payname = rs.getString(2);
				payamount = rs.getString(3);
			}
			toClient.println("<tr><th><select name=type" + i + ">" +
				"<option value=a" + selecteda + ">Allowance" +
				"<option value=d" + selectedb + ">Deduction" +
				"</select><th>Name<th> <input type=text name=payname" + i + 
				" value=\"" + payname + "\"><th>Amount <th><input type=text " +
				"name=payamount" + i +" value=\"" + payamount + "\"></tr>");
			i++;
		}
		toClient.println("</table><table><tr><td><input type=submit value=\"Update\"><td>" +
			"<input type=reset></tr></table></form></body></html>");
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	void EmplSalaryInfo(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  Statement stmt = null;
	  try
	  {

		toClient.println("<html><head><title>Response to Enter Salary Details</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		String salarycode = req.getParameter("salarycode").toLowerCase(),
			transallowance = req.getParameter("transallowance").toLowerCase(), 
			consulhon = req.getParameter("consulhon").toLowerCase(),
			ota = req.getParameter("ota").toLowerCase(), 
			cea = req.getParameter("cea").toLowerCase(),
			cpfsubs = req.getParameter("cpfsubs").toLowerCase(),
			licensefee = req.getParameter("licensefee").toLowerCase(),
			watercharge = req.getParameter("watercharge").toLowerCase(),
			currentcharge = req.getParameter("currentcharge").toLowerCase(),
			lip = req.getParameter("lip").toLowerCase(),
			professiontax = req.getParameter("professiontax").toLowerCase(),
			groupins = req.getParameter("groupins").toLowerCase(),
			currentmonth = Utility.getCurrentMonth();
		stmt = as.conn.createStatement();
		//Change this to a set statement later
		stmt.executeUpdate("delete from salarydetails where salarycode = " +
			salarycode + " and salarydate is null");
		stmt.executeUpdate("delete from otherpay where salarycode = " +
			salarycode + " and salarydate is null");
		stmt.executeUpdate("delete from otherded where salarycode = " +
			salarycode + " and salarydate is null");
		
		stmt.executeUpdate("insert into SalaryDetails (SalaryCode, " +
				"SalaryDate, BasicPay, DA, HRA, CCA, TransAllowance, ConsulHon, " +
				"OTA, CEA, otherpays, grosspay, cpfsubs, CPFAdvRefund, " + 
				"NPA, ITax, LicenseFee," +
				"WaterCharge,  currentcharge, LIP, PayAndAllowance, " + 
				"ProfessionTax, GroupIns, OtherDeds, TotalDed, NetSalary)"  +
				" values (" + salarycode +
				", null, 0, 0, 0, 0, " + transallowance + ", " +
				consulhon + ", " + ota + ", " + cea + ", 0, 0, " + cpfsubs +
				", 0, 0, 0, " + licensefee + ", " + watercharge + ", " +
				currentcharge + ", " + lip + ", 0, " + professiontax + ", " +
				groupins + ", 0, 0, 0)");
	  	for (int i = 1; req.getParameter("payname" + i) != null; i++)
		{
			String payname = req.getParameter("payname" + i),
				type = req.getParameter("type" + i),
				payamount = req.getParameter("payamount" + i);
			if (payname.trim().length() == 0)
				continue;
			if (type.equals("a"))
				stmt.executeUpdate("insert into otherpay (salarycode, " +
					"salarydate, description, amount) values (" + salarycode +
					", null, '" +
					payname + "', " + payamount + ")");
			else
				stmt.executeUpdate("insert into otherded (salarycode, " +
					"salarydate, description, amount) values (" + salarycode +
					", null, '" +
					payname + "', " + payamount + ")");
		}
		try
		{
			toClient.println("Database updated successfully");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e) {}
	}
	void CalcSalary(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
      Connection conn = null;
	  Statement stmt1 = null;
	  ResultSet rs= null;
	  try
	  {
	  	String action = "view";
		conn = as.getNewConnection();
		conn.setAutoCommit(false);
		stmt1 = conn.createStatement();
	  	java.util.Date CurrentMonth = Utility.getCurrentMonthDate();
		String currentmonth = Utility.toString(CurrentMonth);
	  	rs = stmt1.executeQuery("select SalaryCode,PrvIncrDate," +
			"CurPayStage, LowerLimit, Increment1, MiddleLimit, Increment2, " +
			" UpperLimit, HasWorkedAfterIncr, LastIncrAmount, " +
			" LastCalculated, HasOwnHouse, Employee.Post, designation.Grade, " +
			" Sex, Address, TISinceMarch, HRASinceMarch, ITPaid " +
			" from Employee,Designation,Payscale, department " +
	  		" where Employee.post = Designation.post and " +
			" Designation.grade = Payscale.grade" +
			" and employee.deptcode = department.deptcode and " +
			" department.salaryadminid='" + id + "'");
		SalaryClass.CalcSalary(req, toClient, as, conn, rs, action, null, 
			CurrentMonth, "flat-style");
		rs.close();
		conn.close();
	  }
	  catch (Exception e)
	  {
	  	try
		{
			conn.rollback();
			conn.close();
			stmt1.close();
			rs.close();
		}
		catch (Exception e1) {}
		toClient.println("<br>Error" + e);
		e.printStackTrace();
 	  }
	}
	
}
