
import java.lang.*;
import java.io.*;
import java.sql.*;
import java.util.*;

public class jdbc
{
	Statement stmt = null;
	BufferedReader inp = null;
	DatabaseMetaData dbmd = null;
	void execSelect(String s) throws SQLException
	{
		ResultSet rs = stmt.executeQuery(s);
		ResultSetMetaData rsmd = rs.getMetaData();
		for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
			System.out.print( rsmd.getColumnName(i)  + "\t" );
		}
		System.out.print( "\n" );
		System.out.println( "-------------------------------------------------------------------------------" );

		while (rs.next()) 
		{
			for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
				System.out.print( rs.getString(i) + "\t" );
			}
			System.out.print( "\n" );
		}
	}
	void execInsert() throws SQLException, IOException
	{
	    
		BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
		System.out.print("Enter table name: ");
		String tname = inp.readLine();
		tname = tname.toUpperCase();
		ResultSet rs = dbmd.getColumns( null, "PASHOK", tname, null );
		String ustmt = "insert into " + tname + " values (";
		boolean first = true;
		while (rs.next())
		{
			System.out.print(rs.getString(4) + "[" + rs.getString(6) + "]:\t");
			String s = inp.readLine();
			if (!s.toLowerCase().equals("null"))
			{
				if (rs.getString(6).indexOf("CHAR") != -1)
					s = "'" + s + "'";
				else if (rs.getString(6).indexOf("DATE") != -1)
					s = "to_date('" + s + "', 'dd-mm-yyyy')";
			}
			if (first)
			{
				first = false;
				ustmt += s;
			}
			else
			{
				ustmt += (", " + s);
			}
		}
		ustmt += ")";
		System.out.println(ustmt);
		stmt.executeUpdate(ustmt);
		
	}
	void execDelete() throws SQLException, IOException
	{
		System.out.print("Enter table name: ");
		String tname = inp.readLine();
		System.out.print("Enter the delete condition: ");
		String condn = inp.readLine();
		stmt.executeUpdate("delete from " + tname + " where " + condn);
	}
	void execHelp() throws SQLException, IOException
	{
	    
		//BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
		System.out.print("Enter table name(Hit ENTER for help on all tables): ");
		String tname = inp.readLine();
		if (tname.length() == 0)
			tname = "%";
		tname = tname.toUpperCase();
		ResultSet rs = dbmd.getTables( null, "PASHOK", tname, null );
		while (rs.next()) 
		{
			System.out.println("Info of table " + rs.getString(3));
			ResultSet rstable = dbmd.getColumns(rs.getString(1), 
				rs.getString(2), rs.getString(3), null);
			ResultSetMetaData rsmd = rstable.getMetaData();
			for( int i = 1; i <= rsmd.getColumnCount(); i++ ) 
			{
				//Eliminate unnessary fields
				if (i <= 3 || i == 5 || i == 8 || i == 10 || i == 13 ||
				  i == 14 || i == 15 || i == 16)
					continue;
				System.out.print( rsmd.getColumnName(i)  + "\t" );
			}
			System.out.print( "\n" );
			System.out.println( "-------------------------------------------------------------------------------" );
			while (rstable.next()) 
			{
				for( int i = 1; i <= rsmd.getColumnCount(); i++ ) 
				{
					//Eliminate unnessary fields
					if (i <= 3 || i == 5 || i == 8 || i == 10 || i == 13 ||
					  i == 14 || i == 15 || i == 16)
						continue;
					System.out.print( rstable.getString(i) + "\t" );
				}
				System.out.print( "\n" );
			}
			System.out.print("\n\n");

		}
		
		
	}//*/
	void execSyntax()
	{
		System.out.print("SELECT:\n\tEnter the SQL query on the command" + 
			" line itself\nINSERT, DELETE, and HELP:\n\tJust type the command" +
			" at the prompt and entire required info.\n");
	}
	public void mymain()
	{
	  try
	  {
		inp = new BufferedReader(new InputStreamReader(System.in));
		PreparedStatement pstmt = null;
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		Connection myCom =
		DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","PASHOK","nawal");
		dbmd = myCom.getMetaData();
		stmt = myCom.createStatement();
		System.out.println("Type syntax for syntax of commands allowed. Login of PASHOK.");
		do
		{
		  try
		  {
			System.out.print("MySQL> ");
			String opt = inp.readLine();
			if (opt == null)
			{
				System.out.println("");
				break;
			}
			opt = (opt.trim()).toLowerCase();
			if (opt.startsWith("select"))
				execSelect(opt);
			else if (opt.equals("insert"))
				execInsert();
			else if (opt.equals("delete"))
				execDelete();
			else if (opt.equals("help"))
				execHelp();
			else if (opt.equals("syntax"))
				execSyntax();
			else if (opt.equals("exit"))
				break;
			else if (opt.length() == 0)
				continue;
			else 
			{
				System.out.println("Invalid command '" + opt + "'");
			}//*/
		  }
		  catch (SQLException sqle)
		  { 
			System.out.println("Error : " + sqle);
		  }
		  
		} while(true);
	
	  }
	  catch (SQLException sqle)
	  { 
		System.out.println("SQLException : " + sqle);
	  }
	  catch (IOException ioe)
	  { 
		System.out.println("IOException : " + ioe);
	  }//*/
	}
	public static void main(String argv[])
	{
		try
		{
			jdbc j = new jdbc();
			j.mymain();
		}
		catch (Exception e)
		{
			System.out.println("Exception: " + e);
		}
	}
}
