package DBIS.Configurator.DBM;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PlotPageGenerator;
import DBIS.Tools.ErrorPageGenerator;
import DBIS.Configurator.MenuHandler;
import DBIS.Configurator.MenuManager;
import DBIS.Configurator.Plotters.SinglePlotter;
import DBIS.Configurator.DBM.AllRoomBrowse;

/** This class handles the main menu of Data browse menu*/
public class MainMenuHandler extends MenuHandler {

	public MainMenuHandler(ServletRequest request)	{
		super(request);
	}

	protected void initialise()	{
		menuName="DBM";
	}

	public String handleRequest()	{
		String toReturn=super.handleRequest();
		if(toReturn!=null)	return toReturn;

		Vector paramVec=getParameterVector();
		String option=request.getParameter("option");
		String type=request.getParameter("type");
		
		if(option.equals("BrowseItems"))	{
			toReturn=(new AllRoomBrowse()).format();
		}
		return toReturn;
	}
}
