package DBIS.Configurator.PersonalizeMenu;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.io.FileInputStream;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;


abstract public class AddOption extends PageGenerator 	{

	public AddOption(HtmlTemplate _template)	{
		super(_template);
	}


	/** In this case we are overloading the format function Basically
	 * the AllPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();
		String element;
		String tag;
		while(enumeration.hasMoreElements())	{
			element=(String)enumeration.nextElement();
			tag="";
			if(element.equals("$$DBIS_SERVLET_ADDOPTION$$"))	{
				tag=getServlet();
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

	abstract protected String getServlet();
}



