package DBIS.Configurator.PersonalizeMenu;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.ErrorPageGenerator;
import DBIS.Tools.ConfirmationPageGenerator;
import DBIS.Configurator.MenuHandler;
import DBIS.Configurator.MenuManager;
import DBIS.Tools.ConfirmationPageGenerator;
import DBIS.Configurator.PersonalizeMenu.AddSqlQuery;

/** This class handles the main menu of Data browse menu*/
public class MainMenuHandler extends MenuHandler {

	public MainMenuHandler(ServletRequest request)	{
		super(request);
	}

	protected void initialise()	{
		menuName="PersonalizeMenu";
	}

	public String handleRequest()	{
		String toReturn=super.handleRequest();
		if(toReturn!=null)	return toReturn;
		
		String option=request.getParameter("option");
		String type=request.getParameter("type");
		if(option.equals("AddSqlQuery"))	{
			toReturn=(new AddSqlQuery()).format();
		}
		else if(option.equals("AddPlotter"))	{
			toReturn=(new AddPlotter()).format();
		}
		return toReturn;
	}
}

