package DBIS.Components;

import java.sql.*;
import java.util.Vector;
import java.util.Vector;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Components.Item;

/** This generates information about all products These products
 * are arranged in sorted order by the give criterion Primarily
 * a vector of elements in increasing order of the mentioned parameter
 * is returned Each element of this vector is an element of type Item*/
public class AllItems {
	
	String orderBy="item_name";
	String orderNature="asc";
	Vector resultVec=new Vector(1,1);

	public AllItems()	{
		initialise();
	}

	public AllItems(String orderBy,String orderNature)	{
		this.orderBy=orderBy;
		this.orderNature=orderNature;
		initialise();
	}

	public void initialise()	{
		try {	
			String query=Singleton.DBIS_SQL_INCOM_ALLITEM;
			query=Singleton.substituteString(query,"$$DBIS_SQL_ORDERBY$$",orderBy);
			query=Singleton.substituteString(query,"$$DBIS_SQL_ORDERNATURE$$",orderNature);
			ResultSet rs=QueryEngine.executeQuery(query);
			while(rs.next())	{
				resultVec.addElement(new Item(rs));
			}
		}catch(SQLException sqle){ System.out.println(getClass().getName()+" : "+ sqle); return;}
	}

	public Vector getElements()	{
		return resultVec;
	}

	public static void main(String args[])	{
		Vector vector=(new AllItems()).getElements();
		for(int i=0;i<vector.size();i++)	{
			((Item)vector.elementAt(i)).display();
		}
	}
}
