package DBIS.Configurator.Plotters;

import java.sql.*;
import DBIS.Tools.QueryEngine;
import DBIS.Configurator.Plotters.Plotter;

abstract public class MultiplePlotter extends Plotter	{

	String query[];
	String labelParameters[];
	String valParameters[];
	String legend[];
	String colorParameters[];

	public MultiplePlotter(String query[],String legend[])	{
		this.query=query;
		this.legend=legend;
		initialise();
	}

	protected String getRandomColor(int num)	{
		int num1=(num%10)*11;
		int num2=((num*num*13+23)%10)*11;
		int num3=((num*23+103)%10)*11;
		return ""+num1+""+num2+""+num3;
	}

	public void initialise()	{
		labelParameters=new String[query.length];
		valParameters=new String[query.length];
		colorParameters=new String[query.length];
		for(int i=0;i<query.length;i++)	{
			ResultSet rs=QueryEngine.executeQuery(query[i]);
			if(rs==null)	{
				labelParameters[i]="Error";
				valParameters[i]="0";
				continue;
			}
			labelParameters[i]="";
			valParameters[i]="";
			colorParameters[i]=getRandomColor(i);
			try {
				boolean flag=false;
				while(rs.next())	{
					String tmpLabel=rs.getString(1);
					String tmpVal=rs.getString(2);
					if(flag)	{
						labelParameters[i]+=",";
						valParameters[i]+=",";
					}
					labelParameters[i]+=tmpLabel;
					valParameters[i]+=tmpVal;
					flag=true;
				}
			}catch(SQLException e) {e.printStackTrace();}
		}
	}
				

	public String getEnumeratedCode()	{
		String parameters="";
		String label;
		String legend;
		String y;
		String color;
		String num;
		for(int i=0;i<query.length;i++)	{
			label=labelParameters[i];
			legend=this.legend[i];
			y=valParameters[i];
			color=colorParameters[i];
			num=(i==0)?	""	:	i+"";
			parameters+="<param name=label"+num+" value=\""+label+"\">\n";
			parameters+="<param name=legend"+num+" value=\""+legend+"\">n";
			parameters+="<param name=y"+num+" value=\""+y+"\">\n";
			parameters+="<paran name=color"+num+" value=\""+color+"\">n";
		}
		return parameters;
	}
}



