package DBIS.Configurator.Plotters;

import java.sql.*;
import DBIS.Tools.QueryEngine;
import DBIS.Configurator.Plotters.Plotter;

abstract public class SinglePlotter extends Plotter	{

	String query;
	String labelParameters;
	String valParameters;

	public SinglePlotter(String query)	{
		this.query=query;
		initialise();
	}

	public void initialise()	{
		ResultSet rs=QueryEngine.executeQuery(query);
		if(rs==null)	{
			labelParameters="Error";
			valParameters="100";
			return;
		}
		labelParameters="";
		valParameters="";
		try {
			boolean flag=false;
			while(rs.next())	{
				String tmpLabel=rs.getString(1);
				String tmpVal=rs.getString(2);
				if(flag)	{
					labelParameters+=",";
					valParameters+=",";
				}
				labelParameters+=tmpLabel;
				valParameters+=tmpVal;
				flag=true;
			}
		}catch(SQLException e) {e.printStackTrace();}
	}
				
	
}
