package DBIS.RoomSpace;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;

/** This generates a html page which contains all items These are
 * primarily links to the item page*/
public class AllItemPageGenerator	extends PageGenerator {

	String orderBy="item_name";
	String orderNature="asc";

	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_ROOMSPACE_ALLITEMSTEMPLATEFILE);
	}
	
	public AllItemPageGenerator()	{
		super(AllItemPageGenerator._template);
	}

	public AllItemPageGenerator(String orderBy,String orderNature)	{
		super(AllItemPageGenerator._template);
		this.orderBy=orderBy;
		this.orderNature=orderNature;
	}

	public AllItemPageGenerator(String orderBy)	{
		super(AllItemPageGenerator._template);
		this.orderBy=orderBy;
	}

	public AllItemPageGenerator(HtmlTemplate _template,String orderBy,String orderNature)	{
		super(_template);
		this.orderBy=orderBy;
		this.orderNature=orderNature;
	}


	/** In this case we are overloading the format function Basically
	 * the AllPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();

		String query="select * from Item order by "+orderBy+" "+orderNature; 
		ResultSet rs=QueryEngine.executeQuery(query);
		if(rs==null)	{
			while(enumeration.hasMoreElements())	{
				hashtable.put((String)enumeration.nextElement(),"Unknown");
			}
			return hashtable;
		}
		String allItemsLink="";
		String table="<table>\n";

		try {
			while(rs.next())	{
					table+="<tr>";
					table+=getRow(rs);
					table+="</tr>\n";
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table>\n";
		while(enumeration.hasMoreElements())	{
			String element=(String)enumeration.nextElement();
			String tag="";
			if(element.equals("$$DBIS_ALLITEMS_LINKS$$"))	{
				tag=table;
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

	protected String getRow(ResultSet rs)	{
		String row="<td>";
		String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_ITEMPAGE);
		try {
			int itemId=rs.getInt("item_id");
			String name=rs.getString("item_name");	
			String servletLine=servlet+"?itemId="+itemId;
			String finalLine="<b><a HREF=\""+servletLine+"\"> "+name+"</a></b>";
			row+=finalLine;
		}catch(SQLException e) {e.printStackTrace();}
		row+="</td>";
		return row;
	}

	public static void main(String args[])	{
		System.out.println((new AllItemPageGenerator()).format());
	}
}
