package DBIS.RoomSpace;

import java.sql.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.StringTokenizer;
import DBIS.Tools.HtmlTemplate;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Components.Item;

/** This class generates the page for the item with the suppiled
 * item id At first theinformation about the item is retrived
 * and is then used to get the requisite page*/
public class RoomPageGenerator	extends PageGenerator	{
 
	int roomId=-1;

	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_ROOMSPACE_ROOMTEMPLATEFILE);
	}
	
	public RoomPageGenerator(int roomId)	{
		super(RoomPageGenerator._template);
		this.roomId=roomId;
	}

	public RoomPageGenerator(HtmlTemplate _template,int roomId)	{
		super(_template);
		this.roomId=roomId;
	}
	/** In this case we are overloading the format function Basically
	 * the RoomPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();
		String name="";
		String desc="";
		int parentId=-1;
		ResultSet current=QueryEngine.executeQuery("select * from Room where room_id="+roomId);
		try {
			current.next();
			name=current.getString("room_name");
			desc=current.getString("room_desc");
			parentId=current.getInt("par_room_Id");
		}catch(SQLException e) {e.printStackTrace();}

		while(enumeration.hasMoreElements())	{
			String tmp=(String)enumeration.nextElement();
			String tag="";
			if(tmp.equals("$$DBIS_ROOMSPACE_ROOMNAME$$"))	{
				tag=name;
			}
			if(tmp.equals("$$DBIS_ROOMSPACE_ROOMID$$"))	{
				tag=roomId+"";
			}
			if(tmp.equals("$$DBIS_ROOMSPACE_DESCRIPTION$$"))	{
				tag=desc;
			}
			if(tmp.equals("$$DBIS_ROOMSPACE_PARENTLINK$$"))	{
				String servlet=getServlet();
				int itemId=parentId;
				String logo="Go to Parent Category";	
				String servletLine=servlet+"?roomId="+itemId;
				String finalLine="<b><a HREF=\""+servletLine+"\"> "+logo+"</a></b>";
				tag=finalLine;
			}
			if(tmp.equals("$$DBIS_ROOMSPACE_CHILDLINKS$$"))	{
				String childLinks=getChildLinks();
				tag=childLinks;
			}
			if(tmp.equals("$$DBIS_ROOMSPACE_PRODUCTLINKS$$"))	{
				String productLinks=getProductLinks();
				tag=productLinks;
			}
			hashtable.put(tmp,tag);
		}
		return hashtable;
	}

	public String getChildLinks()	{
		String childLinks="";
		String table="<table>\n";
		ResultSet rs=QueryEngine.executeQuery("select * from Room where par_room_id="+roomId);		

		try {
			while(rs.next())	{
					String servlet=getServlet();
					String itemId=rs.getString("room_id");
					String desc=rs.getString("room_desc");
					if(itemId.equals(roomId+""))	continue;
					table+="<tr>";
					table+="<td>";
					String name=rs.getString("room_name");	
					String servletLine=servlet+"?roomId="+itemId;
					String finalLine="<b><font size=+2><a HREF=\""+servletLine+"\"> "+name+"</a></font></b>";
					table+=finalLine;
					table+="</td>";
					table+="<td>"+desc+"...</td>";
					table+="</tr>\n";
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table>\n";
		childLinks+=table;
		return childLinks;
	}

	public String getProductLinks()	{
		String query="select unique Item.item_id,item_name from RoomItems ,Item  where Item.item_id=RoomItems.item_id and room_id="+roomId;
		ResultSet rs=QueryEngine.executeQuery(query);

		if(rs==null)	{
			return "ERROR";
		}

		String allItemsLink="";
		String table="<table>\n";

		try {
			while(rs.next())	{
				table+="<tr>";
				String row="<td>";
				String servlet=getItemServlet();
				try {
					int itemId=rs.getInt("item_id");
					ResultSet tmp=QueryEngine.executeQuery("select * from Item where item_id="+itemId);
					tmp.next();
					String desc=tmp.getString("description");
					int len=25;
					if(desc.length()<=25)
						len=desc.length();
					desc=desc.substring(0,len);
					String name=rs.getString("item_name");	
					String servletLine=servlet+"?itemId="+itemId;
					String finalLine="<b><font size=+2><a HREF=\""+servletLine+"\"> "+name+"</a></font></b>";
					row+=finalLine;
					row+="</td>";
					row+="<td>"+desc+"...</td>";
					table+=row;	
					table+="</tr>\n";
				}catch(SQLException e) {e.printStackTrace();}
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table>\n";
		allItemsLink+=table;
		return allItemsLink;
	}

	protected String getServlet()	{
		String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_ROOMPAGE);
		return servlet;
	}

	protected String getItemServlet()	{
		String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_ITEMPAGE);
		return servlet;
	}

}		
