import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.lang.*;
import java.sql.*;
import DBIS.Tools.*;


/**This servlet transfer the shoppers items from her shopping cart
 * to the despatch table.
 * It is invoked by the when the user clicks the despatch button
 * on the form generated by the <code>ViewShoppinCart</code> class. 
 * @author Dilys  Thomas
					Fri Oct  6 18:01:15 IST 2000
 */

public class Despatch extends HttpServlet {

 private Connection con;	
 private MyUtil myconf;
/**sets up the database connection and initialises the  the servlet.
 * @param 	<code>ServletConfig</code>
 * 
 */

public void init(ServletConfig config) throws ServletException
{
	super.init(config);
	try {
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con =DriverManager.getConnection(Singleton.DBIS_SQL_CONF,Singleton.DBIS_SQL_USERNAME,Singleton.DBIS_SQL_PASSWORD);
//		con =DriverManager.getConnection(Config.connection,Config.loginid,Config.password);
		myconf=new MyUtil();
		} catch (SQLException e) { 
		   throw new UnavailableException(this,"Could not Connect To the Database!!");}
}


	 /**The  function handles the classes main functoinality 
	  * by invoking the <code>despatch</code> function which  is private to this 
	  * class.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */

public void doPost(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException  
{
try{
 	Statement stmt;
    ResultSet rset;
	stmt = con.createStatement();
    res.setContentType("text/html");
    PrintWriter toClient = res.getWriter();
    // Get the current session object, create one if necessary
    HttpSession session = req.getSession(true);
  	String user_id=(String)session.getValue("user_id");
	String priority=req.getParameter("priority");
	toClient.println("<html> <head> </head> ");
	toClient.println(Singleton.DBIS_HTML_CSS);
	if (user_id == null)
	{
		 toClient.println("Please authenticate !!");
		 toClient.println("Either your session has expired or you have not yet logged in");
		 toClient.println("Login now to proceed");
		 toClient.println("<A HREF="+Singleton.DBIS_SQL_LOGINURL+"> Login Now!</A>");
	     toClient.println("</html>");
	}
    else
	{
		despatch(user_id,stmt,priority); 
	}
    ViewShoppingCart.generatePage(req,res);
// toClient.println("Your request has been  processed");
// toClient.println("To view your Updated cart click below");
// toClient.println("<body>");
// toClient.println("<form action="+Singleton.DBIS_SERVLET_BASEURL+"ViewShoppingCart  method=GET>");
// toClient.println("<BR><BR><input type=submit value=ViewCart>");
// toClient.println("</form></body></html>");
 } catch (SQLException e) { System.out.println("SQLexception"+e);} 
}


//basic algo for next function
// 			  select fieldvalue  from
// 			  globalvarz where fieldname='despatch_count';
//**********************
// 			  despatcount=fieldvalue->extract.
// 			  **********************
//			  update Globalvarz set count=despatcount+1 corresponding to
//			  despatch_id
//			  ******************
//			  insert into DespatchTable  
//				   select  despatchid, user_id, item_id,quantity,
//			  				priority
//				   from Globalvarz, Shoppingbasket
//				   where user_id ='name'
//
//	*********************
//			delete from  ShoppingBasket
//				where user_id='name'
//				****************************
//		//end synchronized!!!!!!!!!!!!!!	
//			


/**This function actually deletes the entries from the users shopping cart
 * and adds it to  the the despatch table.
 * This entire operation must be an atomic operation and hence
 * the function is appropriately 'synchronized'
 */
synchronized private void despatch(String user_id,Statement stmt,String priority) throws SQLException
{
	 ResultSet rset;
	 String Query="select Item.item_id , quantity , price from ShoppingBasket ,Item where ((Shoppingbasket.item_id =Item.item_id) and (user_id='"+user_id+"' ))";
//	 String query="select item_id , quantity from ShoppingBasket where ( user_id = '"+ user_id +"' )"; 
	 System.out.println(Query);
	 rset=stmt.executeQuery(Query);
	 int despatchcount;
	 int item_id;
	 int quantity;
	 int unitprice;
/* I got really stumped debuging this when i realised that the loop which
 * follows i run only once:I looked up[ the API and foun the following::
	  ResultSet is automatically closed by the Statement that generated it
      when that Statement is closed, re-executed, or is used to retrieve the
     next result from a sequence of multiple results.
 */
	 
	 System.out.println("HHHHHHHHHHHHHEEEEEEEEEEEEERE" );
	 while(rset.next())
	 {
	 	  System.out.println("in loop");
		  item_id=rset.getInt(1);
		  quantity=rset.getInt(2);
		  unitprice=rset.getInt(3);
		  despatchcount=myconf.incrdespatchcount(stmt);//done atomically!
		  String updatestr="insert into DespatchTable values('"+despatchcount+"','"+user_id+"','"+item_id+"','"+quantity+"','"+priority+"')";
		  System.out.println(updatestr);
		  stmt.executeUpdate(updatestr);
          String updatestr2="delete from ShoppingBasket where ((user_id = '"+ user_id +"') and (item_id = "+ item_id+"))"; 
		  System.out.println(updatestr2);
		  stmt.executeUpdate(updatestr2);
		String updatestr3="insert into Saleslogs values('"+user_id+"','"+item_id+"','"+unitprice+"','"+quantity+"')";
		  System.out.println(updatestr3);
		  stmt.executeUpdate(updatestr3);
		  
		  rset=stmt.executeQuery(Query);
		  //I have to re-execute this
		  //query in my loop because of the explanantoin given at the
		  //beginning of the function
	}
}

}
