import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.lang.*;
import java.sql.*;
import DBIS.Tools.*;



/**
 * This servelet is a utility by which the user can view her shopping cart.
 * It has three basic functions:-
 * <ol>
 * <li>Allow the user to  view her cart .
 * This is managed by <code>ViewShoppingCart</code>(this) servlet
 * <li>Allow the user to update the quantity of items in  her cart.
 * This is managed  by the <code>Updatecart</code> servlet invoked by this servlet.
 * <li>Allow the user to transfer goods from the cart to the despatch table
 *This is managed by the <code>Despatch</code> servlet invoked by this servlet.
 * <ol>
 *
 * @author Dilys  Thomas
 * @version 1.00, 	Sun Oct  1 23:39:38 IST 2000
 */

public class ViewShoppingCart extends HttpServlet {

 private static   Connection con;	

/**sets up the database connection and initialises the  the servlet.
 * @param 	<code>ServletConfig</code>
 * 
 */
public void init(ServletConfig config) throws ServletException
{
	super.init(config);
	try {
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con =DriverManager.getConnection(Singleton.DBIS_SQL_CONF,Singleton.DBIS_SQL_USERNAME,Singleton.DBIS_SQL_PASSWORD);
//		con =DriverManager.getConnection(Config.connection,Config.loginid,Config.password);
		 } catch (SQLException e) { 
		   throw new UnavailableException(this,"Could not Connect To the Database!!");}
}


	 /**
	  * Submits the cart to the user for editing.The main method of this class.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
 public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException  
{
	generatePage(req,res);
}



	 /**
	  * Generate the html for the page to be shown
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  *
	  */
 static public void generatePage(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException  
{
	
try{
 	Statement stmt;
 	ResultSet rset;
	stmt = con.createStatement();
    res.setContentType("text/html");
    PrintWriter toClient = res.getWriter();

    System.out.println("test 1");
    // Get the current session object, create one if necessary
    HttpSession session = req.getSession(true);

  	  String user_id=(String)session.getValue("user_id");
	if (user_id == null)
	{
		System.out.println("Login Faliure");
		 toClient.println("Please authenticate !!");
		 toClient.println("Either your session has expired or you have not yet logged in");
		 toClient.println("Login now to proceed");
		 toClient.println("<A HREF="+Singleton.DBIS_SQL_LOGINURL+"> Login Now!</A>");
	     toClient.println("</html>");
	}
    else
	{
    	System.out.println("test 2");
		String querystring="select Item.item_id, Item.item_name ,Item.preview_url, ShoppingBasket.quantity ,"+
							"Item.price,  Item.price*ShoppingBasket.quantity "+
							"from ShoppingBasket  , Item "+  
							"where ((ShoppingBasket.user_id = \'"+ user_id +"\') and ( Item.item_id = ShoppingBasket.item_id)) ";
		rset = stmt.executeQuery(querystring);
	    toClient.println("<html>");
		toClient.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
		toClient.println("<HTML><HEAD><TITLE>Your shopping cart!</TITLE>");
		toClient.println(Singleton.DBIS_HTML_CSS);
		toClient.println("</HEAD> <BODY>"); 
          //				BGCOLOR=\"#ffffff\" VLINK=\"#000077\" LINK=\"#aa0000\">");
		toClient.println("<H3>Your shopping cart contains these items:</H3>");
		toClient.println("<P><FORM METHOD=\"post\" ACTION=\""+Singleton.DBIS_SERVLET_BASEURL+"UpdateCart\" ENCTYPE=\"application/x-www-form-urlencoded\">");
		toClient.println("<center>");
		toClient.println("<TABLE CELLPADDING=\"5\"><TR class=frow>"+ 
			 "<TH>Product No.</TH> <TH>Product name</TH> <TH> Product Url </TH><TH>Quantity</TH>"+
			 "<TH>Unit Price</TH> <TH>Price</TH></TR>");
		float rowsum;
		float totalsum=0;
		while (rset.next()) 
		{
    			System.out.println("test 3");
			rowsum=0;
			rowsum=rset.getFloat("price")*rset.getFloat("quantity");
			totalsum+=rowsum;
			toClient.println("<TR class=orow><TD ALIGN=\"center\">"+ rset.getString("item_id")+ "</TD>");
			toClient.println("<TD>"+ rset.getString("item_name")+" </TD><TD><A HREF=\""+Singleton.DBIS_HTTP_BASEADDRESS+"/"+rset.getString("preview_url")
					  +"\">"+rset.getString("preview_url")+"</A></TD>");
			toClient.println("<TD><INPUT TYPE=\"text\" NAME=data__"+rset.getObject("item_id") +" \" VALUE=\""+
					  rset.getInt("quantity")+ " \" SIZE=4 MAXSIZE=\"4\"></TD>");
			toClient.println("<TD ALIGN=\"right\">"+ rset.getFloat("price")+"</TD>");
			toClient.println("<TD ALIGN=\"right\">"+rowsum+"</TD>");
			toClient.print("</TR>");
		}
		toClient.println("<TR><TH ALIGN=\"right\" COLSPAN=\"4\">Total</TH> <TH ALIGN=\"right\">"+totalsum+"</TH></TR>");
		toClient.println("</TABLE></center>");
		toClient.println("<center>");
		
    		System.out.println("test 4");
		toClient.println("</center>");
		toClient.println("You can update the quantity of items you want to purchase <BR>");
		toClient.println("by changing the text fields and pressing the Update items button<BR>");
		toClient.println("In order ot delte an item just set the textfield to zero!<BR>");
      	toClient.println("<BR><BR><center><input type=submit value=\"Update Items\"></center>");
		toClient.println("</form>");

		//Now the form to despatch items!!
		toClient.println("<h3>To complete your order:</h3>");
		toClient.println("<h3>1. Review the contents of your shopping cart.</h3>");
		toClient.println("<blockquote>");
		toClient.println("<p>");
		toClient.println("If your shopping cart is missing items that you've added,");
		toClient.println("your browser may not support cookies.Please enable cookies to proceed. ");
		toClient.println("</p>");
		toClient.println("</blockquote>");

		//TODO
		//allow the user to 
		//1)transfer a single item from cart to despatch table
		//2)to to batch transfer
		//i am just handling batch transfer n\for now..
		toClient.println("<form method=POST action="+Singleton.DBIS_SERVLET_BASEURL+"Despatch>");
		toClient.println("Please select the mode of despatch you want us to use");
		toClient.println("<center>");
		toClient.println("<select name=\"priority\">");
		toClient.println("<option value=\"Normal\">Normal</option>");
		toClient.println("<option value=\"Express\">Express</option>");
    		System.out.println("test 5");
		toClient.println("<option value=\"Slow\">Slow</option>");
		toClient.println("<option value=\"Flight\">Flight</option>");
		toClient.println("</select>");
		toClient.println("</center>");
		toClient.println("<center><input type=submit  value=\"Despatch all\"></center> ");
		toClient.println("</form>");
		toClient.println("<blockquote>");
		toClient.println("Be sure to select the appropriate method of despatch and then click on ");
		toClient.println("the despatch at the bottom of the form.  You will receive ");
		toClient.println("confirmation of your order via e-mail.");
		toClient.println("</blockquote>");
		toClient.print("</body>");
	 	toClient.println("</html>");
	}
 }catch (SQLException e) { System.out.println("SQLexception"+e);} 
  catch (NullPointerException e) { e.printStackTrace(); System.out.println("Nullexception"+e);} 
}

}
