package DBIS.Tools;

import java.util.*;
import java.lang.reflect.*;

/**This class is intended to help debugging the program Basically this
 * will contain the static variables which can be set as per the
 * debugging demands Basically it will contain an vector of names of the 
 * classes which  need to be debugged The classes which needs to be debugged 
 * can be set before the actual execution of the program begins.
 * 
 * @author Anureet Saxena
 * @version: 1.0
 */
public class Debugger	{
	/** This is contains the vector of registered classes*/
	static Vector debug=new Vector(3,2);	

	/** @param - str is the string to be displayed
		 @param - classname is the name of the class requesting display*/
	public static void display(String str,Class classname)	{
		if(isPresent(classname))	
			System.err.println(classname.toString()+"  :  "+str);
		return;
	}

	/** @param - str is the string to be displayed
		 @param - classname is the name of the class requesting display
		 @param - sleep is the time in milliseconds for which the execution stops after displaying the message
		 if the class is registered*/
	public static void display(String str,Class classname,int sleep)	{
		display(str,classname);
		try	{	Thread.sleep(sleep);	}	catch(Exception e)	{}
		return;
	}

	/** @return This function returns true if the classname is registered.*/
	static boolean isPresent(Class classname)	{
		if(classname==null)	return false;
		Enumeration enumeration=debug.elements();
		while(enumeration.hasMoreElements())	{
			Class debugclass=(Class)(enumeration.nextElement());
			if(classname.equals(debugclass))	{
				return true;
			}
		}
		return false;
	}

	/** This function registers the class 
		@param classname - the class to be registsred*/
	public static void addClass(Class classname)	{
		if(!isPresent(classname))	
			debug.addElement(classname);
		return;
	}

	public static void addClass(String className)	{
		try {
			Debugger.addClass(Class.forName(className));
		}
		catch (ClassNotFoundException e ) { e.printStackTrace();}
	}
};
