package DBIS.Tools;

import java.io.FileInputStream;
import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Enumeration;

/** This class implements the HtmlTemplate for the web pages
 * This template primarily consist of a string and a vector
 * of substitutable tags These tags are dynamically scoped and
 * substituted by the page generator*/

public class HtmlTemplate {

	Vector tags=null;
	String htmlPage=null;

	public HtmlTemplate(String htmlPage,Vector tags)	{
		this.htmlPage=htmlPage;
		this.tags=tags;
	}

	public Enumeration getTags()	{
		if(tags==null)	return null;
		return tags.elements();
	}

	public String getTemplatePage()	{
		return htmlPage;
	}

	public static HtmlTemplate loadHtmlTemplate(String fileHeader)	{
		HtmlTemplate _template=null;
		FileInputStream stream=null;
		try {
			stream=new FileInputStream(fileHeader+".html");
			int available=stream.available();
			byte[] array=new byte[available];
			stream.read(array);
			String page=new String(array,0);
			stream.close();

			stream=new FileInputStream(fileHeader+".tag");
			available=stream.available();
			array=new byte[available];
			stream.read(array);
			StringTokenizer strTok=new StringTokenizer(new String(array,0),"\n");
			Vector tags=new Vector();
			while(strTok.hasMoreTokens())	{
				tags.addElement(strTok.nextToken());
			}

			_template=new HtmlTemplate(page,tags);	
		}catch(Exception e) {e.printStackTrace();}
		return _template;
	}

}
