package DBIS.Tools;

import java.util.Hashtable;
import java.util.Enumeration;
import DBIS.Tools.HtmlTemplate;

/** This class generates the html page on the fly The class
 * constructor takes a non-null instance of HtmlTemplate class
 * and generates the required page when the format function
 * is called This function is passed a hastable as a parameter
 * These parameters are the substituted for the named variables
 * in the html page The substitution follows synamic scoping hence
 * the variabls should be suitably named in the html template page*/

public class PageGenerator {

	HtmlTemplate _template;

	public PageGenerator(HtmlTemplate _template)	{
		this._template=_template;
		initialise();
	}

	public void initialise()	{}

	public String format(Hashtable hashtable)	{
		Enumeration tags=_template.getTags();
		String page=_template.getTemplatePage();

		while(tags.hasMoreElements())	{
			String tag=(String)tags.nextElement();
			String tmp=(String)hashtable.get(tag);
			if(tmp!=null)	{
				page=Singleton.substituteString(page,tag,tmp);
			}
		}
		return page;
	}

	protected HtmlTemplate getHtmlTemplate()	{
		return _template;
	}
}
