package DBIS.Tools;

import java.sql.*;      
import java.util.Vector;
import DBIS.Tools.Singleton;
import DBIS.Tools.Debugger;

/** This class acts as a query execution engine It accepts the query
 * as a string executes and returns the resultset*/
public class QueryEngine	{

	static Class name=null;
	static	{
		try {
			name=Class.forName("DBIS.Tools.QueryEngine");
			Debugger.addClass(name);
		}catch(ClassNotFoundException e) {e.printStackTrace();}
	}

	public static final String DBIS_SQL_CONF="jdbc:oracle:thin:@everest:1521:GEN";
	public static final String DBIS_SQL_USERNAME="anureet";
	public static final String DBIS_SQL_PASSWORD="anureet";

	public static ResultSet executeQuery(String query)	{
		try {	
			DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
			Connection con = DriverManager.getConnection(DBIS_SQL_CONF,DBIS_SQL_USERNAME,DBIS_SQL_PASSWORD);
			//This creates statement
			Statement stmt=con.createStatement();
			//Query being sent
			ResultSet rs=stmt.executeQuery(query);
			return rs;
		}catch(SQLException sqle){
			Debugger.display(sqle+"",name);
		}
		return null;
	}
}
