package DBIS.Configurator; 

import java.io.*;
import DBIS.Configurator.*;

/** This is the top abstract class of all configurable objects
 * This configurator runs on console
 * This is suitable because the configurator has to be fast and reliable
 * as well */
abstract public class Configurable {

	Configurator configurator;

	public Configurable(Configurator configurator)	{
		this.configurator=configurator;
		initialise();
	}

	public void initialise()	{}

	abstract public void configure();

}
