/** This servlet is for adding a room to the database */


import java.util.*;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import Utils.*;


public class AddLectureServlet extends SQLServlet { 


	/** Ths init Method . Gets the connection */

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/** This is the interface for entering information about a lecture */	 
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null) {
			toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
					"http://" + request.getHeader("Host") +
					"/servlet/main;\">");
		}
		else if (!"admin".equals((String)((Hashtable)session.getValue(session.getId())).get("loginid"))) {
			toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
					"http://" + request.getHeader("Host") +
					"/servlet/main;\">");
		}
		else {
			HtmlUtils.LoginScreen(toClient, request, response);
			toClient.println("<form name=\"AddLecture\" method=\"post\" action=\""+response.encodeUrl("/servlet/AddLectureServlet")+"\">");
			toClient.println("<table bgcolor=\"lightblue\">" +
					"<tr>" +
					"<td> <b> Course Number </b> </td>" +
					"<td><input type=textbox name=\"course_no\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <b> Period of lecture </b> </td>" +
					"<td><input type=textbox name=\"period\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <b> Start Date </b> </td>" +
					"<td><input type=textbox name=\"start_date\" size=\"20\" value=\""+General.today_date+"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <b> End Date </b> </td>" +
					"<td><input type=textbox name=\"end_date\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <b> Room_id </b> </td>" +
					"<td><input type=textbox name=\"room_id\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <A HREF="+response.encodeUrl("/servlet/info?type=iitbslots")+"> <b> IITB Slot no.</b> </A> </td>" +
					"<td><input type=textbox name=\"slot_no\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"<tr>" +
					"<td> <A HREF="+response.encodeUrl("/servlet/info?type=iitbslots")+"><b> IITB Slot id </b> </A></td>" +
					"<td><input type=textbox name=\"slot_id\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
					"</table>");	
			toClient.println("<br><br><input type=submit value=\"Submit\">" +
					"<input type=reset value=\"Reset\">");
		}
		toClient.println(HtmlUtils.Footer(response));
	}

	/** The main Servlet doing the insertion */	 
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();
		int lecture_no,period;
		String course_no,group_id,course_name,user_id;
		int slot_no;
		char slot_id;
		String room_id;
		String start_date,end_date;
		Statement stmt;
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null) {
			toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
					"http://" + request.getHeader("Host") +
					"/servlet/main;\">");
		}
		else if (!"admin".equals((String)((Hashtable)session.getValue(session.getId())).get("loginid"))) {
			toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
					"http://" + request.getHeader("Host") +
					"/servlet/main;\">");
		}
		else
		{

			try{		
				//if it comes here ==>then user is admin.Go ahead with booking

				HtmlUtils.LoginScreen(toClient, request, response);
				Connection con=super.getConnection();
				stmt=con.createStatement();
				ResultSet rset;
				group_id="";
				user_id="";
				course_no=request.getParameter("course_no");
				period=Integer.parseInt(request.getParameter("period"));
				start_date=request.getParameter("start_date");
				end_date=request.getParameter("end_date");
				room_id=request.getParameter("room_id");
				slot_no=Integer.parseInt(request.getParameter("slot_no"));
				slot_id=(request.getParameter("slot_id")).charAt(0);
				period=Integer.parseInt(request.getParameter("period"));
				rset=stmt.executeQuery("select * from lecture_info where course_no='"+course_no+"'");
			     lecture_no=1;
				while(rset.next())
				{
				     if(lecture_no!=1)
					 group_id+=" , ";
					group_id+=rset.getString("group_id");
					user_id=rset.getString("user_id");
				     lecture_no++;
				}
				Vector result=SQLUtils1.insertLecture(con,course_no,lecture_no,start_date,end_date,period,room_id,group_id,user_id,slot_no,slot_id);
				Enumeration en=result.elements();
				String message=(String)en.nextElement();
				//if message=="" it means that the slot is already 
				//booked and you have to get the information for the 
				//again
				if(!message.equals(""))
				{
					ResultSet rs=(ResultSet)en.nextElement();
					toClient.println(message);
					HtmlUtils.PrintTable(rs,toClient);
				}
		          else
			       toClient.println("The lecture got successfully inserted");
			     
			   stmt.close();
			   rset.close();
			   
			}catch(SQLException sqle){toClient.println(""+sqle);}		  
	      }
	
	toClient.println(HtmlUtils.Footer(response));
	}
}
