/** This servlet is for booking */


import java.util.*;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import Utils.*;


public class BookingServlet extends  SQLServlet { 
   
    
	/** Ths init Method . Gets the connection */

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/** The is booking servlet interface. */	 
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null){
                    toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
		}
		else {

			// Talk Booking form
			HtmlUtils.LoginScreen(toClient, request, response);
			//getting the loginid of the user
			String user_id=(String)((Hashtable)session.getValue(session.getId())).get("loginid");
			
			//if(type.equals("talk")){

				toClient.println("<form name=\"TalkBooking\" method=\"post\" action=\""+response.encodeUrl("/servlet/BookingServlet")+"\">");
				toClient.println("<input type=hidden name=\"user_id\" value=\""+user_id+"\">");
				toClient.println("<table bgcolor=\"lightblue\">" +
						"<tr>" +
						"<td> <A HREF="+response.encodeUrl("/servlet/info?type=roomlist")+"><b> Room Identifier </b> </A> </td>" +
						"<td><input type=textbox name=\"room_id\" size=\"20\" value=\"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<td> <b> Date for which lecture is Scheduled</b> </td>" +
						"<td><input type=textbox name=\"date_for_talk\" size=\"20\" value=\""+General.today_date+"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<tr>" +
						"<td> <b>Start Time </b> </td>" +
						"<td><input type=textbox name=\"start_time\" size=\"20\" value=\""+General.example_time+"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<td> <b>End Time </b> </td>" +
						"<td><input type=textbox name=\"end_time\" size=\"20\" value=\"\"></td>" +
						" </tr>" +
						" <tr>" +
						"<td> <b>Speaker </b> </td>" +
						"<td><input type=textbox name=\"speaker\" size=\"20\" value=\"\"></td>" +
						"</tr>" +
					"<tr>" +
					"<td> <b>Topic</b> </td>" +
					"<td><input type=textbox name=\"topic\" size=\"20\" value=\"\"></td>" +
					"</tr>" +
                        "</table>");
				    try{
					      Connection con=super.getConnection();
					      String str=HtmlUtils.getGroupString(SQLUtils1.getGroups(con));
				           toClient.println(str);	
					        }catch (SQLException sqle) {
						 toClient.println(""+sqle);
					  }	
                         toClient.println("<br><br>"+
					"<input type=submit value=\"Submit\">" +
					"<input type=reset value=\"Reset\">");
		}

		toClient.println(HtmlUtils.Footer(response));
	 }


	/** The main Servlet doing the insertion */	 
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();
          int talk_id;
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null){
                    toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
		}
		else {
		try{
			HtmlUtils.LoginScreen(toClient, request, response);
			Connection con=super.getConnection();
		     Vector vec=SQLUtils.check_Booked(con,SQLUtils.string_To_Date(request.getParameter("date_for_talk")),new Interval(request.getParameter("start_time"),request.getParameter("end_time")), request.getParameter("room_id"),request.getParameter("user_id"),request.getParameter("group_id"));
			Enumeration en=vec.elements();
			int booked=((Integer)en.nextElement()).intValue();
			String message=(String)en.nextElement();
			if(booked==0)
			{
		       talk_id=SQLUtils.insert_Talk(con,request.getParameter("topic"),request.getParameter("speaker"), SQLUtils.string_To_Date(request.getParameter("date_for_talk")),new Interval(request.getParameter("start_time"),request.getParameter("end_time")));
			  SQLUtils.insert_Booking(con,talk_id,request.getParameter("room_id"),request.getParameter("user_id"));
			  SQLUtils.insert_talkGroup(con,talk_id,request.getParameter("group_id"));     
			}
		      toClient.println(message);
			 //that is, there is a table to be printed
			if(en.hasMoreElements())
			{     
			    Vector table=(Vector)en.nextElement();
			    toClient.println(HtmlUtils.toHTML(table));
		     }
		}catch(SQLException sqle){toClient.println(sqle);}
		}
		toClient.println(HtmlUtils.Footer(response));
	}  
}  
