/** This servlet is for booking */


import java.util.*;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import Utils.*;


public class ExtraLectureBookingServlet extends  SQLServlet { 
   
    
	/** Ths init Method . Gets the connection */

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/** The is booking servlet interface. */	 
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null){
                    toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
		}
		else {

			// Talk Booking form
			HtmlUtils.LoginScreen(toClient, request, response);
			//getting the loginid of the user
			String user_id=(String)((Hashtable)session.getValue(session.getId())).get("loginid");
			
			//if(type.equals("talk")){

				toClient.println("<form name=\"ExtraLectureBooking\" method=\"post\" action=\""+response.encodeUrl("/servlet/ExtraLectureBookingServlet")+"\">");
				toClient.println("<input type=hidden name=\"user_id\" value=\""+user_id+"\">");
				toClient.println("<table bgcolor=\"lightblue\">" +
						"<tr>" +
						"<td> <b> Course Number </b> </td>" +
						"<td><input type=textbox name=\"course_no\" size=\"20\" value=\"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<td> <A HREF="+response.encodeUrl("/servlet/info?type=roomlist")+"><b> Room Identifier </b> </A></td>" +
						"<td><input type=textbox name=\"room_id\" size=\"20\" value=\"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<td> <b> Date for which lecture is Scheduled</b> </td>" +
						"<td><input type=textbox name=\"date_for_extralecture\" size=\"20\" value=\""+General.today_date+"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<tr>" +
						"<td> <b>Start Time </b> </td>" +
						"<td><input type=textbox name=\"start_time\" size=\"20\" value=\""+General.example_time+"\"></td>" +
						"</tr>" +
						"<tr>" +
						"<td> <b>End Time </b> </td>" +
						"<td><input type=textbox name=\"end_time\" size=\"20\" value=\"\"></td>" +
						" </tr>" +
					"</table>" +
					"<input type=submit value=\"Submit\">" +
					"<input type=reset value=\"Reset\">");
		}

		toClient.println(HtmlUtils.Footer(response));
	 }	

	/** The main Servlet doing the insertion */	 
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter toClient=response.getWriter();

		int extralecture_no;
		String course_no="";
		String group_id="";
		String user_id="";	
		Statement stmt;
		ResultSet rset;
		toClient.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if(session==null){
                    toClient.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
		}
		else {
		try{
			HtmlUtils.LoginScreen(toClient, request, response);
			Connection con=super.getConnection();
			stmt=con.createStatement();
			course_no=request.getParameter("course_no");
			rset=stmt.executeQuery("select * from lecture_info where course_no='"+course_no+"'");
			rset.next();
			user_id=rset.getString("user_id");
			group_id=rset.getString("group_id");
			while(rset.next())
			 group_id+=" , "+rset.getString("group_id");
			Vector vec=SQLUtils.check_Booked(con,SQLUtils.string_To_Date(request.getParameter("date_for_extralecture")),new Interval(request.getParameter("start_time"),request.getParameter("end_time")), request.getParameter("room_id"),user_id,group_id);
			Enumeration en=vec.elements();
			//System.out.println(""+vec.size());
			int booked=((Integer)en.nextElement()).intValue();
			String message=(String)en.nextElement();
			toClient.println(message+"\n<BR>\n");
			if(booked==0)
			{
		       SQLUtils.insert_ExtraLecture(con,request.getParameter("course_no"),request.getParameter("room_id"), SQLUtils.string_To_Date(request.getParameter("date_for_extralecture")),new Interval(request.getParameter("start_time"),request.getParameter("end_time")));
			  toClient.println(" <BR>The extra lectures for this course are :<BR>");
			  rset=stmt.executeQuery("select * from extra_lecture where course_no='"+course_no+"'");
		       HtmlUtils.PrintTable(rset,toClient);
			}
			if(en.hasMoreElements())	  
			{ 
				//System.out.println("i am testing");
				Vector table=(Vector)en.nextElement();
			     //System.out.println(table.size());
				toClient.println(HtmlUtils.toHTML(table));
			}   		
               stmt.close();
			rset.close();
			con.close();
		}catch(SQLException sqle){toClient.println(sqle);}
		}
		toClient.println(HtmlUtils.Footer(response));
	}  
}  
