import sun.net.nntp.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;
import Utils.*;

public class MailPostServlet extends HttpServlet {
	 public void init(ServletConfig config) throws ServletException{
		  super.init(config);
	 }

	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException ,ServletException{
		  
		  response.setContentType("text/html");
		  PrintWriter out=response.getWriter();

		  out.println(HtmlUtils.Header(response));
		  
		  Enumeration en = request.getParameterNames();
		  String[] names = new String[10];
		  int i=0;
		  int paracount=0;
		  while(en.hasMoreElements()){
			   names[i]=(String)en.nextElement();
			//   System.out.println(names[i]);
			   i++;
			   paracount++;
		  }
		  String server=request.getParameter("newsserver");
		  String newsgroup=request.getParameter("newsgroup");
		  String mypost=request.getParameter("urname");
		  String myemail=request.getParameter("uremailid");
		  String emails=request.getParameter("emailids");
		  String article=request.getParameter("article");
		  String subject=request.getParameter("subject");
		  i=0;
		  
		  while(i<paracount)
		  {
			   if(names[i].equals("post"))
			   {
					//posting=request.getParameter("post");
					if(poster(server,newsgroup,article,mypost,subject))
						out.println("Your article has been posted....");
					else
						out.println("Some problems in posting....");

			   }
			   if(names[i].equals("mail"))
			   {
					//mailing=request.getParameter("mail");
					mailer(myemail,emails,subject,article);
					out.println("Your mail has been sent.\n"+"THANK YOU");
			   }
			   i++;
		  }
		  out.println(HtmlUtils.Footer(response));
	 }



	 public static boolean poster(String server,String newsgroup,String article,String whopost,String subject) throws IOException {
		  /*
		   *      ** pass your news server as parameter 
		   *           **     eg. java NntpPost news.server.com
		   *                */
		  boolean flag=false;
		  StringTokenizer strtok=new StringTokenizer(newsgroup, ",");
		  String[] allgroups=new String[10];
		  int noofgroups=strtok.countTokens();
		  int i=0;
		  while(strtok.hasMoreTokens())
		  {
			   allgroups[i]=strtok.nextToken();
			   i++;
		  }
		  NntpClient c = new NntpClient(server);
		  for(i=0;i<noofgroups;i++)
		  {
			   NewsgroupInfo ni = c.getGroup(allgroups[i]);
			   PrintStream p = c.startPost();
			   //System.out.println("Starting post at " + allgroups[i] + "...");
			   p.println("From: "+whopost);
			   p.println("Newsgroups: "+allgroups[i]);
			   p.println("Subject: "+subject);
			   p.println("");
			   p.println(article);
			   if (c.finishPost())
					flag=true;
			   else
					flag=false;
		  }
		  c.closeServer();
		  return flag;
	 }

	 public static void mailer(String fromAddr, String toAddr, String sub, String msg) throws IOException {
		  String[] toaddresses=new String[7];
		  StringTokenizer strtok = new StringTokenizer(toAddr,",");
		  int noofmails=strtok.countTokens();
		  int i=0;
		  while(strtok.hasMoreTokens())
		  {
			   toaddresses[i]=strtok.nextToken();
			   i++;
		  }
		  Socket ms;
		  BufferedReader in;
		  PrintWriter out;
		  String resp;
		  String hostname="";
		  //hostname=getHostname();
		  if(hostname.equals("not_known"))
		  {
			   System.out.println("Sorry : Could not send your mail");
		  }
		  {
			   for(i=0;i<noofmails;i++)
			   {
					ms = new Socket("everest",25);
					in = new BufferedReader(new InputStreamReader(ms.getInputStream()));
					out = new PrintWriter(new OutputStreamWriter(ms.getOutputStream()));
					resp = in.readLine();
					out.println("MAIL from:<"+fromAddr+">");
					out.flush();
					resp = in.readLine();
					out.println("RCPT To:<"+toaddresses[i]+">");
					out.flush();
					resp = in.readLine();
					out.println("DATA");
					out.flush();
					resp=in.readLine();
					out.println("Date: "+new Date().toGMTString());
					out.println("From: "+fromAddr);
					out.println("To: " + toaddresses[i]);
					out.println("Subject: "+sub);
					out.println();
					out.println(msg);
					out.println (".\n\r");
					out.flush();
					resp=in.readLine();
					out.println("QUIT");
					out.flush();
					resp=in.readLine();
					ms.close();
			   }
		  }
	 }


	 public static String getHostname()
	 {
		  String hostname;
		  try{
			   Process p = Runtime.getRuntime().exec("nslookup $HOSTNAME");
			   DataInputStream in = new DataInputStream(p.getInputStream()); 
			   hostname = in.readLine();
		  }catch(Exception e){
			   hostname = "not_known";
		  }
		  return hostname;

	 }
}
