import java.util.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.lang.*;
import java.sql.*;
import Utils.*;
import Interface.*;
import java.util.Calendar;

public class loginServlet extends SQLServlet {

	/** This init Method . Gets the connection */

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/** This generates the form for logging in . */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {

		PrintWriter pw = response.getWriter();
		response.setContentType("text/html");
		pw.println(HtmlUtils.Header(response));
		// user wants to login.
		if ((request.getParameter("logout")).equals("false")) {
			HttpSession session = request.getSession(true);
		pw.println(
				"<FONT COLOR=\"#000099\"> <center><br>User Authentication For Booking Facility" +
				"<P><pre>" +
				"<FORM ACTION=\""+response.encodeUrl("/servlet/login")+"\" METHOD=\"POST\">" +
				"<B> Login </B><br>" +
				"<INPUT NAME=\"loginid\" TYPE=\"text\" MAXLENGTH=\"8\" SIZE=\"8\"><BR>" +
				"<B> Password </B><br>" +
				"<INPUT NAME=\"passwd\" TYPE=\"password\" MAXLENGTH=\"8\" SIZE =\"8\"><BR>" +
				"<INPUT NAME=\"submit\" TYPE=\"submit\" VALUE=\"login\"><br>" +
				"<INPUT NAME=\"reset\" TYPE=\"reset\" VALUE=\"reset\">" +
				"</FORM></center>");
		} 
		else {
			HttpSession session = request.getSession(false);
			if(session!=null) {
				Cookie[] y = request.getCookies();
				//Clear all cookies
				for (int i=0;i<y.length;i++)
					y[i].setMaxAge(0);
                    pw.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
				pw.println("<b>"+((Hashtable)session.getValue(session.getId())).get("loginid")+"</b> logged out");
				session.invalidate();
			} else
                    pw.println("<meta http-equiv=\"refresh\" content=\"0; url=" +
                    "http://" + request.getHeader("Host") +
                    "/servlet/main;\">");
		}
		pw.println(HtmlUtils.Footer(response));
		pw.close();
	}



	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {

		PrintWriter pw = response.getWriter();
		response.setContentType("text/html");

		pw.println(HtmlUtils.Header(response));
		HttpSession session = request.getSession(false);
		if  ((session==null)||((session!=null)&&session.isNew())){
			pw.println("You have to authenticate yourself : login.");
			pw.println("<meta http-equiv=\"refresh\" content=\"3; url=" +
					"http://" + request.getHeader("Host") +
					"/servlet/main;\">");
		}
		else{
			try {		
				Connection con = super.getConnection();
				Statement stmt = con.createStatement();
				String loginid = request.getParameter("loginid");
				String passwd = request.getParameter("passwd");

				ResultSet rs = stmt.executeQuery("select * from users where user_id = '"+loginid+"' and passwd = '"+passwd+"'");
				int number = 0;
				while (rs.next())
					number++;
				if (number == 1) {
					session = request.getSession(true);
					Hashtable ht = new Hashtable();
					ht.put("loginid",loginid);
					session.putValue(session.getId(), ht);
					// Put the value in session.

					HtmlUtils.LoginScreen(pw, request, response);

					// Get current date.
					Calendar cal = Calendar.getInstance();
					String begin_date   = ""+ cal.get(Calendar.DAY_OF_MONTH)+"-"+cal.get(Calendar.MONTH)+"-"+cal.get(Calendar.YEAR);
					String end_date     = ""+ cal.get(Calendar.DAY_OF_MONTH)+"-"+cal.get(Calendar.MONTH)+"-"+cal.get(Calendar.YEAR);
					pw.println("This week's Commitments : ");
					String week[] = General.getWeek();
					if(!loginid.equals("admin"))
						pw.println(UserInterface.MakeTable(SQLUtils.lecture_Commitments(con,loginid,"",new Interval("00:00","23:50"),week[0],week[1],""),
									SQLUtils.extralecture_Commitments(con,loginid,"",new Interval("00:00","23:50"),week[0],week[1],""),                    
									SQLUtils.talk_Commitments(con,loginid,"","",new Interval("00:00","23:50"),week[0],week[1],""),
									Common.stringToDate(week[0]),Common.stringToDate(week[1]),response
												    ));
				}
				else if (number == 0) {
					pw.println("<b>LOGIN FAILED.</b><br>Sorry : either the passwd you have entered is wrong or you are not allowed to book unless you are a registered user.");
				}
				else  {
					pw.println("Something wrong in the database : SORRY.");
				}
				con.close();
			} catch(SQLException sqle) {};
		}
		pw.println(HtmlUtils.Footer(response));
		pw.close();
	}
}
