/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class FastStringBuffer {
    public int m_blocksize;
    public char[] m_map;
    public int m_firstFree = 0;
    public int m_mapSize;

    public FastStringBuffer() {
        this.m_blocksize = 1024;
        this.m_mapSize = 1024;
        this.m_map = new char[1024];
    }

    public FastStringBuffer(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new char[n];
    }

    public final void append(char c) {
        this.ensureFreeSpace(1);
        this.m_map[this.m_firstFree] = c;
        ++this.m_firstFree;
    }

    public final void append(String string) {
        int n = string.length();
        this.ensureFreeSpace(n);
        string.getChars(0, n, this.m_map, this.m_firstFree);
        this.m_firstFree += n;
    }

    public final void append(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        this.ensureFreeSpace(n);
        stringBuffer.getChars(0, n, this.m_map, this.m_firstFree);
        this.m_firstFree += n;
    }

    public final void append(FastStringBuffer fastStringBuffer) {
        int n = fastStringBuffer.m_firstFree;
        this.ensureFreeSpace(n);
        System.arraycopy(fastStringBuffer.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public final void append(char[] cArray, int n, int n2) {
        this.ensureFreeSpace(n2);
        System.arraycopy(cArray, n, this.m_map, this.m_firstFree, n2);
        this.m_firstFree += n2;
    }

    private final void ensureFreeSpace(int n) {
        if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            char[] cArray = new char[this.m_mapSize];
            System.arraycopy(this.m_map, 0, cArray, 0, this.m_firstFree + 1);
            this.m_map = cArray;
        }
    }

    public final int length() {
        return this.m_firstFree;
    }

    public final void reset() {
        this.m_firstFree = 0;
    }

    public final void setLength(int n) {
        this.m_firstFree = n;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final String toString() {
        return new String(this.m_map, 0, this.m_firstFree);
    }
}

