/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.UnionPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;
import org.apache.xpath.operations.And;
import org.apache.xpath.operations.Bool;
import org.apache.xpath.operations.Div;
import org.apache.xpath.operations.Equals;
import org.apache.xpath.operations.Gt;
import org.apache.xpath.operations.Gte;
import org.apache.xpath.operations.Lt;
import org.apache.xpath.operations.Lte;
import org.apache.xpath.operations.Minus;
import org.apache.xpath.operations.Mod;
import org.apache.xpath.operations.Mult;
import org.apache.xpath.operations.Neg;
import org.apache.xpath.operations.NotEquals;
import org.apache.xpath.operations.Number;
import org.apache.xpath.operations.Operation;
import org.apache.xpath.operations.Or;
import org.apache.xpath.operations.Plus;
import org.apache.xpath.operations.UnaryOperation;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.patterns.AncestorStepPattern;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Compiler
extends OpMap {
    private int locPathDepth = -1;
    private PrefixResolver m_currentPrefixResolver = null;
    ErrorListener m_errorHandler;
    SourceLocator m_locator;

    public Compiler() {
        this.m_errorHandler = null;
        this.m_locator = null;
    }

    public Compiler(ErrorListener errorListener, SourceLocator sourceLocator) {
        this.m_errorHandler = errorListener;
        if (sourceLocator != null) {
            SAXSourceLocator sAXSourceLocator = new SAXSourceLocator();
            sAXSourceLocator.setColumnNumber(sourceLocator.getColumnNumber());
            sAXSourceLocator.setLineNumber(sourceLocator.getLineNumber());
            sAXSourceLocator.setPublicId(sourceLocator.getPublicId());
            sAXSourceLocator.setSystemId(sourceLocator.getSystemId());
            this.m_locator = sAXSourceLocator;
        }
    }

    protected Expression and(int n) throws TransformerException {
        return this.compileOperation(new And(), n);
    }

    protected Expression arg(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    public void assert(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    protected Expression bool(int n) throws TransformerException {
        return this.compileUnary(new Bool(), n);
    }

    public Expression compile(int n) throws TransformerException {
        int n2 = this.m_opMap[n];
        Expression expression = null;
        switch (n2) {
            case 1: {
                expression = this.compile(n + 2);
                break;
            }
            case 2: {
                expression = this.or(n);
                break;
            }
            case 3: {
                expression = this.and(n);
                break;
            }
            case 4: {
                expression = this.notequals(n);
                break;
            }
            case 5: {
                expression = this.equals(n);
                break;
            }
            case 6: {
                expression = this.lte(n);
                break;
            }
            case 7: {
                expression = this.lt(n);
                break;
            }
            case 8: {
                expression = this.gte(n);
                break;
            }
            case 9: {
                expression = this.gt(n);
                break;
            }
            case 10: {
                expression = this.plus(n);
                break;
            }
            case 11: {
                expression = this.minus(n);
                break;
            }
            case 12: {
                expression = this.mult(n);
                break;
            }
            case 13: {
                expression = this.div(n);
                break;
            }
            case 14: {
                expression = this.mod(n);
                break;
            }
            case 16: {
                expression = this.neg(n);
                break;
            }
            case 17: {
                expression = this.string(n);
                break;
            }
            case 18: {
                expression = this.bool(n);
                break;
            }
            case 19: {
                expression = this.number(n);
                break;
            }
            case 20: {
                expression = this.union(n);
                break;
            }
            case 21: {
                expression = this.literal(n);
                break;
            }
            case 22: {
                expression = this.variable(n);
                break;
            }
            case 23: {
                expression = this.group(n);
                break;
            }
            case 27: {
                expression = this.numberlit(n);
                break;
            }
            case 26: {
                expression = this.arg(n);
                break;
            }
            case 24: {
                expression = this.compileExtension(n);
                break;
            }
            case 25: {
                expression = this.compileFunction(n);
                break;
            }
            case 28: {
                expression = this.locationPath(n);
                break;
            }
            case 29: {
                expression = null;
                break;
            }
            case 30: {
                expression = this.matchPattern(n + 2);
                break;
            }
            case 31: {
                expression = this.locationPathPattern(n);
                break;
            }
            default: {
                this.error(24, new Object[]{Integer.toString(this.m_opMap[n])});
            }
        }
        if (expression != null) {
            expression.setSourceLocator(this.m_locator);
        }
        return expression;
    }

    private Expression compileExtension(int n) throws TransformerException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = OpMap.getFirstChildPos(n);
        String string = (String)this.m_tokenQueue[this.m_opMap[n]];
        String string2 = (String)this.m_tokenQueue[this.m_opMap[++n]];
        FuncExtFunction funcExtFunction = new FuncExtFunction(string, string2, String.valueOf(String.valueOf(++n)) + String.valueOf(this.hashCode()));
        try {
            int n3 = 0;
            while (n < n2) {
                int n4 = this.getNextOpPos(n);
                ((Function)funcExtFunction).setArg(this.compile(n), n3);
                n = n4;
                ++n3;
            }
        }
        catch (WrongNumberArgsException wrongNumberArgsException) {}
        return funcExtFunction;
    }

    Expression compileFunction(int n) throws TransformerException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = OpMap.getFirstChildPos(n);
        int n3 = this.m_opMap[n];
        ++n;
        if (n3 != -1) {
            Function function = FunctionTable.getFunction(n3);
            try {
                int n4 = 0;
                int n5 = n;
                while (n5 < n2) {
                    function.setArg(this.compile(n5), n4);
                    n5 = this.getNextOpPos(n5);
                    ++n4;
                }
                function.checkNumberArgs(n4);
            }
            catch (WrongNumberArgsException wrongNumberArgsException) {
                String string = FunctionTable.m_functions[n3].getName();
                this.m_errorHandler.fatalError(new TransformerException(String.valueOf(string) + " only allows " + wrongNumberArgsException.getMessage() + " arguments", this.m_locator));
            }
            return function;
        }
        this.error(69, null);
        return null;
    }

    private Expression compileOperation(Operation operation, int n) throws TransformerException {
        int n2 = OpMap.getFirstChildPos(n);
        int n3 = this.getNextOpPos(n2);
        operation.setLeftRight(this.compile(n2), this.compile(n3));
        return operation;
    }

    private void compilePredicates(int n, Expression[] expressionArray) throws TransformerException {
        int n2 = 0;
        while (this.getOp(n) == 29) {
            expressionArray[n2] = this.predicate(n);
            n = this.getNextOpPos(n);
            ++n2;
        }
    }

    private Expression compileUnary(UnaryOperation unaryOperation, int n) throws TransformerException {
        int n2 = OpMap.getFirstChildPos(n);
        unaryOperation.setRight(this.compile(n2));
        return unaryOperation;
    }

    public int countPredicates(int n) throws TransformerException {
        int n2 = 0;
        while (this.getOp(n) == 29) {
            ++n2;
            n = this.getNextOpPos(n);
        }
        return n2;
    }

    protected Expression div(int n) throws TransformerException {
        return this.compileOperation(new Div(), n);
    }

    protected Expression equals(int n) throws TransformerException {
        return this.compileOperation(new Equals(), n);
    }

    public void error(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        if (this.m_errorHandler == null) {
            throw new TransformerException(string, (SAXSourceLocator)this.m_locator);
        }
        this.m_errorHandler.fatalError(new TransformerException(string, this.m_locator));
    }

    public Expression[] getCompiledPredicates(int n) throws TransformerException {
        int n2 = this.countPredicates(n);
        if (n2 > 0) {
            Expression[] expressionArray = new Expression[n2];
            this.compilePredicates(n, expressionArray);
            return expressionArray;
        }
        return null;
    }

    public int getLocationPathDepth() {
        return this.locPathDepth;
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public int getWhatToShow(int n) {
        int n2 = this.getOp(n);
        int n3 = this.getOp(n + 3);
        switch (n3) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 12;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                switch (n2) {
                    case 49: {
                        return 4098;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 38: 
                    case 42: 
                    case 48: {
                        return -1;
                    }
                }
                if (this.getOp(0) == 30) {
                    return -1283;
                }
                return -3;
            }
            case 35: {
                return 1280;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (n2) {
                    case 49: {
                        return 4098;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected Expression group(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    protected Expression gt(int n) throws TransformerException {
        return this.compileOperation(new Gt(), n);
    }

    protected Expression gte(int n) throws TransformerException {
        return this.compileOperation(new Gte(), n);
    }

    protected Expression literal(int n) {
        n = OpMap.getFirstChildPos(n);
        return (XString)this.m_tokenQueue[this.m_opMap[n]];
    }

    public Expression locationPath(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            LocPathIterator locPathIterator = WalkerFactory.newLocPathIterator(this, n);
            if (this.locPathDepth == 0) {
                locPathIterator.setIsTopLevel(true);
            }
            LocPathIterator locPathIterator2 = locPathIterator;
            Object var4_4 = null;
            --this.locPathDepth;
            return locPathIterator2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.locPathDepth;
            throw throwable;
        }
    }

    public Expression locationPathPattern(int n) throws TransformerException {
        n = OpMap.getFirstChildPos(n);
        return this.stepPattern(n, 0, null);
    }

    protected Expression lt(int n) throws TransformerException {
        return this.compileOperation(new Lt(), n);
    }

    protected Expression lte(int n) throws TransformerException {
        return this.compileOperation(new Lte(), n);
    }

    protected Expression matchPattern(int n) throws TransformerException {
        int n2 = n;
        int n3 = 0;
        while (this.m_opMap[n2] == 31) {
            n2 = this.getNextOpPos(n2);
            ++n3;
        }
        if (n3 == 1) {
            return this.compile(n);
        }
        UnionPattern unionPattern = new UnionPattern();
        StepPattern[] stepPatternArray = new StepPattern[n3];
        n3 = 0;
        while (this.m_opMap[n] == 31) {
            n2 = this.getNextOpPos(n);
            stepPatternArray[n3] = (StepPattern)this.compile(n);
            n = n2;
            ++n3;
        }
        unionPattern.setPatterns(stepPatternArray);
        return unionPattern;
    }

    protected Expression minus(int n) throws TransformerException {
        return this.compileOperation(new Minus(), n);
    }

    protected Expression mod(int n) throws TransformerException {
        return this.compileOperation(new Mod(), n);
    }

    protected Expression mult(int n) throws TransformerException {
        return this.compileOperation(new Mult(), n);
    }

    protected Expression neg(int n) throws TransformerException {
        return this.compileUnary(new Neg(), n);
    }

    protected Expression notequals(int n) throws TransformerException {
        return this.compileOperation(new NotEquals(), n);
    }

    protected Expression number(int n) throws TransformerException {
        return this.compileUnary(new Number(), n);
    }

    protected Expression numberlit(int n) {
        n = OpMap.getFirstChildPos(n);
        return (XNumber)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected Expression or(int n) throws TransformerException {
        return this.compileOperation(new Or(), n);
    }

    protected Expression plus(int n) throws TransformerException {
        return this.compileOperation(new Plus(), n);
    }

    public Expression predicate(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    public void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }

    protected StepPattern stepPattern(int n, int n2, StepPattern stepPattern) throws TransformerException {
        StepPattern stepPattern2;
        int n3;
        int n4 = n;
        int n5 = this.getOpMap()[n];
        if (n5 == -1) {
            return null;
        }
        int n6 = this.getNextOpPos(n);
        switch (n5) {
            case 25: {
                n3 = this.m_opMap[n + 1];
                stepPattern2 = new FunctionPattern(this.compileFunction(n));
                break;
            }
            case 50: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(1280);
                break;
            }
            case 51: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(2, this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            case 52: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new AncestorStepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            case 53: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            default: {
                this.error(16, null);
                return null;
            }
        }
        stepPattern2.setPredicates(this.getCompiledPredicates(n + n3));
        stepPattern2.setRelativePathPattern(stepPattern);
        StepPattern stepPattern3 = this.stepPattern(n6, n2 + 1, stepPattern2);
        return stepPattern3 != null ? stepPattern3 : stepPattern2;
    }

    protected Expression string(int n) throws TransformerException {
        return this.compileUnary(new org.apache.xpath.operations.String(), n);
    }

    protected Expression union(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            UnionPathIterator unionPathIterator = new UnionPathIterator(this, n);
            Object var4_3 = null;
            --this.locPathDepth;
            return unionPathIterator;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            --this.locPathDepth;
            throw throwable;
        }
    }

    protected Expression variable(int n) throws TransformerException {
        Variable variable = new Variable();
        int n2 = this.m_opMap[n = OpMap.getFirstChildPos(n)];
        String string = n2 == -2 ? null : (String)this.m_tokenQueue[n2];
        String string2 = (String)this.m_tokenQueue[this.m_opMap[n + 1]];
        QName qName = new QName(string, string2);
        variable.setQName(qName);
        return variable;
    }

    public void warn(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        if (this.m_errorHandler != null) {
            this.m_errorHandler.warning(new TransformerException(string, this.m_locator));
        } else {
            System.out.println(String.valueOf(string) + "; file " + this.m_locator.getSystemId() + "; line " + this.m_locator.getLineNumber() + "; column " + this.m_locator.getColumnNumber());
        }
    }
}

