/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Hashtable;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredAttrImpl;
import org.apache.xerces.dom.DeferredAttrNSImpl;
import org.apache.xerces.dom.DeferredCDATASectionImpl;
import org.apache.xerces.dom.DeferredCommentImpl;
import org.apache.xerces.dom.DeferredDocumentTypeImpl;
import org.apache.xerces.dom.DeferredElementDefinitionImpl;
import org.apache.xerces.dom.DeferredElementImpl;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.apache.xerces.dom.DeferredEntityImpl;
import org.apache.xerces.dom.DeferredEntityReferenceImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.DeferredNotationImpl;
import org.apache.xerces.dom.DeferredProcessingInstructionImpl;
import org.apache.xerces.dom.DeferredTextImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeferredDocumentImpl
extends DocumentImpl
implements DeferredNode {
    static final long serialVersionUID = 5186323580749626857L;
    private static final boolean DEBUG_PRINT_REF_COUNTS = false;
    private static final boolean DEBUG_PRINT_TABLES = false;
    private static final boolean DEBUG_IDS = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected transient int fNodeCount = 0;
    protected transient int[][] fNodeType;
    protected transient int[][] fNodeName;
    protected transient int[][] fNodeValue;
    protected transient int[][] fNodeParent;
    protected transient int[][] fNodeLastChild;
    protected transient int[][] fNodePrevSib;
    protected transient int[][] fNodeURI;
    protected transient int fIdCount;
    protected transient int[] fIdName;
    protected transient int[] fIdElement;
    protected transient StringPool fStringPool;
    protected boolean fNamespacesEnabled = false;

    public DeferredDocumentImpl(StringPool stringPool) {
        this(stringPool, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean bl) {
        this(stringPool, bl, false);
    }

    public DeferredDocumentImpl(StringPool stringPool, boolean bl, boolean bl2) {
        super(bl2);
        this.fStringPool = stringPool;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
        this.fNamespacesEnabled = bl;
    }

    boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public int createDocument() {
        int n = this.createNode((short)9);
        return n;
    }

    public int createDocumentType(int n, int n2, int n3) {
        int n4 = this.createNode((short)10);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        int n7 = this.createNode((short)0);
        int n8 = n7 >> 11;
        int n9 = n7 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeValue, n7, n5, n6);
        this.setChunkIndex(this.fNodeName, n2, n8, n9);
        this.setChunkIndex(this.fNodeValue, n3, n8, n9);
        return n4;
    }

    public void setInternalSubset(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = this.fNodeValue[n3][n4];
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeLastChild[n6][n7] = n2;
    }

    public int createNotation(int n, int n2, int n3) throws Exception {
        int n4 = this.createNode((short)12);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        int n7 = this.createNode((short)0);
        int n8 = n7 >> 11;
        int n9 = n7 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeValue, n7, n5, n6);
        this.setChunkIndex(this.fNodeName, n2, n8, n9);
        this.setChunkIndex(this.fNodeValue, n3, n8, n9);
        return n4;
    }

    public int createEntity(int n, int n2, int n3, int n4) throws Exception {
        int n5 = this.createNode((short)6);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        int n8 = this.createNode((short)0);
        int n9 = n8 >> 11;
        int n10 = n8 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n6, n7);
        this.setChunkIndex(this.fNodeValue, n8, n6, n7);
        this.setChunkIndex(this.fNodeName, n2, n9, n10);
        this.setChunkIndex(this.fNodeValue, n3, n9, n10);
        this.setChunkIndex(this.fNodeLastChild, n4, n9, n10);
        return n5;
    }

    public int createEntityReference(int n) throws Exception {
        int n2 = this.createNode((short)5);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n3, n4);
        return n2;
    }

    public int createElement(int n, XMLAttrList xMLAttrList, int n2) {
        return this.createElement(n, -1, xMLAttrList, n2);
    }

    public int createElement(int n, int n2, XMLAttrList xMLAttrList, int n3) {
        int n4 = this.createNode((short)1);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeURI, n2, n5, n6);
        if (n3 != -1) {
            int n7 = xMLAttrList.getFirstAttr(n3);
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = n7;
            while (n11 != -1) {
                int n12 = this.createAttribute(xMLAttrList.getAttrName(n11), xMLAttrList.getAttrURI(n11), xMLAttrList.getAttValue(n11), xMLAttrList.isSpecified(n11));
                int n13 = n12 >> 11;
                int n14 = n12 & 0x7FF;
                this.setChunkIndex(this.fNodeParent, n4, n13, n14);
                if (n11 == n7) {
                    this.setChunkIndex(this.fNodeValue, n12, n5, n6);
                } else {
                    this.setChunkIndex(this.fNodePrevSib, n12, n9, n10);
                }
                n8 = n12;
                n9 = n13;
                n10 = n14;
                n11 = xMLAttrList.getNextAttr(n11);
            }
        }
        return n4;
    }

    public int createAttribute(int n, int n2, boolean bl) {
        return this.createAttribute(n, -1, n2, bl);
    }

    public int createAttribute(int n, int n2, int n3, boolean bl) {
        int n4 = this.createNode((short)2);
        int n5 = n4 >> 11;
        int n6 = n4 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n5, n6);
        this.setChunkIndex(this.fNodeURI, n2, n5, n6);
        this.setChunkIndex(this.fNodeValue, bl ? 1 : 0, n5, n6);
        int n7 = this.createTextNode(n3, false);
        this.appendChild(n4, n7);
        return n4;
    }

    public int createElementDefinition(int n) {
        int n2 = this.createNode((short)-1);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n3, n4);
        return n2;
    }

    public int createTextNode(int n, boolean bl) {
        int n2 = this.createNode((short)3);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        this.setChunkIndex(this.fNodeLastChild, bl ? 1 : 0, n3, n4);
        return n2;
    }

    public int createCDATASection(int n, boolean bl) {
        int n2 = this.createNode((short)4);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        this.setChunkIndex(this.fNodeLastChild, bl ? 1 : 0, n3, n4);
        return n2;
    }

    public int createProcessingInstruction(int n, int n2) {
        int n3 = this.createNode((short)7);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.setChunkIndex(this.fNodeName, n, n4, n5);
        this.setChunkIndex(this.fNodeValue, n2, n4, n5);
        return n3;
    }

    public int createComment(int n) {
        int n2 = this.createNode((short)8);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeValue, n, n3, n4);
        return n2;
    }

    public void appendChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeParent, n, n5, n6);
        int n7 = this.getChunkIndex(this.fNodeLastChild, n3, n4);
        this.setChunkIndex(this.fNodePrevSib, n7, n5, n6);
        this.setChunkIndex(this.fNodeLastChild, n2, n3, n4);
    }

    public int setAttributeNode(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        String string = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, n5, n6));
        int n7 = this.getChunkIndex(this.fNodeValue, n3, n4);
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        while (n7 != -1) {
            n9 = n7 >> 11;
            n10 = n7 & 0x7FF;
            String string2 = this.fStringPool.toString(this.getChunkIndex(this.fNodeName, n9, n10));
            if (string2.equals(string)) break;
            n8 = n7;
            n7 = this.getChunkIndex(this.fNodePrevSib, n9, n10);
        }
        if (n7 != -1) {
            int n11;
            int n12;
            int n13 = this.getChunkIndex(this.fNodePrevSib, n9, n10);
            if (n8 == -1) {
                this.setChunkIndex(this.fNodeValue, n13, n3, n4);
            } else {
                n12 = n8 >> 11;
                n11 = n8 & 0x7FF;
                this.setChunkIndex(this.fNodePrevSib, n13, n12, n11);
            }
            this.clearChunkIndex(this.fNodeType, n9, n10);
            this.clearChunkIndex(this.fNodeName, n9, n10);
            this.clearChunkIndex(this.fNodeValue, n9, n10);
            this.clearChunkIndex(this.fNodeParent, n9, n10);
            this.clearChunkIndex(this.fNodePrevSib, n9, n10);
            n12 = this.clearChunkIndex(this.fNodeLastChild, n9, n10);
            n11 = n12 >> 11;
            int n14 = n12 & 0x7FF;
            this.clearChunkIndex(this.fNodeType, n11, n14);
            this.clearChunkIndex(this.fNodeValue, n11, n14);
            this.clearChunkIndex(this.fNodeParent, n11, n14);
            this.clearChunkIndex(this.fNodeLastChild, n11, n14);
        }
        int n15 = this.getChunkIndex(this.fNodeValue, n3, n4);
        this.setChunkIndex(this.fNodeValue, n2, n3, n4);
        this.setChunkIndex(this.fNodePrevSib, n15, n5, n6);
        return n7;
    }

    public int insertBefore(int n, int n2, int n3) {
        if (n3 == -1) {
            this.appendChild(n, n2);
            return n2;
        }
        int n4 = n2 >> 11;
        int n5 = n2 & 0x7FF;
        int n6 = n3 >> 11;
        int n7 = n3 & 0x7FF;
        int n8 = this.getChunkIndex(this.fNodePrevSib, n6, n7);
        this.setChunkIndex(this.fNodePrevSib, n2, n6, n7);
        this.setChunkIndex(this.fNodePrevSib, n8, n4, n5);
        return n2;
    }

    public void setAsLastChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.setChunkIndex(this.fNodeLastChild, n2, n3, n4);
    }

    public int getParentNode(int n) {
        return this.getParentNode(n, false);
    }

    public int getParentNode(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return bl ? this.clearChunkIndex(this.fNodeParent, n2, n3) : this.getChunkIndex(this.fNodeParent, n2, n3);
    }

    public int getLastChild(int n) {
        return this.getLastChild(n, true);
    }

    public int getLastChild(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return bl ? this.clearChunkIndex(this.fNodeLastChild, n2, n3) : this.getChunkIndex(this.fNodeLastChild, n2, n3);
    }

    public int getPrevSibling(int n) {
        return this.getPrevSibling(n, true);
    }

    public int getPrevSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.getChunkIndex(this.fNodeType, n2, n3);
        if (n4 == 3) {
            while ((n = this.getChunkIndex(this.fNodePrevSib, n2, n3)) != -1 && (n4 = this.getChunkIndex(this.fNodeType, n2 = n >> 11, n3 = n & 0x7FF)) == 3) {
            }
        } else {
            n = this.getChunkIndex(this.fNodePrevSib, n2, n3);
        }
        return n;
    }

    public int getRealPrevSibling(int n) {
        return this.getRealPrevSibling(n, true);
    }

    public int getRealPrevSibling(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return bl ? this.clearChunkIndex(this.fNodePrevSib, n2, n3) : this.getChunkIndex(this.fNodePrevSib, n2, n3);
    }

    public int lookupElementDefinition(int n) {
        if (this.fNodeCount > 1) {
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.getChunkIndex(this.fNodeLastChild, n3, n4);
            while (n5 != -1) {
                n3 = n5 >> 11;
                n4 = n5 & 0x7FF;
                if (this.getChunkIndex(this.fNodeType, n3, n4) == 10) {
                    n2 = n5;
                    break;
                }
                n5 = this.getChunkIndex(this.fNodePrevSib, n3, n4);
            }
            if (n2 == -1) {
                return -1;
            }
            n3 = n2 >> 11;
            n4 = n2 & 0x7FF;
            int n6 = this.getChunkIndex(this.fNodeLastChild, n3, n4);
            while (n6 != -1) {
                n3 = n6 >> 11;
                n4 = n6 & 0x7FF;
                if (this.getChunkIndex(this.fNodeName, n3, n4) == n) {
                    return n6;
                }
                n6 = this.getChunkIndex(this.fNodePrevSib, n3, n4);
            }
        }
        return -1;
    }

    public DeferredNode getNodeObject(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.getChunkIndex(this.fNodeType, n2, n3);
        if (n4 != 3) {
            this.clearChunkIndex(this.fNodeType, n2, n3);
        }
        NodeImpl nodeImpl = null;
        switch (n4) {
            case 2: {
                if (this.fNamespacesEnabled) {
                    nodeImpl = new DeferredAttrNSImpl(this, n);
                    break;
                }
                nodeImpl = new DeferredAttrImpl(this, n);
                break;
            }
            case 4: {
                nodeImpl = new DeferredCDATASectionImpl(this, n);
                break;
            }
            case 8: {
                nodeImpl = new DeferredCommentImpl(this, n);
                break;
            }
            case 9: {
                nodeImpl = this;
                break;
            }
            case 10: {
                nodeImpl = new DeferredDocumentTypeImpl(this, n);
                this.docType = (DocumentTypeImpl)nodeImpl;
                break;
            }
            case 1: {
                nodeImpl = this.fNamespacesEnabled ? new DeferredElementNSImpl(this, n) : new DeferredElementImpl(this, n);
                if (this.docElement == null) {
                    this.docElement = (ElementImpl)nodeImpl;
                }
                if (this.fIdElement == null) break;
                int n5 = DeferredDocumentImpl.binarySearch(this.fIdElement, 0, this.fIdCount - 1, n);
                while (n5 != -1) {
                    int n6 = this.fIdName[n5];
                    if (n6 != -1) {
                        String string = this.fStringPool.toString(n6);
                        this.putIdentifier0(string, (Element)((Object)nodeImpl));
                        this.fIdName[n5] = -1;
                    }
                    if (n5 + 1 < this.fIdCount && this.fIdElement[n5 + 1] == n) {
                        ++n5;
                        continue;
                    }
                    n5 = -1;
                }
                break;
            }
            case 6: {
                nodeImpl = new DeferredEntityImpl(this, n);
                break;
            }
            case 5: {
                nodeImpl = new DeferredEntityReferenceImpl(this, n);
                break;
            }
            case 12: {
                nodeImpl = new DeferredNotationImpl(this, n);
                break;
            }
            case 7: {
                nodeImpl = new DeferredProcessingInstructionImpl(this, n);
                break;
            }
            case 3: {
                nodeImpl = new DeferredTextImpl(this, n);
                break;
            }
            case -1: {
                nodeImpl = new DeferredElementDefinitionImpl(this, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + n4);
            }
        }
        if (nodeImpl != null) {
            return nodeImpl;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeNameString(int n) {
        return this.getNodeNameString(n, true);
    }

    public String getNodeNameString(int n, boolean bl) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 = bl ? this.clearChunkIndex(this.fNodeName, n3, n4) : this.getChunkIndex(this.fNodeName, n3, n4);
        if (n2 == -1) {
            return null;
        }
        return this.fStringPool.toString(n2);
    }

    public String getNodeValueString(int n) {
        return this.getNodeValueString(n, true);
    }

    public String getNodeValueString(int n, boolean bl) {
        int n2;
        int n3;
        if (n == -1) {
            return null;
        }
        int n4 = n >> 11;
        int n5 = n & 0x7FF;
        int n6 = n3 = bl ? this.clearChunkIndex(this.fNodeValue, n4, n5) : this.getChunkIndex(this.fNodeValue, n4, n5);
        if (n3 == -1) {
            return null;
        }
        int n7 = this.getChunkIndex(this.fNodeType, n4, n5);
        if (n7 == 3 && (n2 = this.getRealPrevSibling(n)) != -1 && this.getNodeType(n2, false) == 3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fStringPool.toString(n3));
            do {
                n4 = n2 >> 11;
                n5 = n2 & 0x7FF;
                n3 = this.getChunkIndex(this.fNodeValue, n4, n5);
                stringBuffer.insert(0, this.fStringPool.toString(n3));
            } while ((n2 = this.getChunkIndex(this.fNodePrevSib, n4, n5)) != -1 && this.getNodeType(n2, false) == 3);
            return stringBuffer.toString();
        }
        return this.fStringPool.toString(n3);
    }

    public int getNodeName(int n) {
        return this.getNodeName(n, true);
    }

    public int getNodeName(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return bl ? this.clearChunkIndex(this.fNodeName, n2, n3) : this.getChunkIndex(this.fNodeName, n2, n3);
    }

    public int getNodeValue(int n) {
        return this.getNodeValue(n, true);
    }

    public int getNodeValue(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return bl ? this.clearChunkIndex(this.fNodeValue, n2, n3) : this.getChunkIndex(this.fNodeValue, n2, n3);
    }

    public short getNodeType(int n) {
        return this.getNodeType(n, true);
    }

    public short getNodeType(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return (short)this.clearChunkIndex(this.fNodeType, n2, n3);
        }
        return (short)this.getChunkIndex(this.fNodeType, n2, n3);
    }

    public int getAttribute(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = this.getChunkIndex(this.fNodeValue, n3, n4);
        while (n5 != -1) {
            int n6 = n5 >> 11;
            int n7 = n5 & 0x7FF;
            if (this.getChunkIndex(this.fNodeName, n6, n7) == n2) {
                return this.getChunkIndex(this.fNodeValue, n6, n7);
            }
            n5 = this.getChunkIndex(this.fNodePrevSib, n6, n7);
        }
        return -1;
    }

    public short getNodeURI(int n) {
        return this.getNodeURI(n, true);
    }

    public short getNodeURI(int n, boolean bl) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        if (bl) {
            return (short)this.clearChunkIndex(this.fNodeURI, n2, n3);
        }
        return (short)this.getChunkIndex(this.fNodeURI, n2, n3);
    }

    public void putIdentifier(int n, int n2) {
        if (this.fIdName == null) {
            this.fIdName = new int[64];
            this.fIdElement = new int[64];
        }
        if (this.fIdCount == this.fIdName.length) {
            int[] nArray = new int[this.fIdCount * 2];
            System.arraycopy(this.fIdName, 0, nArray, 0, this.fIdCount);
            this.fIdName = nArray;
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(this.fIdElement, 0, nArray2, 0, this.fIdCount);
            this.fIdElement = nArray2;
        }
        this.fIdName[this.fIdCount] = n;
        this.fIdElement[this.fIdCount] = n2;
        ++this.fIdCount;
    }

    public void print() {
    }

    public int getNodeIndex() {
        return 0;
    }

    protected StringPool getStringPool() {
        return this.fStringPool;
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        if (this.fIdElement != null) {
            IntVector intVector = new IntVector();
            int n = 0;
            while (n < this.fIdCount) {
                int n2 = this.fIdElement[n];
                int n3 = this.fIdName[n];
                if (n3 != -1) {
                    Node node;
                    int n4;
                    int n5;
                    intVector.removeAllElements();
                    int n6 = n2;
                    do {
                        intVector.addElement(n6);
                    } while ((n6 = this.getChunkIndex(this.fNodeParent, n5 = n6 >> 11, n4 = n6 & 0x7FF)) != -1);
                    Node node2 = this;
                    n4 = intVector.size() - 2;
                    while (n4 >= 0) {
                        n6 = intVector.elementAt(n4);
                        node = node2.getLastChild();
                        while (node != null) {
                            int n7;
                            if (node instanceof DeferredNode && (n7 = ((DeferredNode)node).getNodeIndex()) == n6) {
                                node2 = node;
                                break;
                            }
                            node = node.getPreviousSibling();
                        }
                        --n4;
                    }
                    node = (Element)node2;
                    String string = this.fStringPool.toString(n3);
                    this.putIdentifier0(string, (Element)node);
                    this.fIdName[n] = -1;
                    while (this.fIdElement[n + 1] == n2) {
                        string = this.fStringPool.toString(this.fIdName[++n]);
                        this.putIdentifier0(string, (Element)node);
                    }
                }
                ++n;
            }
        }
    }

    protected void synchronizeChildren() {
        if (this.needsSyncData()) {
            this.synchronizeData();
            if (!this.needsSyncChildren()) {
                return;
            }
        }
        boolean bl = this.mutationEvents;
        this.mutationEvents = false;
        this.needsSyncChildren(false);
        this.getNodeType(0);
        NodeImpl nodeImpl = null;
        ChildNode childNode = null;
        int n = this.getLastChild(0);
        while (n != -1) {
            ChildNode childNode2 = (ChildNode)((Object)this.getNodeObject(n));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = this;
            childNode2.isOwned(true);
            childNode2.nextSibling = nodeImpl;
            nodeImpl = childNode2;
            short s = childNode2.getNodeType();
            if (s == 1) {
                this.docElement = (ElementImpl)childNode2;
            } else if (s == 10) {
                this.docType = (DocumentTypeImpl)childNode2;
            }
            n = this.getPrevSibling(n);
        }
        if (nodeImpl != null) {
            this.firstChild = nodeImpl;
            nodeImpl.isFirstChild(true);
            this.lastChild(childNode);
        }
        this.mutationEvents = bl;
    }

    protected boolean ensureCapacity(int n, int n2) {
        if (this.fNodeType == null) {
            this.fNodeType = new int[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeURI = new int[32][];
        }
        try {
            return this.fNodeType[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = n * 2;
            int[][] nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeType, 0, nArrayArray, 0, n);
            this.fNodeType = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeName, 0, nArrayArray, 0, n);
            this.fNodeName = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeValue, 0, nArrayArray, 0, n);
            this.fNodeValue = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeParent, 0, nArrayArray, 0, n);
            this.fNodeParent = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeLastChild, 0, nArrayArray, 0, n);
            this.fNodeLastChild = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodePrevSib, 0, nArrayArray, 0, n);
            this.fNodePrevSib = nArrayArray;
            nArrayArray = new int[n3][];
            System.arraycopy(this.fNodeURI, 0, nArrayArray, 0, n);
            this.fNodeURI = nArrayArray;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.createChunk(this.fNodeType, n);
        this.createChunk(this.fNodeName, n);
        this.createChunk(this.fNodeValue, n);
        this.createChunk(this.fNodeParent, n);
        this.createChunk(this.fNodeLastChild, n);
        this.createChunk(this.fNodePrevSib, n);
        this.createChunk(this.fNodeURI, n);
        return true;
    }

    protected int createNode(short s) {
        int n = this.fNodeCount >> 11;
        int n2 = this.fNodeCount & 0x7FF;
        this.ensureCapacity(n, n2);
        this.setChunkIndex(this.fNodeType, s, n, n2);
        return this.fNodeCount++;
    }

    protected static int binarySearch(int[] nArray, int n, int n2, int n3) {
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = nArray[n4];
            if (n5 == n3) {
                while (n4 > 0 && nArray[n4 - 1] == n3) {
                    --n4;
                }
                return n4;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            n = n4 + 1;
        }
        return -1;
    }

    private final void createChunk(int[][] nArray, int n) {
        nArray[n] = new int[2050];
        int n2 = 0;
        while (n2 < 2048) {
            nArray[n][n2] = -1;
            ++n2;
        }
    }

    private final int setChunkIndex(int[][] nArray, int n, int n2, int n3) {
        if (n == -1) {
            return this.clearChunkIndex(nArray, n2, n3);
        }
        int n4 = nArray[n2][n3];
        if (n4 == -1) {
            int[] nArray2 = nArray[n2];
            nArray2[2048] = nArray2[2048] + 1;
        }
        nArray[n2][n3] = n;
        return n4;
    }

    private final int getChunkIndex(int[][] nArray, int n, int n2) {
        return nArray[n] != null ? nArray[n][n2] : -1;
    }

    private final int clearChunkIndex(int[][] nArray, int n, int n2) {
        int n3;
        int n4 = n3 = nArray[n] != null ? nArray[n][n2] : -1;
        if (n3 != -1) {
            int[] nArray2 = nArray[n];
            nArray2[2049] = nArray2[2049] + 1;
            nArray[n][n2] = -1;
            if (nArray[n][2048] == nArray[n][2049]) {
                nArray[n] = null;
            }
        }
        return n3;
    }

    private final void putIdentifier0(String string, Element element) {
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    private static void print(int[] nArray, int n, int n2, int n3, int n4) {
    }

    static class IntVector {
        private int[] data;
        private int size;

        IntVector() {
        }

        public int size() {
            return this.size;
        }

        public int elementAt(int n) {
            return this.data[n];
        }

        public void addElement(int n) {
            this.ensureCapacity(this.size + 1);
            this.data[this.size++] = n;
        }

        public void removeAllElements() {
            this.size = 0;
        }

        private void ensureCapacity(int n) {
            if (this.data == null) {
                this.data = new int[n + 15];
            } else if (n > this.data.length) {
                int[] nArray = new int[n + 15];
                System.arraycopy(this.data, 0, nArray, 0, this.data.length);
                this.data = nArray;
            }
        }
    }
}

