/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.Encodings;
import org.apache.xml.serialize.IndentPrinter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Printer;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    private int _lastPrintable = 126;
    private ElementState[] _elementStates = new ElementState[10];
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private boolean _prepared;
    protected Hashtable _prefixes;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;
    protected OutputFormat _format;
    protected Printer _printer;
    protected boolean _indenting;
    private Writer _writer;
    private OutputStream _output;
    static /* synthetic */ Class class$java$lang$String;

    protected BaseMarkupSerializer(OutputFormat outputFormat) {
        int n = 0;
        while (n < this._elementStates.length) {
            this._elementStates[n] = new ElementState();
            ++n;
        }
        this._format = outputFormat;
    }

    public DocumentHandler asDocumentHandler() throws IOException {
        this.prepare();
        return this;
    }

    public ContentHandler asContentHandler() throws IOException {
        this.prepare();
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        this.prepare();
        return this;
    }

    public void setOutputByteStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("SER001 Argument 'output' is null.");
        }
        this._output = outputStream;
        this._writer = null;
        this.reset();
    }

    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("SER001 Argument 'writer' is null.");
        }
        this._writer = writer;
        this._output = null;
        this.reset();
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            throw new NullPointerException("SER001 Argument 'format' is null.");
        }
        this._format = outputFormat;
        this.reset();
    }

    public boolean reset() {
        if (this._elementStateCount > 1) {
            throw new IllegalStateException("Serializer reset in the middle of serialization");
        }
        this._prepared = false;
        return true;
    }

    protected void prepare() throws IOException {
        if (this._prepared) {
            return;
        }
        if (this._writer == null && this._output == null) {
            throw new IOException("SER002 No writer supplied for serializer");
        }
        if (this._output != null) {
            this._writer = this._format.getEncoding() == null ? new OutputStreamWriter(this._output) : Encodings.getWriter(this._output, this._format.getEncoding());
        }
        this._lastPrintable = this._format.getEncoding() == null ? Encodings.getLastPrintable() : Encodings.getLastPrintable(this._format.getEncoding());
        if (this._format.getIndenting()) {
            this._indenting = true;
            this._printer = new IndentPrinter(this._writer, this._format);
        } else {
            this._indenting = false;
            this._printer = new Printer(this._writer, this._format);
        }
        this._elementStateCount = 0;
        ElementState elementState = this._elementStates[0];
        elementState.namespaceURI = null;
        elementState.localName = null;
        elementState.rawName = null;
        elementState.preserveSpace = this._format.getPreserveSpace();
        elementState.empty = true;
        elementState.afterElement = false;
        elementState.inCData = false;
        elementState.doCData = false;
        elementState.prefixes = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
        this._started = false;
        this._prepared = true;
    }

    public void serialize(Element element) throws IOException {
        this.prepare();
        this.serializeNode(element);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void serialize(DocumentFragment documentFragment) throws IOException {
        this.prepare();
        this.serializeNode(documentFragment);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void serialize(Document document) throws IOException {
        this.prepare();
        this.serializeNode(document);
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.prepare();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.toString());
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        ElementState elementState = this.content();
        if (elementState.inCData || elementState.doCData) {
            if (!elementState.inCData) {
                this._printer.printText("<![CDATA[");
                elementState.inCData = true;
            }
            int n3 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            int n4 = 0;
            while (n4 < n2) {
                if (n4 + 2 < n2 && cArray[n4] == ']' && cArray[n4 + 1] == ']' && cArray[n4 + 2] == '>') {
                    this.printText(cArray, n, n4 + 2, true, true);
                    this._printer.printText("]]><![CDATA[");
                    n += n4 + 2;
                    n2 -= n4 + 2;
                    n4 = 0;
                }
                ++n4;
            }
            if (n2 > 0) {
                this.printText(cArray, n, n2, true, true);
            }
            this._printer.setNextIndent(n3);
        } else if (elementState.preserveSpace) {
            int n5 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(cArray, n, n2, true, elementState.unescaped);
            this._printer.setNextIndent(n5);
        } else {
            this.printText(cArray, n, n2, false, elementState.unescaped);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.content();
        if (this._indenting) {
            this._printer.setThisIndent(0);
            int n3 = n;
            while (n2-- > 0) {
                this._printer.printText(cArray[n3]);
                ++n3;
            }
        }
    }

    public void processingInstruction(String string, String string2) {
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("?>");
        if (n >= 0) {
            stringBuffer.append("<?").append(string.substring(0, n));
        } else {
            stringBuffer.append("<?").append(string);
        }
        if (string2 != null) {
            stringBuffer.append(' ');
            n = string2.indexOf("?>");
            if (n >= 0) {
                stringBuffer.append(string2.substring(0, n));
            } else {
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append("?>");
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(stringBuffer.toString(), true, true);
            this._printer.unindent();
        }
    }

    public void comment(char[] cArray, int n, int n2) {
        this.comment(new String(cArray, n, n2));
    }

    public void comment(String string) {
        if (this._format.getOmitComments()) {
            return;
        }
        ElementState elementState = this.content();
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = string.indexOf("-->");
        if (n >= 0) {
            stringBuffer.append("<!--").append(string.substring(0, n)).append("-->");
        } else {
            stringBuffer.append("<!--").append(string).append("-->");
        }
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(stringBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(stringBuffer.toString(), false, true);
            this._printer.unindent();
        }
    }

    public void startCDATA() {
        ElementState elementState = this.getElementState();
        elementState.doCData = true;
    }

    public void endCDATA() {
        ElementState elementState = this.getElementState();
        elementState.doCData = false;
    }

    public void startNonEscaping() {
        ElementState elementState = this.getElementState();
        elementState.unescaped = true;
    }

    public void endNonEscaping() {
        ElementState elementState = this.getElementState();
        elementState.unescaped = false;
    }

    public void startPreserving() {
        ElementState elementState = this.getElementState();
        elementState.preserveSpace = true;
    }

    public void endPreserving() {
        ElementState elementState = this.getElementState();
        elementState.preserveSpace = false;
    }

    public void endDocument() throws SAXException {
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw new SAXException(this._printer.getException());
        }
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
        this.endCDATA();
        this.content();
        this._printer.printText('&');
        this._printer.printText(string);
        this._printer.printText(';');
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new Hashtable();
        }
        this._prefixes.put(string2, string == null ? "" : string);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) {
        this._printer.enterDTD();
        this._docTypePublicId = string2;
        this._docTypeSystemId = string3;
    }

    public void endDTD() {
    }

    public void elementDecl(String string, String string2) {
        this._printer.enterDTD();
        this._printer.printText("<!ELEMENT ");
        this._printer.printText(string);
        this._printer.printText(' ');
        this._printer.printText(string2);
        this._printer.printText('>');
        if (this._indenting) {
            this._printer.breakLine();
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        this._printer.enterDTD();
        this._printer.printText("<!ATTLIST ");
        this._printer.printText(string);
        this._printer.printText(' ');
        this._printer.printText(string2);
        this._printer.printText(' ');
        this._printer.printText(string3);
        if (string4 != null) {
            this._printer.printText(' ');
            this._printer.printText(string4);
        }
        if (string5 != null) {
            this._printer.printText(" \"");
            this.printEscaped(string5);
            this._printer.printText('\"');
        }
        this._printer.printText('>');
        if (this._indenting) {
            this._printer.breakLine();
        }
    }

    public void internalEntityDecl(String string, String string2) {
        this._printer.enterDTD();
        this._printer.printText("<!ENTITY ");
        this._printer.printText(string);
        this._printer.printText(" \"");
        this.printEscaped(string2);
        this._printer.printText("\">");
        if (this._indenting) {
            this._printer.breakLine();
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        this._printer.enterDTD();
        this.unparsedEntityDecl(string, string2, string3, null);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this._printer.enterDTD();
        if (string2 == null) {
            this._printer.printText("<!ENTITY ");
            this._printer.printText(string);
            this._printer.printText(" SYSTEM ");
            this.printDoctypeURL(string3);
        } else {
            this._printer.printText("<!ENTITY ");
            this._printer.printText(string);
            this._printer.printText(" PUBLIC ");
            this.printDoctypeURL(string2);
            this._printer.printText(' ');
            this.printDoctypeURL(string3);
        }
        if (string4 != null) {
            this._printer.printText(" NDATA ");
            this._printer.printText(string4);
        }
        this._printer.printText('>');
        if (this._indenting) {
            this._printer.breakLine();
        }
    }

    public void notationDecl(String string, String string2, String string3) {
        this._printer.enterDTD();
        if (string2 != null) {
            this._printer.printText("<!NOTATION ");
            this._printer.printText(string);
            this._printer.printText(" PUBLIC ");
            this.printDoctypeURL(string2);
            if (string3 != null) {
                this._printer.printText(' ');
                this.printDoctypeURL(string3);
            }
        } else {
            this._printer.printText("<!NOTATION ");
            this._printer.printText(string);
            this._printer.printText(" SYSTEM ");
            this.printDoctypeURL(string3);
        }
        this._printer.printText('>');
        if (this._indenting) {
            this._printer.breakLine();
        }
    }

    protected void serializeNode(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                String string = node.getNodeValue();
                if (string == null) break;
                this.characters(node.getNodeValue());
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                if (string == null) break;
                this.startCDATA();
                this.characters(node.getNodeValue());
                this.endCDATA();
                break;
            }
            case 8: {
                String string;
                if (this._format.getOmitComments() || (string = node.getNodeValue()) == null) break;
                this.comment(node.getNodeValue());
                break;
            }
            case 5: {
                this.endCDATA();
                this.content();
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.serializeNode(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 7: {
                this.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: {
                Node node3 = ((Document)node).getDoctype();
                if (node3 != null) {
                    DOMImplementation dOMImplementation = ((Document)node).getImplementation();
                    try {
                        this.startDTD(node3.getName(), node3.getPublicId(), node3.getSystemId());
                        String string = node3.getInternalSubset();
                        if (string != null && string.length() > 0) {
                            this._printer.printText(string);
                        }
                        this.endDTD();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        Method method;
                        Class<?> clazz = node3.getClass();
                        String string = null;
                        String string2 = null;
                        try {
                            method = clazz.getMethod("getPublicId", null);
                            if (method.getReturnType().equals(class$java$lang$String == null ? (class$java$lang$String = BaseMarkupSerializer.class$("java.lang.String")) : class$java$lang$String)) {
                                string = (String)method.invoke((Object)node3, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            method = clazz.getMethod("getSystemId", null);
                            if (method.getReturnType().equals(class$java$lang$String == null ? (class$java$lang$String = BaseMarkupSerializer.class$("java.lang.String")) : class$java$lang$String)) {
                                string2 = (String)method.invoke((Object)node3, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.startDTD(node3.getName(), string, string2);
                        this.endDTD();
                    }
                }
            }
            case 11: {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    this.serializeNode(node3);
                    node3 = node3.getNextSibling();
                }
                break;
            }
        }
    }

    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (!this.isDocumentState()) {
            if (elementState.inCData && !elementState.doCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (elementState.empty) {
                this._printer.printText('>');
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    protected void characters(String string) {
        ElementState elementState = this.content();
        if (elementState.inCData || elementState.doCData) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (!elementState.inCData) {
                stringBuffer.append("<![CDATA[");
                elementState.inCData = true;
            }
            int n = string.indexOf("]]>");
            while (n >= 0) {
                stringBuffer.append(string.substring(0, n + 2)).append("]]><![CDATA[");
                string = string.substring(n + 2);
                n = string.indexOf("]]>");
            }
            stringBuffer.append(string);
            int n2 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(stringBuffer.toString(), true, true);
            this._printer.setNextIndent(n2);
        } else if (elementState.preserveSpace) {
            int n = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(string, true, elementState.unescaped);
            this._printer.setNextIndent(n);
        } else {
            this.printText(string, false, elementState.unescaped);
        }
    }

    protected abstract String getEntityRef(char var1);

    protected abstract void serializeElement(Element var1);

    protected void serializePreRoot() {
        if (this._preRoot != null) {
            int n = 0;
            while (n < this._preRoot.size()) {
                this.printText((String)this._preRoot.elementAt(n), true, true);
                this._printer.breakLine();
                ++n;
            }
            this._preRoot.removeAllElements();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void printText(char[] var1_1, int var2_2, int var3_3, boolean var4_4, boolean var5_5) {
        block5: {
            if (!var4_4) ** GOTO lbl20
            while (var3_3-- > 0) {
                var7_6 = var1_1[var2_2];
                ++var2_2;
                if (var7_6 == '\n' || var7_6 == '\r' || var5_5) {
                    this._printer.printText(var7_6);
                    continue;
                }
                this.printEscaped(var7_6);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var7_7 = var1_1[var2_2];
                ++var2_2;
                if (var7_7 == ' ' || var7_7 == '\f' || var7_7 == '\t' || var7_7 == '\n' || var7_7 == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var7_7);
                    continue;
                }
                this.printEscaped(var7_7);
lbl20:
                // 4 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    protected final void printText(String string, boolean bl, boolean bl2) {
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\n' || c == '\r' || bl2) {
                    this._printer.printText(c);
                } else {
                    this.printEscaped(c);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                    this._printer.printSpace();
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printEscaped(c);
                }
                ++n;
            }
        }
    }

    protected void printDoctypeURL(String string) {
        this._printer.printText('\"');
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"' || string.charAt(n) < ' ' || string.charAt(n) > '\u007f') {
                this._printer.printText('%');
                this._printer.printText(Integer.toHexString(string.charAt(n)));
            } else {
                this._printer.printText(string.charAt(n));
            }
            ++n;
        }
        this._printer.printText('\"');
    }

    protected void printEscaped(char c) {
        String string = this.getEntityRef(c);
        if (string != null) {
            this._printer.printText('&');
            this._printer.printText(string);
            this._printer.printText(';');
        } else if (c >= ' ' && c <= this._lastPrintable && c != '\u00f7' || c == '\n' || c == '\r' || c == '\t') {
            this._printer.printText(c);
        } else {
            this._printer.printText("&#");
            this._printer.printText(Integer.toString(c));
            this._printer.printText(';');
        }
    }

    protected void printEscaped(String string) {
        int n = 0;
        while (n < string.length()) {
            this.printEscaped(string.charAt(n));
            ++n;
        }
    }

    protected ElementState getElementState() {
        return this._elementStates[this._elementStateCount];
    }

    protected ElementState enterElementState(String string, String string2, String string3, boolean bl) {
        if (this._elementStateCount + 1 == this._elementStates.length) {
            ElementState[] elementStateArray = new ElementState[this._elementStates.length + 10];
            int n = 0;
            while (n < this._elementStates.length) {
                elementStateArray[n] = this._elementStates[n];
                ++n;
            }
            int n2 = this._elementStates.length;
            while (n2 < elementStateArray.length) {
                elementStateArray[n2] = new ElementState();
                ++n2;
            }
            this._elementStates = elementStateArray;
        }
        ++this._elementStateCount;
        ElementState elementState = this._elementStates[this._elementStateCount];
        elementState.namespaceURI = string;
        elementState.localName = string2;
        elementState.rawName = string3;
        elementState.preserveSpace = bl;
        elementState.empty = true;
        elementState.afterElement = false;
        elementState.inCData = false;
        elementState.doCData = false;
        elementState.unescaped = false;
        elementState.prefixes = this._prefixes;
        this._prefixes = null;
        return elementState;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 0) {
            this._prefixes = this._elementStates[this._elementStateCount].prefixes;
            --this._elementStateCount;
            return this._elementStates[this._elementStateCount];
        }
        throw new IllegalStateException("Internal error: element state is zero");
    }

    protected boolean isDocumentState() {
        return this._elementStateCount == 0;
    }

    protected String getPrefix(String string) {
        String string2;
        if (this._prefixes != null && (string2 = (String)this._prefixes.get(string)) != null) {
            return string2;
        }
        if (this._elementStateCount == 0) {
            return null;
        }
        int n = this._elementStateCount;
        while (n > 0) {
            if (this._elementStates[n].prefixes != null && (string2 = (String)this._elementStates[n].prefixes.get(string)) != null) {
                return string2;
            }
            --n;
        }
        return null;
    }

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endElement(String var1) throws SAXException;

    public abstract void startElement(String var1, AttributeList var2) throws SAXException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

