/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.math.MPI;
import cryptix.math.RandomStream;
import cryptix.pgp.CFB;
import cryptix.pgp.DecryptException;
import cryptix.pgp.EncryptedBigInt;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyID;
import cryptix.pgp.Passphrase;
import cryptix.security.BlockCipher;
import cryptix.security.IDEA;
import cryptix.security.StreamCipher;
import cryptix.security.rsa.SecretKey;
import cryptix.util.Streamable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class EncryptedSecretKey
extends Streamable {
    private BigInteger e_;
    private BigInteger n_;
    private EncryptedBigInt d_;
    private EncryptedBigInt p_;
    private EncryptedBigInt q_;
    private EncryptedBigInt u_;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private boolean isEncrypted = true;
    private byte[] iv_;
    private int checksum_;

    public EncryptedSecretKey(SecretKey secretKey, Passphrase passphrase, RandomStream randomStream) throws IOException {
        IDEA iDEA = new IDEA(passphrase.md5hash());
        CFB cFB = new CFB((BlockCipher)iDEA);
        this.n_ = secretKey.n();
        this.e_ = secretKey.e();
        this.iv_ = new byte[iDEA.blockLength()];
        randomStream.read(this.iv_);
        cFB.encrypt(this.iv_);
        this.d_ = new EncryptedBigInt(secretKey.d(), (StreamCipher)cFB);
        this.p_ = new EncryptedBigInt(secretKey.p(), (StreamCipher)cFB);
        this.q_ = new EncryptedBigInt(secretKey.q(), (StreamCipher)cFB);
        this.u_ = new EncryptedBigInt(secretKey.u(), (StreamCipher)cFB);
        this.checksum_ = this.d_.checksum() + this.p_.checksum() + this.q_.checksum() + this.u_.checksum() & 0xFFFF;
    }

    public EncryptedSecretKey(byte[] byArray) throws IOException {
        this.load(byArray);
    }

    public EncryptedSecretKey(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public SecretKey secretKey(StreamCipher streamCipher) throws DecryptException {
        if (this.isEncrypted) {
            streamCipher.decrypt(this.iv_, new byte[this.iv_.length]);
            this.d = this.d_.decrypt(streamCipher);
            this.p = this.p_.decrypt(streamCipher);
            this.q = this.q_.decrypt(streamCipher);
            this.u = this.u_.decrypt(streamCipher);
            if ((this.d_.checksum() + this.p_.checksum() + this.q_.checksum() + this.u_.checksum() & 0xFFFF) != this.checksum_) {
                throw new DecryptException("Check sum failure: passphrase wrong.");
            }
        }
        return new SecretKey(this.n_, this.e_, this.d, this.p, this.q, this.u);
    }

    public void read(DataInput dataInput) throws IOException {
        this.n_ = MPI.read((DataInput)dataInput);
        this.e_ = MPI.read((DataInput)dataInput);
        byte by = dataInput.readByte();
        if (by != 0) {
            if (by != 1) {
                throw new FormatException("Unknown cipher type");
            }
            this.iv_ = new byte[8];
            dataInput.readFully(this.iv_);
            this.d_ = new EncryptedBigInt(dataInput);
            this.p_ = new EncryptedBigInt(dataInput);
            this.q_ = new EncryptedBigInt(dataInput);
            this.u_ = new EncryptedBigInt(dataInput);
            this.checksum_ = dataInput.readShort() & 0xFFFF;
            return;
        }
        this.isEncrypted = false;
        this.d = MPI.read((DataInput)dataInput);
        this.p = MPI.read((DataInput)dataInput);
        this.q = MPI.read((DataInput)dataInput);
        this.u = MPI.read((DataInput)dataInput);
        this.checksum_ = dataInput.readShort() & 0xFFFF;
    }

    public void write(DataOutput dataOutput) throws IOException {
        MPI.write((DataOutput)dataOutput, (BigInteger)this.n_);
        MPI.write((DataOutput)dataOutput, (BigInteger)this.e_);
        dataOutput.write(1);
        dataOutput.write(this.iv_);
        this.d_.write(dataOutput);
        this.p_.write(dataOutput);
        this.q_.write(dataOutput);
        this.u_.write(dataOutput);
        dataOutput.writeShort(this.checksum_);
    }

    public final KeyID id() {
        byte[] byArray = this.n_.toByteArray();
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, 8);
        return new KeyID(byArray2);
    }

    public String toString() {
        return "secret key public parts n:" + this.n_.toString() + " e:" + this.e_.toString() + " all the rest is encrypted";
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }
}

