
package CAS.CAS;
import java.io.*;
import java.util.*;
import java.net.*;

/** Class to send mail.This mailer runs as a thread so that other activities
 * are not blocked by the slow smtp server. 
 */
public class Mailer extends Thread
{
   private static final int smtpport = 25;
   String address,body;

   /** Stores e-mail address and message body.
    * @param addr e-mail address in string format
    * @param body message body. Should have header fields other that from,
    * to. e.g. SMTP doesn't define a header field called Subject but all
    * mail-reader programs recognize it. Such fields should be put at the
    * top of message body and after such fields two \n 's to seperate it from
    * main message body.
    */
   public Mailer(String addr, String body) {
      address = addr;
      this.body = body;
   }

   /** 
    * Calls the method mail to send the requested mail to user.
    */
   public void run() {
      try {
         mail();
      } catch ( IOException e ) {
         // write into log file
      }
   }

   /** Method to send mail. This connects to SMTP port ( 25 ) of the server
    * specified in configuration file and sends data to the server.
    * @exception IOException Thrown when read/write to socket fails. This is
    * also thrown in the program if UnknownHostException occurs.
    */
   private void mail() throws IOException {
         // get smtp server name and our own e-mail address from configuration
         // file.
         String hostname = "everest.cse.iitb.ernet.in";
         String ouraddr = "CAS@cse.iitb.ernet.in";

         Socket sock;   
         try {
            // connect to port 25 of the specified host
            sock = new Socket(hostname, smtpport);
         } catch (UnknownHostException u) {
            // Log error messages
            throw new IOException();
         }

         //        System.err.println(sock.getInetAddress().toString());
         InputStream in = sock.getInputStream();
         OutputStream out = sock.getOutputStream();

         // write SMTP stuff to the socket. Coudn't find out a simpler but
         // platform independant way to implement mailer:-( There is some
         // JavaMail API by sun but it requires JavaBeans Framework or some
         // such thing.
         String mesg = "HELO cas\nMAIL From: " + ouraddr + "\n"
            + "RCPT To: " + address + "\n" 
            + "DATA\n" + body + "\n.\n";
         out.write(mesg.getBytes());
         out.flush();
         // have to read atleast one byte from the socket otherwise the mail
         // is not sent ( why is this ? )
         in.read();

         in.close();
         out.close();
         sock.close();
      }
   public static void main(String args[]) {
      Mailer ml=new Mailer("nravi@cse.iitb.ernet.in","test");
      ml.start();
   }
}
