import java.io.*;
package CAS.SYSADD_FUNCTIONS ;

/** This code defines a Class for each block in the input text
 * of the hash function; used by the class Encrypt
 */

public class block {
	
	// A few static functions to be used by every block
	static final long umax = 0xffffffffl;
	
	static long f1(long x,  long y,  long z) {
		 return ((x & y & umax) | ((~x) & z & umax));
	}

	static long f2(long x, long y, long z) {
		 return ((x^y & umax)^z  & umax);
	}
	
    static long f3(long x, long y, long z) {
		 return ((x & y & umax) | (x & z & umax) | (y & z & umax));
	}
	
	static long f4(long x, long y, long z) {
		 return ((x^y & umax)^z & umax);
	}

	static long rotatel(long x, int n) {
		  long shift1 = x << n;
		  long shift2 = x >> (32 - n);
		  return ((shift1 | shift2) & umax);
	}

	static  long k1 = 0x5a827999l;
	static  long k2 = 0x6ed9eba1l;
	static  long k3 = 0x8f1bbcdcl;
	static  long k4 = 0xca62c1d6l;

	/** Now the instance variables and methods */
	private long m[]; 
	private long w[]; // w stores the expansion of m[16]
	public block next; // next block in the list

	/** Function for getting the 512 (32x16) bits into the array m */
	void input(long input[]) {
		 m = new long[16];
		 w = new long[80];
		 for (int i=0; i < 16; i++)
			 m[i] = input[i];
	}	
	
	/** Expansion function to expand m into the array w */
	void expand() {
		for (int i=0; i < 16; i++)
			w[i] = m[i];
		for (int i=16; i < 80; i++) {
			 long w1, w2, w3;
			 w1 = ((w[i-3] ^ w[i-8] ^ w[i-14] ^ w[i-16]) & umax);
			 w[i] = rotatel(w1,1);
		}
	}
	
	/** Function to mix the 5 old variables and return 5 new ones */
	void mix( long in[]) { 
		for (int i=0; i < 80; i++) {
			long a3 = rotatel(in[0],5);
			long temp = 0l;
			switch ((int)(i/20)) {
			case 0 : temp = a3 ^ f1(in[1], in[2], in[3]) ^ in[4] ^ w[i] ^ k1;
				     break;
		    case 1 : temp = a3 ^ f2(in[1], in[2], in[3]) ^ in[4] ^ w[i] ^ k2;
		        	 break;
		    case 2 : temp = a3 ^ f3(in[1], in[2], in[3]) ^ in[4] ^ w[i] ^ k3;
		        	 break;
		    case 3 : temp = a3 ^ f4(in[1], in[2], in[3]) ^ in[4] ^ w[i] ^ k4;
    	             break;
    	    }
			temp = temp & umax;
    	    in[4] = in[3];
    	    in[3] = in[2];
    	    in[2] = rotatel(in[1],30);       	
    	    in[1] = in[0];
    	    in[0] = temp;
		}
	}
}	
	
               
