import java.io.*;
import javax.security.*;
import HTTPClient.*;

/**
 * The protocol goes something like I send to the server
 * ApplicationID, Object crypted with server's public key
 * when I receive the Object I decrypt it, using the client's 
 * private key, and get the return Object; At the 
 * time of application registration, the client generates the 
 * key pair keeps the private key with it self and gives
 * public key to the server, now the applications which have 
 * access to this particular key, and know the application 
 * registration id will be able to submit the requests, and 
 * receive replies.
 * 		clientsk refers to the client's secret key
 * 		serverpk refers to the server's public key
 *
 */

public class CryptClient {
   public static final String 
      keyPairName = "RSA",
      cipherName   = "RSA/ECB/OneAndZeroes",
      sigalgo = "MD5/RSA/PKCS#1";
   /** 
    * Stores the path of client's secret key
    */
   public String clientSkFile = null;

   public static final int strength=512;
   /** 
    * server's Public Key, received at the time of registration of package
    */
   protected PublicKey serverPk     =null;
   /** 
    * client's Private key, will be stored in the file system, will be
    * readable by packages with certain privileges
    */
   protected PrivateKey clientSk    =null;
   /** 
    * client's ID
    */
   protected String clientID        =null;
   /**
    * Cipher class we use
    */
   protected Cipher rsa             =null;
   /** 
    * server's ID
    */
   protected String serverID        =null;
   /**
    * takes clientID, clientSkFile as a parameter, and loads the client's
    * secret key and server public key from the given files
    */
   public CryptClient(String clientID, String clientSkFile, String serverPkFile) 
      throws FileNotFoundException, SecurityException {
         this.clientID = clientID;
         try {
            // clientsk / serverpk can be set by the application if it has the instance
            // and wants to avoid the load time over and over again
            if (clientSk==null) {
               FileInputStream   fl  =new FileInputStream(clientSkFile);
               ObjectInputStream ois =new ObjectInputStream(fl);
               clientSk              =(PrivateKey)ois.readObject();
            }
            if (serverPk==null) {
               FileInputStream   fl  =new FileInputStream(serverPkFile);
               ObjectInputStream ois =new ObjectInputStream(fl);
               serverPk              =(PublicKey)ois.readObject();
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   protected static ObjectInputStream getObjectInputStream(byte [] inbuf)
      throws IOException {
         ByteArrayInputStream bais = new ByteArrayInputStream(inbuf);
         return new ObjectInputStream(bais);
      }

   /** The following function takes an object, serializes it, encrypts it using 
	* the server's public key, signs it using the application's private key
	* and returns the signed, encrypted string of bytes; The method
	* is absolutely isomorphous to the getCryptedStream(Object) function
	* on the Server side and hence documentation is not in detail here
	*/
   public byte [] getCryptedStream(Object ob) throws Exception {		
		 // Part 1 - Encryption
		 ByteArrayOutputStream baos = new ByteArrayOutputStream();
         ObjectOutputStream oos = new ObjectOutputStream(baos);
         oos.writeObject(clientID);
         oos.writeObject(ob);
         oos.close();
         byte [] plain = baos.toByteArray();
         rsa = Cipher.getInstance(cipherName);
         rsa.initEncrypt(serverPk);
         byte [] cip = rsa.crypt(plain); 
		 
		 // Part 2 - Signing
		 /*
		  Signature sig = Signature.getInstance(sigalgo);
	      sig.initSign(clientSk);
	      sig.update(cip);
	      byte [] signature = sig.sign();
    	
		 
		 // Part 3 - Packaging them up together
	     ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
         ObjectOutputStream oos2 = new ObjectOutputStream(baos2);
 		 oos2.writeObject(cip);
		 oos2.writeObject(signature);
         oos2.close();
		 
		 byte[] returnArray = baos2.toByteArray();
		 return returnArray;
		 */
		 return cip;
   }
   
   /**  This method takes a stream of bytes obtained from the response of
	 *  the CAS, decrypts it, verifies the CAS's signature and returns the 
	 *  original object that gave the byte stream; Again analogous to 
	 *  the deCryptObject method of CryptServer.
	 */
   
   public Object getDecryptedObject(byte[] mes) throws Exception {
      Object ret;
      rsa = Cipher.getInstance(cipherName);
      rsa.initDecrypt(clientSk);
	  ObjectInputStream inpu = getObjectInputStream(mes);
	  byte[] content = (byte[])inpu.readObject();
	  byte[] sign = (byte[])inpu.readObject();
	  inpu.close();
      byte [] combo = rsa.crypt(content); //decrypting the content
      ObjectInputStream ois = getObjectInputStream(combo);
      ret=ois.readObject();
      ois.close();
	  //verifying signature:
	  Signature sig = Signature.getInstance(sigalgo);
	  sig.initVerify(serverPk);
	  sig.update(content);
	  boolean verifies = sig.verify(sign);
	  if(!verifies)
		   throw new Exception ("Signature verification failure.");
	
	return ret;
   }
   /** 
    * Generates the private key and the public key for the client and stores them in file
    * clientSecretKey, and clientPublicKey
    * clientPublicKey          is uploaded to the server
    * while clientSecretKey    is stored in the file system at some secure place
    */
   public static void main (String args[]) {
      try {
         System.out.println("CryptClient: generating Public and Private Key for Application");
         KeyPairGenerator kg = KeyPairGenerator.getInstance(keyPairName);
         kg.initialize(strength, new SecureRandom());
         KeyPair pair = kg.generateKeyPair();
         PublicKey  clientPubk = pair.getPublic();
         PrivateKey clientSeck = pair.getPrivate();
         FileOutputStream   fl  =new FileOutputStream("clientSecretKey");
         ObjectOutputStream oos =new ObjectOutputStream(fl);
         oos.writeObject(clientSeck);
         fl                     =new FileOutputStream("clientPublicKey");
         oos                    =new ObjectOutputStream(fl);
         oos.writeObject(clientPubk);
         System.out.println("CryptClient: Please give the clientPublicKey to the server");
      }
      catch ( Exception anyex ) {
         anyex.printStackTrace();
         System.err.println("CryptClient: Unable to generate the client private and public keys");
      }
   }
}
