import java.io.*;
import java.sql.*;
import javax.security.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Architecture client maintains a private key clientsk and we 
 * have the the public key of the client at our end, we decrypt
 * the Message with the private key of Server, and crypt the 
 * outgoing message with the public key of the client, the public
 * key is chosen according to the clientID of application
 * At the same time, we sign the message with the private key of the Server
 * which the client verifies with the public key of the server
 *
 */


public class CryptServer {
  protected final static String 
	   keyPairName = "RSA",
  	   cipherName = "RSA/ECB/OneAndZeroes",
	   sigalgo = "MD5/RSA/PKCS#1";

//  	   clientsPkFile = "serverPublickey",   // server's public key stored here 
 //	   clientsSkFile = "serverSecretKey";   // server's secret key stored here

  protected static final int strength = 512;

  protected static Connection conn =null;
  public  String clientID ="";
  protected Cipher rsa =null;
  protected PublicKey clientPk =null;
  protected PrivateKey serverSk =null;

  // Opening a Single time connection to SQL database.
  
  static {
    try {
      // This will help in changing database engine depending on configuration
      // files
      Class.forName(CASConfig.jdbcDriver).newInstance();
//	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f12","clear1");
      conn = DriverManager.getConnection(CASConfig.jdbcURL);
//	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f12","clear2");
	  System.out.println("good");
    } catch (Exception e) {
	  e.printStackTrace();
	  System.out.println("Connection could not be made");
//	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f11","again");
    }
  }
  
  
  /**
   * This Method converts byte array into an InputStream
   */
  protected static ObjectInputStream getObjectInputStream(byte [] inbuf)
    throws IOException {
      ByteArrayInputStream bais = new ByteArrayInputStream(inbuf);
      return new ObjectInputStream(bais);
    }

  /**
   * This method loads Client Public Key from Database
   */
  public boolean loadClientDBPk() {
    if (clientPk != null ) return true;
    try {
      Statement stmt3 = conn.createStatement();
      ResultSet rs3 = stmt3.executeQuery("select pub_key from " + CASConfig.indexapp + " where app_id = '" + clientID + "'");
      if (rs3.next()) {
	ObjectInputStream ois = getObjectInputStream(rs3.getBytes(1));
	clientPk = (PublicKey) ois.readObject();
      } else {
	return false; // application id doesn't exists in our database.
      }
      rs3.close();
      stmt3.close();
      return true;
    }
    catch ( Exception anyex ) { 
      anyex.printStackTrace();
    }
    return false;
  }

  /**
   * This method loads Client PublicKey from the file system
   */
  public boolean loadClientPk() {
    if (clientPk!=null) return true;
    try {
      FileInputStream fis=new FileInputStream(CASConfig.AppPublickey + clientID);
      ObjectInputStream ois=new ObjectInputStream(fis);
      clientPk = (PublicKey) ois.readObject();
    } catch (Exception e) { 
      e.printStackTrace();
      return false; 
    }
    return true;
  }

  /**
   * This method when given a public key for a client as a byte array
   * puts it into the Server Database as a Binary Large Object( blob)
   */
  public static boolean putClientPublicKey(PrintWriter out, String clientID, byte[] tmp) {
    out.println("<PRE>");
    out.println(tmp.length);
    try {
      PreparedStatement stmt2 = conn.prepareStatement("update " + CASConfig.indexapp + 
				" set pub_key = ? where app_id = '" + clientID + "'");
      stmt2.setBytes(1,tmp);
      int cnt1=stmt2.executeUpdate();
      if (cnt1!=1) throw new Exception("No such user");
      stmt2.close();
      out.println("</PRE>");
      return true;
    }
    catch ( Exception anyex ) {
      anyex.printStackTrace(out);
    }
    out.println("</PRE>");
    return false;
  }

  public String getLogin() { 
    return clientID; 
  }

  /**
   * This Method decrypts the request stream using the server's secret key,
   * deserializes it and returns an object associated with it. 
   */
  public Object getDecryptedObject(HttpServletRequest req) throws Exception {
      int inlen=req.getContentLength();
      byte [] tmp=new byte[inlen];
      req.getInputStream().read(tmp);
      file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo6");	
//	  ObjectInputStream inp = getObjectInputStream(tmp);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyonew");
//	  byte[] content = (byte[]) inp.readObject();
	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo100");
 //     byte[] sign = (byte[]) inp.readObject();
	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo7");
//	  inp.close();
	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo10");
	  rsa = Cipher.getInstance(cipherName);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo11");
      rsa.initDecrypt(serverSk);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo12");
  //    byte [] combo = rsa.crypt(content);
       byte [] combo = rsa.crypt(tmp);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo13");
	  ObjectInputStream ois = getObjectInputStream(combo);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo14");
      clientID = (String)ois.readObject();
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo15");
      Object ret = ois.readObject();
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","kyoooo16");
      ois.close();
	  //verifying signature
	  /*
	  Signature sig = Signature.getInstance(sigalgo);
	  sig.initVerify(clientPk);
	  sig.update(content);
	  boolean verifies = sig.verify(sign);
	  if(!verifies)
     	   throw new Exception ("Signature verification failure.");
		   */
	return ret;
 
  }
  
  /**
   * Takes an object, serializes it and returns a byte array crypted by
   * the client's public key.
   */
  public byte [] getCryptedStream(Object ob) throws Exception {
      // Part 1 - Convert the passed object into a array of bytes and 
	  //          encrypt this using the public key of the client
	  byte [] returnArray = null;
   try{	   
	  ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);
	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","1");
	  //      oos.writeObject(serverID);
      oos.writeObject(ob);
	  file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","2");
      oos.close();
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","1");
      byte [] plain = baos.toByteArray();
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","2");
      if (!loadClientPk()) throw new Exception("Unable to load client's Public Key");
      rsa = Cipher.getInstance(cipherName);
      rsa.initEncrypt(clientPk);
	  byte[] ciph = rsa.crypt(plain);
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","3");
      // Part 2 - Ciph is the encrypted form of the object. Now we generate
	  //          a signature of the server using its private key and append the
	  //          signature to cipher.
	  Signature sig = Signature.getInstance(sigalgo);
	  sig.initSign(serverSk);
	  sig.update(ciph);
	  byte [] signature = sig.sign();
        file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","4");
	  // Part 3 - Write out the encrypted object and the signature to 
	  //          an o/p stream and then return the string of bytes 
	  //          corresponding to this stream
	  
	  ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
      ObjectOutputStream oos3 = new ObjectOutputStream(baos3);
      oos3.writeObject(ciph); // Ah ! written the ciphertext
	  oos3.writeObject(signature); // Here goes the signature
	  oos3.close();
	    file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","5");
	    returnArray = baos3.toByteArray();
	    file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f10000","6");
   }catch(Exception e){file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f99000","expr");}
	  return returnArray;
  }

  /**
   * Loads the server secret key.
   */
  public CryptServer(String serverSkFile) {
    try {
		 System.out.println("kyoooo");
      FileInputStream   fl   =new FileInputStream(serverSkFile);
	   System.out.println("kyoooo2");
      ObjectInputStream ois  =new ObjectInputStream(fl);
	   System.out.println("kyoooo3");
      serverSk          =(PrivateKey)ois.readObject();
	   System.out.println("kyoooo4");
	   file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/f2","haan");
      fl.close();
      ois.close();
    }
    catch ( Exception anyex ) {
      anyex.printStackTrace();
    }
  }

  /**
   * On command line invocation creates server public key and server
   * private key.Server Public key should be accessible to application
   * developers from the servers site.And private key should be stored
   * securely.
   */
  
  public static void main(String args[]) {
    try {
      System.out.println("CryptServer: generating Public and Private Key for Server");
      KeyPairGenerator kg = KeyPairGenerator.getInstance(keyPairName);
      kg.initialize(strength, new SecureRandom());
      KeyPair pair = kg.generateKeyPair();
      PublicKey spk = pair.getPublic();
      PrivateKey ssk = pair.getPrivate();
      FileOutputStream   fl  =new FileOutputStream("serverPublicKey");
      ObjectOutputStream oos =new ObjectOutputStream(fl);
      oos.writeObject(spk);
      fl                     =new FileOutputStream("serverSecretKey");
      oos                    =new ObjectOutputStream(fl);
      oos.writeObject(ssk);
    } catch (Exception e) {
      e.printStackTrace();
      System.err.println("CryptServer: Unable to generate the server public and private"
	  +"keys");
    }
  }
  
}

