/* 
 * AutoMailNotifier.
 * sends a confirmation email to the sender to tell that the service request 
 * has been received. Also if the sender asks for services for the first time 
 * and we do not have any info on the customer then additional subject text is 
 * written advising the customer to fill up an information form giving personal 
 * information
 */

class AutoMailNotifier {
	 
	 private SMTPMail smtp;
	 private SQLEngine sfe;

	 public AutoMailNotifier() {
		  sfe  = new SQLEngine();
		  smtp = new SMTPMail();
		  
		  smtp.setSenderEmailaddress("csr@cse.iitb.ernet.in");
		  smtp.setSMTPsenderhost("everest.cse.iitb.ernet.in");
		  /** In general to send the mail outside IIT */
		  //smtp.setSMTPreceiverhost("mailhost.iitb.ac.in");
		  smtp.setSMTPreceiverhost("everest.cse.iitb.ernet.in");
	 }

	 public void notify(String cus_name, String cus_emailid) {
		  String headerbody = "From: CustomerServiceRep  <csr@cse.iitb.ernet.in>"+
			   				  "\nTo: " + cus_name +"  <"+ cus_emailid +">"+
							  "\nSubject:  Confirmation regarding your service request" +
							  "\nMime-Version: 1.0 \nContent-Type: text/html; charset=us-ascii" + 
							  "\nX-Mailer: Mutt 1.0pre3i\n" +
							  "<HTML><BODY>" +
							  "\n<p>Hello "+ cus_name + ",<BR>" +
							  "\n<BR>We have received your service request. You are receiving this email"+
							  "\n<BR>in acknowledgement of your service request/query email to us.";

		  String buf[] = sfe.execQuery("SELECT customer_tag FROM customer WHERE email_id='"+cus_emailid+"'");
		  
		  if (buf.length == 1) { // meaning there is no info on customer in the DB 
			   headerbody += "\n\n<BR><p>In order to give you better service we do require some information"+
					         "\n<BR>regarding you. We would like you to fill up this information form."+
							 "\n<BR><a href=http://144.16.111.4:8008~/servlet/myqs1servlet?> Information Form </a>";
		  }
		  headerbody += "\n<BR><BR>Thanking you,\n<BR> Sincerely,\n\t<BR> CSR</body></html>";
					
		  smtp.mail(cus_emailid, headerbody);
	 }

	 /* TEST
	 public static void main(String[] args) {
		  AutoMailNotifier amn = new AutoMailNotifier();
		  amn.notify("Raj Sansare","rajs@cse.iitb.ernet.in");
	 }
	 */
}
