/** The class shows the previous emails for a particular customer */

import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/**  
 * @author Rajendra Sansare 
 */

/* First doPost() is called which in turn calls doGet() of this servlet */

public class CaseHistoryServlet extends HttpServlet implements SingleThreadModel {
	 
	 /** HTML header and footer generator */
	 private HTMLtags htag;  
	 
	 /** SQL Functional Engine to carry out various tasks */
	 private SQLEngine sfe;  

	 
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  htag = new HTMLtags();
		  sfe = new SQLEngine();
	 }


	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		   response.setContentType("text/html");
		   PrintWriter pw = response.getWriter();
		   
		   String customertag = request.getParameter("casecusttag");
		   String customeremailid = request.getParameter("caseemailid");
		   
		   String actionurl = request.getScheme() + "://";
		   actionurl += request.getServerName() + ":";
		   actionurl += request.getServerPort();
		   actionurl += "~/servlet/CaseHistoryServlet?message_id="; /* name of the servlet */

		   String pseudquery = " from_name,emaildate,time,"
				+ "' <a href=" + actionurl +  "' || message_id || ' > ' || subject ||  ' </a> ' ";
		   

		   htag.header(pw);
				pw.println("<HR><FONT COLOR=#FFFFFF>");
				pw.println("customertag|" + customertag +"|");
				pw.println("<HR>");
				pw.println("customeremailid|" + customeremailid +"|");
				pw.println("</FONT><HR>");
		   

		   if ( customeremailid.equals(null) || customeremailid.equals("")) {
				if (customertag.equals(null) || customertag.equals("")) {
					 pw.println("<B><FONT COLOR=#FFFFFF> You must specify either customer emailid" +
							   " or customer tag </FONT></B>");
				} else {
					 String cusemailids[] = sfe.execQuery("SELECT email_id FROM customer WHERE customer_tag='"
							   + customertag.trim() +"'");
					 if ( cusemailids.length > 1) {
						  customeremailid = cusemailids[1];
						  sfe.execQuery("SELECT "+ pseudquery +" FROM customeremail WHERE from_emailid='"+ 
									customeremailid.trim() +"'",pw);
					 } else {
						  pw.println("<B><font color=#ffffff> The customer tag given as input is not" 
									+ "present  in the Database</font></B>");
					 }
				}
		   } else {
				pw.println("<BR> Table : CustomerEmail <BR>");
				
				sfe.execQuery("SELECT" + pseudquery + "FROM customeremail WHERE from_emailid='"+ 
					 customeremailid.trim() +"'",pw);
		   }
		   
		   htag.footer(pw);
	 }
	 
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		   response.setContentType("text/html");
		   PrintWriter pw = response.getWriter();

		   
		   String actionurl = request.getScheme() + "://";
		   actionurl += request.getServerName() + ":";
		   actionurl += request.getServerPort();
		   actionurl += "~/servlet/ReplyEmailServlet"; /* name of the servlet */
		   
		   try {
		   htag.header(pw);
		   String message_id = request.getParameterValues("message_id")[0];
		   message_id = message_id.trim();
		   pw.println(" Message-id : " + request.getParameterValues("message_id")[0] );
		  
		   pw.println("<CENTER>");
		   pw.println("<FORM action=" + actionurl + " method=get>"); 
		   
		   pw.println("<TABLE border=0 cellspacing=2 cellpadding=2>");
		   pw.println("<TR><TD nowrap bgcolor=cccccc>");
		  
		   pw.println("<TABLE border=0 cellspacing=2 cellpadding=2>");

		   pw.println("<TR><TD nowrap bgcolor=B080FF>");
		   pw.println("<B>From :</B></TD><TD>" + 
					 sfe.execQuery("SELECT from_name, '  < ' || from_emailid || ' > ' FROM " +
						  " customeremail WHERE message_id='" + message_id + "'")[1]
					 + "</TD></TR>");

		   pw.println("<TR><TD nowrap bgcolor=B080FF>");
		   pw.println("<B>Reply-To :</B></TD><TD>" + 
					 sfe.execQuery("SELECT replyto_name, '  < ' || replyto_emailid || ' > ' FROM " +
						  " customeremail WHERE message_id='" + message_id + "'")[1]
					 + "</TD></TR>");
		   
		   pw.println("<TR><TD nowrap bgcolor=B080FF>");
		   pw.println("<B>Subject :</B></TD><TD>" + 
					 sfe.execQuery("SELECT subject from customeremail where message_id='" + message_id + "'")[1]
					 + "</TD></TR>");
		   
		   pw.println("<TR><TD nowrap bgcolor=B080FF>");
		   pw.println("<B>Date :</B></TD><TD>" + 
					 sfe.execQuery("SELECT emaildate,'&nbsp;',time from customeremail where message_id='" + message_id + "'")[1]
					 + "</TD></TR>");

		   pw.println("</TABLE>");
		   
		   pw.println("</TD></TR>");
		   
		   pw.println("<TR><TD bgcolor=FFFFFF>");

		   pw.println("<BR><PRE>" + 
					sfe.execQuery("SELECT body FROM CustomerEmail where message_id ='" + message_id +"'")[1] 
					+"</PRE><BR>");
		  
		   pw.println("</TD></TR>");
		   pw.println("<TR><TD bgcolor=#FFFFFF>");
		   pw.println("<FONT COLOR=#000000> Comments made for the email by CSR <BR>");
		   pw.println(sfe.execQuery("SELECT csrcomment FROM Email_Status")[1]); 
		   pw.println("</FONT></TD></TR>");
		   pw.println("<TR><TD bgcolor=#000077>");
		   pw.println("<FONT COLOR=#FFFFFF>");
		   pw.println("<CENTER>");
		   pw.println("<input type=submit name=Reply      value=Reply>");
		   pw.println("<input type=submit name=Replytoall value=ReplyToAll>");
		   pw.println("<input type=submit name=Forward    value=Forward>");
		   pw.println("</FORM>");
		   pw.println("</CENTER>");
		   pw.println("</FORM>");
		   pw.println("</TD></TR>");

		   pw.println("</TABLE>");
		   pw.println("</CENTER>");
		  
		   htag.footer(pw);
		   } catch (ArrayIndexOutOfBoundsException aie) {
			   pw.println("<B> A problem occured will fetching the email content .Please try again later.</B>");
			   pw.println("</BODY></HTML>");
			   aie.printStackTrace();
		   }
	  }
}
