/**   DBALogin() --  createConnectionDialog() -- activateConnectionDialog() -- createTable() 
 *        |                                               |
 *     ---------------------------------------            |
 *     |                                     |         connect()
 *     fetch()                            activateConnectionDialog()   
 */
/*
 * A a UI around the JDBCAdaptor, allowing database data to be interactively
 * fetched, sorted and displayed using Swing.
 *
 * NOTE: This example uses a modal dialog via the static convenience methods in
 * the JOptionPane. Use of modal dialogs requires JDK 1.1.4 or greater.
 *
 */

/** @author Rajendra Sansare Copyright 2000 */

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class DBALogin implements LayoutManager {
	 
    static String[] ConnectOptionNames = { "Connect" };
    static String   ConnectTitle = "Connection Information";

    Dimension   origin = new Dimension(0, 0);

    JButton     fetchButton;
    JButton     showConnectionInfoButton;
	/** addons */
	JButton 	changepasswordButton;
	

    JPanel      connectionPanel;
    JFrame      frame; 

    JLabel      userNameLabel;
    JTextField  userNameField;
    JLabel      passwordLabel;
    JPasswordField  passwordField;
    JTextArea   queryTextArea;
    JComponent  queryAggregate;
    JLabel      serverLabel;
    JTextField  serverField;
    JLabel      driverLabel;
    JTextField  driverField;

    JPanel      mainPanel;

    TableSorter sorter;
    JDBCAdapter dataBase;
    JScrollPane tableAggregate;

    /**
     * Brings up a JDialog using JOptionPane containing the connectionPanel.
     * If the user clicks on the 'Connect' button the connection is reset.
     */

    public void connect() {
       dataBase = new JDBCAdapter(
            serverField.getText(),
            driverField.getText(),
            userNameField.getText(),
            passwordField.getText());
	   
       		sorter.setModel(dataBase);
	}
	
    void activateConnectionDialog() {
	if(JOptionPane.showOptionDialog(tableAggregate, connectionPanel, ConnectTitle,
		   JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                   null, ConnectOptionNames, ConnectOptionNames[0]) == 0) {
	    connect();
		frame.setVisible(true);
	}
	else if(!frame.isVisible())
	    System.exit(0);
    }

    /**
     * Creates the connectionPanel, which will contain all the fields for
     * the connection information.
     */
    public void createConnectionDialog() {
 	/* Create the labels and text fields. */
	userNameLabel = new JLabel("User name: ", JLabel.RIGHT);
 	userNameField = new JTextField("rajs");

	passwordLabel = new JLabel("Password: ", JLabel.RIGHT);
	passwordField = new JPasswordField("guess");

    serverLabel = new JLabel("Database URL: ", JLabel.RIGHT);
	serverField = new JTextField("jdbc:oracle:thin:@everest:1521:GEN");

	driverLabel = new JLabel("Driver: ", JLabel.RIGHT);
	driverField = new JTextField("oracle.jdbc.driver.OracleDriver");


	connectionPanel = new JPanel(false);
	connectionPanel.setLayout(new BoxLayout(connectionPanel,
						BoxLayout.X_AXIS));

	JPanel namePanel = new JPanel(false);
	namePanel.setLayout(new GridLayout(0, 1));
	namePanel.add(userNameLabel);
	namePanel.add(passwordLabel);
	namePanel.add(serverLabel);
	namePanel.add(driverLabel);

	JPanel fieldPanel = new JPanel(false);
	fieldPanel.setLayout(new GridLayout(0, 1));
	fieldPanel.add(userNameField);
	fieldPanel.add(passwordField);
	fieldPanel.add(serverField);
    fieldPanel.add(driverField);

	connectionPanel.add(namePanel);
	connectionPanel.add(fieldPanel);
    }

	/* Constructor */
    public DBALogin() {
        mainPanel = new JPanel();

        // Create the panel for the connection information
		createConnectionDialog();
		
    	// Create the buttons.
		showConnectionInfoButton = new JButton("Configuration");
        showConnectionInfoButton.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	            activateConnectionDialog();
	        }
	    });
		
		fetchButton = new JButton("Execute");
        fetchButton.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	            fetch();
	        }
	    });
		
		changepasswordButton = new JButton("ChPassword");
		changepasswordButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				changepassword();
				}
		});
				  	
				  
		// Create the query text area and label.
        queryTextArea = new JTextArea("SELECT * FROM TAB", 10, 15);
		queryAggregate = new JScrollPane(queryTextArea);
        queryAggregate.setBorder(new LineBorder(Color.black,3));

        // Create the table.
        tableAggregate = createTable();
		/** this is not showing up Check why */
        tableAggregate.setBorder(new LineBorder(Color.black,3));
        //tableAggregate.setBorder(new BevelBorder(BevelBorder.LOWERED));

		// Add all the components to the main panel.
        mainPanel.add(fetchButton);
        mainPanel.add(changepasswordButton);
        mainPanel.add(showConnectionInfoButton);
        mainPanel.add(queryAggregate);
        mainPanel.add(tableAggregate);
        mainPanel.setLayout(this);

        // Create a Frame and put the main panel in it.
        frame = new JFrame("DBALogin  by rajs,pavinash,amitabh,jaywant Copyright 2000");
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}});
        frame.setBackground(Color.white);
        frame.getContentPane().add(mainPanel);
        frame.pack();
        frame.setVisible(false);
        frame.setBounds(100, 100, 800, 500);
		
		activateConnectionDialog();
    }


    public void fetch() {
        dataBase.executeQuery(queryTextArea.getText());
    }
	
	public void changepassword() {
		 System.out.println("Changing password");
		 /* implement this */ 
	}

    public JScrollPane createTable() {
        sorter = new TableSorter();

        // Create the table
        JTable table = new JTable(sorter); 
 		table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS); 
 		//table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF); 

        // Install a mouse listener in the TableHeader as the sorter UI.
        sorter.addMouseListenerToHeaderInTable(table);

        JScrollPane scrollpane = new JScrollPane(table);

        return scrollpane;
    }

    public static void main(String s[]) {
        new DBALogin();
    }

    public Dimension preferredLayoutSize(Container c){return origin;}
    public Dimension minimumLayoutSize(Container c){return origin;}
    public void addLayoutComponent(String s, Component c) {}
    public void removeLayoutComponent(Component c) {}
    public void layoutContainer(Container c) {
        Rectangle b = c.getBounds();
        int topHeight = 90;
        int inset = 5;
        showConnectionInfoButton.setBounds(b.width-2*inset-135, inset, 135, 25);
        changepasswordButton.setBounds(b.width-2*inset-135, 2*inset+25, 135, 25);
        fetchButton.setBounds(b.width-2*inset-135,3*inset+50, 135, 25);
        queryAggregate.setBounds(inset, inset, b.width-2*inset - 150, 80);
        tableAggregate.setBounds(new Rectangle(inset,
                                               inset + topHeight,
                                               b.width-2*inset,
                                               b.height-2*inset - topHeight));
    }
	
} 
