import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This class shows the Service_Basket entityset details  and
 * provides an interface  to add new services to the set .
 * @author Rajendra Sansare 
 */

public class ServiceBasketServlet extends HttpServlet implements SingleThreadModel {
	 
	 private SQLEngine sfe;
	 private HTMLtags htag;

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  sfe  = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 

	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/";
		  String serass  = actionurl + "AssignCSRService?";
		  String csr = actionurl + "EditCSRServlet?";
		  actionurl += "ServiceBasketServlet"; /* name of the servlet */


		  String query = "";
		  htag.header(pw);
		  
		  pw.println("<FORM  method=POST action="+actionurl+">");
		  /** %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */                                          

		  /** Note */
		  pw.println("<font color=#ff0000><b> NOTE </b></FONT><BR>");
		  pw.println("<FONT color=#ffffff><H1>&nbsp;Maximum limit of tag is 10 and service and serv_keywords is 50 .</H1><BR>");
		  pw.println("</font><HR><BR>");
		  
		  pw.println("<a href="+ serass + ">Assign CSR service's to handle</a><BR>");
		  pw.println("<a href="+ csr + ">Add/Edit  CSR Personnel</a><BR><HR><BR>");
		  
		  //query = "SELECT * FROM Service_basket";
		  query = "SELECT '<input type=radio name=editdel value=edi' || service_tag || '>  Edit' ,"
			   + "'<input type=radio name=editdel value=del' || service_tag || '>  Del', service_tag,service,serv_keywords "
			   + " FROM service_basket";
		  pw.println("<B><FONT COLOR=#FFFFFF> Service Basket : </FONT></B><BR>");
		  sfe.execQuery(query,pw);
		  pw.println("<FONT color=#ffffff><input type=radio name=editdel checked value=new checked> Add new Service  </font><BR>"); 
		  printTable(pw);
		  
		  pw.println("<CENTER><input type=submit value=Submit>");
		  pw.println("<input type=reset  value=Reset></CENTER>");
		  pw.println("</FORM>");

		  htag.footer(pw);
	 }
	 
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  htag.header(pw);
		  pw.println("<B> Received </B><BR>");
		  
		  String editdelnew = request.getParameterValues("editdel")[0];
		  String actype = editdelnew.substring(0,3);
		  
		  pw.println("<B>" + editdelnew + "</B><BR>");
		  pw.println("<B>" + actype + "</B><BR>");

		  String sertag = request.getParameterValues("sertag")[0];
		  String service = request.getParameterValues("service")[0];
		  String serkeyword = request.getParameterValues("serkeyword")[0];

		  if (actype.equals("new")) {
			   InsertintoTables(sertag,service,serkeyword,pw);
		  } else {
			   String upstmt = "";
			   if (actype.equals("edi")) {
					pw.println(" Edit function <BR>");
					upstmt = "UPDATE service_basket SET service_tag='"+sertag.trim()
						 +"', service='"+ service.trim() +"', serv_keywords='"+serkeyword.trim()
						 +"' where service_tag='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   } else {
					pw.println(" Del function <BR>");
					upstmt = "DELETE FROM service_basket where service_tag='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   }
		  }
		  
		  htag.footer(pw);
	 }

	 /** inserts the new values of service tag,description  of the service  and the keywords for the service  
	  * @param string sertag - service tag 
	  * @param string service - description of service
	  * @param serkeyword - keywords for the service
	  * @param Printwriter pw 
	  */ 
	 public void InsertintoTables(String sertag, String service, String serkeyword,PrintWriter pw) {
		  String instmt = "";
		  boolean anynullval = true; 
		  
		  if (sertag.equals("") || sertag.equals(null)) anynullval = false;
		  if (service.equals("") || service.equals(null)) anynullval = false;
		  if (serkeyword.equals("") || serkeyword.equals(null)) anynullval = false;

		  if (anynullval) {
			   pw.println("<font color=#ffffff> For Table Service_Basket :<br>"); 
			   instmt = "INSERT INTO service_basket VALUES ('"+ sertag.trim() +"','" + service.trim() +"','" 
					+ serkeyword.trim() +"')"; 
			   pw.println(" values " + sertag + "&nbsp;  " + service + "&nbsp;  " +serkeyword + " has been inserted<Br>");
			   pw.println( sfe.InsertData(instmt) + "</font>" );
		  } else {
			   // do nothing
			   pw.println("<font color=#ffffff> No value has been inserted as a null input is given </font><br>"); 
		  }
	 }

	 /**
	  * @param PrintWriter pw
	  */
	 public void printTable(PrintWriter pw) {
		  pw.println("<BR><BR>");
		  pw.println("<center><table BORDER=0 CELLSPACING=2 CELLPADDING=2 COLS=1 WIDTH=75% BGCOLOR=#CCCCCC >");
		  pw.println("<tr><td><center>");
		  pw.println("<table BORDER=0 COLS=2 WIDTH=100% BGCOLOR=#B080FF NOSAVE >");
		  pw.println("<tr NOSAVE>");
		  pw.println("<td NOSAVE>");
		  pw.println("<center><font color=#000000> Service_Tag </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Service </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Service Keywords </font></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  
		  pw.println("<tr>");
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=sertag size=27 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=service size=27 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=serkeyword size=27 value=></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table>");
		  pw.println("</center>");
		  
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table></center>");
		  pw.println("<HR>");
	 }
}
