import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Priority Scale is from 1 to 10  highest is 1 lowest is 10*/
/** @author Rajendra Sansare */


/* This class takes the parameters on which to prioritize the customer and
 * inserts them into the SetPriorities entity set .The parameters can be 
 * single or multiple . In case of multiple and conflicting priorities , 
 * error can be reported  or preference may be given to the parameter with a
 * higher weightage as decided by the CRM personnel/DBA .
 */

/* Have an interface like the MS Excel which allows many textfields in 
 * rows . since the priorities can be set and implemented only according to 
 * the information in the DB , show the DB fields in the interface with the option
 * of selecting them and assigning  the weightages . Also addtional user preferences 
 * may be inserted .
 */


public class SetPriorities extends HttpServlet implements SingleThreadModel {
	 private SQLEngine sfe;
	 private HTMLtags htag;

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  sfe  = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 

	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/SetPriorities";

	 
		  String query = "";
		  htag.header(pw);
		  
		  pw.println("<FORM  method=POST action="+actionurl+">");
		  /** %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */                                          

		  /** Note */
		  pw.println("<font color=#ff0000><b> NOTE </b></FONT><BR>");
		  pw.println("<FONT color=#ffffff><H1>&nbsp;Assign a priority value between 1 and 10 .</H1><BR>");
		  pw.println("</font><HR><BR>");

		  query = "SELECT '<input type=radio name=editdel value=edi' || indexval || '>  Edit' ,"
			   + "'<input type=radio name=editdel value=del' || indexval || '>  Del', tablename, fieldname, fieldvalue, priority"
			   + " FROM priorities";
		  pw.println("<B><FONT COLOR=#FFFFFF> Priorities: </FONT></B><BR>");
		  sfe.execQuery(query,pw);
		  pw.println("<FONT color=#ffffff><input type=radio name=editdel checked value=new checked> Add a new priority tuple </font><BR>"); 
		  printTable(pw);
		  
		  pw.println("<CENTER><input type=submit value=Submit>");
		  pw.println("<input type=reset  value=Reset></CENTER>");
		  pw.println("</FORM>");

		  htag.footer(pw);
	 }
	 
	 /**
	  * @param PrintWriter pw
	  */
	 public void printTable(PrintWriter pw) {
		  pw.println("<BR><BR>");
		  pw.println("<center><table BORDER=0 CELLSPACING=2 CELLPADDING=2 COLS=1 WIDTH=75% BGCOLOR=#CCCCCC >");
		  pw.println("<tr><td><center>");
		  pw.println("<table BORDER=0 COLS=2 WIDTH=100% BGCOLOR=#B080FF NOSAVE >");
		  pw.println("<tr NOSAVE>");
		  pw.println("<td NOSAVE>");
		  pw.println("<center><font color=#000000> Table Name </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Field Name </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Field Value </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Priority  </font></center>");
		  pw.println("</td>");
		  pw.println("</tr>");

		  pw.println("<tr>");
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=tablename size=20 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=fieldname size=20 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=fieldvalue size=20 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=priority size=20 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("</tr>");
		  pw.println("</table>");
		  pw.println("</center>");
		  
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table></center>");
		  pw.println("<HR>");
	 }
	 
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  htag.header(pw);
		  pw.println("<B> Received </B><BR>");
		  
		  String editdelnew = request.getParameterValues("editdel")[0];
		  String actype = editdelnew.substring(0,3);
		  
		  pw.println("<B>" + editdelnew + "</B><BR>");
		  pw.println("<B>" + actype + "</B><BR>");

		  String tablename  = request.getParameterValues("tablename")[0];
		  String fieldname  = request.getParameterValues("fieldname")[0];
		  String fieldvalue = request.getParameterValues("fieldvalue")[0];
		  String priority   = request.getParameterValues("priority")[0];

		  if (actype.equals("new")) {
			   InsertintoTables(tablename,fieldname,fieldvalue,priority,pw);
		  } else {
			   String upstmt = "";
			   if (actype.equals("edi")) {
					pw.println(" Edit function <BR>");
					upstmt = "UPDATE priorities SET tablename='"+tablename.trim()
						 +"', fieldname='"+ fieldname.trim() +"', fieldvalue='"+fieldvalue.trim()
						 +"', priority='"+ priority.trim() +"' where indexval='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   } else {
					pw.println(" Del function <BR>");
					upstmt = "DELETE FROM priorities where indexval='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   }
		  }
		  
		  htag.footer(pw);
	 }

	 /**
	  * @param String tablename - Name of the table
	  * @param String fieldname - One of its fields
	  * @param String fieldvalue - the specific field value
	  * @param String priority - a numeric value assigned which lies between 1 and 10
	  * @param PrintWriter pw 
	  */
	 public void InsertintoTables(String tablename, String fieldname, String fieldvalue, String priority, PrintWriter pw) {
		  String instmt = "";
		  boolean anynullval = true; 
		  
		  if (tablename.equals("") || tablename.equals(null)) anynullval = false;
		  if (fieldname.equals("") || fieldname.equals(null)) anynullval = false;
		  if (fieldvalue.equals("") || fieldvalue.equals(null)) anynullval = false;
		  if (priority.equals("") || priority.equals(null)) anynullval = false;

		  if (anynullval) {
			   String nooftuples[] = sfe.execQuery("SELECT COUNT(indexval) from priorities");
			   try {
			   int notuples = Integer.parseInt(nooftuples[1].trim());
			   notuples++;
			   pw.println("<font color=#ffffff> For Table Priorities :<br>"); 
			   instmt = "INSERT INTO priorities VALUES ('"+ notuples +"','" + tablename.trim() +"','" + fieldname.trim() +"','" 
					+ fieldvalue.trim() +"','"+ priority.trim() +"')"; 
			   pw.println(" values " + tablename + "&nbsp;  " + fieldname + "&nbsp;  " +fieldvalue + " has been inserted<Br>");
			   pw.println( sfe.InsertData(instmt) + "</font>" );
			   } catch (NumberFormatException nfe) { 
					pw.println("Number format exception ");
					pw.println("<BR> " + nooftuples[0] +"<BR>" + nooftuples[1]); 
					nfe.printStackTrace();
			   }
		  } else {
			   // do nothing
			   pw.println("<font color=#ffffff> No value has been inserted as a null input is given </font><br>"); 
		  }
	 }
}
