/*This class has functions which 
 * show the email in a proper format 
 * allow to reply to a email 
 */

/** @author Rajendra Sansare, Amitabh Saikia */

import java.io.PrintWriter;
import java.io.IOException;
import java.lang.Integer;
import javax.servlet.*;
import javax.servlet.http.*;

public class ShowEmailServlet extends HttpServlet implements SingleThreadModel {

	 private SQLEngine sfe;
	 private HTMLtags htag;
	 private   String[] message_id; // message_id 
	 private   String[] from_name; // from_name
	 private   String[] from_emailid; // from_emailid
	 private   String[] replyto_name; // from_name
	 private   String[] replyto_emailid; // from_emailid
	 private   String[] emaildate; // emaildate
 	 private   String[] time; // time
	 private   String[] subject; // subject

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  
		  sfe = new SQLEngine();
		  htag = new HTMLtags();
		  //selectEmails("");
		  selectEmails(", Email_Status WHERE customeremail.message_id = email_status.message_id" +
		               "  and email_status.reply_posted ='false'");
	 }
		  
	 /**
	  * @param String condition condition on whose basis the emails from the INBOX
	  * are selected
	  */
	 public void selectEmails(String condition) {
		  message_id      = sfe.execQuery("SELECT  CustomerEmail.message_id FROM CustomerEmail " + condition);
		  from_name       = sfe.execQuery("SELECT  CustomerEmail.from_name FROM CustomerEmail " + condition);
		  from_emailid    = sfe.execQuery("SELECT  CustomerEmail.from_emailid FROM CustomerEmail " + condition);
		  replyto_name    = sfe.execQuery("SELECT  CustomerEmail.replyto_name FROM CustomerEmail " + condition);
		  replyto_emailid = sfe.execQuery("SELECT  CustomerEmail.replyto_emailid FROM CustomerEmail " + condition);
		  emaildate       = sfe.execQuery("SELECT  CustomerEmail.emaildate FROM CustomerEmail " + condition);
		  time            = sfe.execQuery("SELECT  CustomerEmail.time FROM CustomerEmail " + condition);
		  subject         = sfe.execQuery("SELECT  CustomerEmail.subject FROM CustomerEmail " + condition);
	 }

	 
	 /** Shows select headers of the email */
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");

		  PrintWriter pw = response.getWriter();

		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ShowEmailServlet"; /* name of the servlet */

		  htag.header(pw);
		  //pw.println("Length " + from_name.length + "<BR>");
		  if (message_id.length == 1) {
			   pw.println("<center>");
			   pw.println("<B> There are No E-mail's for YOU right now </B>");
			   pw.println("</center>");
		  } else {
		  
		  pw.println("<CENTER>");
		  pw.println("<TABLE border=0 cellspacing=2>");
		  pw.println("<TR><TD nowrap bgcolor=cccccc>");
		  
		  pw.println("<TABLE border=0 cellspacing=2 cellpadding=2>");
		  /* table Column  names */
		  pw.println("<TR><FONT color=#000000><TD nowrap bgcolor=B080FF>"  + from_name[0] + 
					 "</TD><TD nowrap bgcolor=B080FF>" + emaildate[0] + 
					 "</TD><TD nowrap bgcolor=B080FF>" + time[0] + 
					 "</TD><TD nowrap bgcolor=B080FF>" + subject[0] + 
					 "</TD></FONT></TR>");
		  
		  for (int i = 1 ; i < from_name.length; i++) {
		  pw.println("<TR text=#FF0000><TD nowrap bgcolor=FFFFFF >" + from_name[i] + "</TD><TD nowrap bgcolor=FFFFFF>" 
					            + emaildate[i] + "</TD><TD nowrap bgcolor=FFFFFF>" 
					            + time[i] + "</TD><TD nowrap bgcolor=FFFFFF>"
								+ "<A HREF=" + actionurl +"?message_id="+ i +">" + subject[i] + "</a>" 
								+ "</TD></TR>");
		  }
		  pw.println("</TABLE>");

		  pw.println("</TD></TR>");
		  pw.println("</TABLE>");
		  pw.println("</CENTER>");
		  }
		  htag.footer(pw);
	 }
	 

	 
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");

		  PrintWriter pw = response.getWriter();
		  String[] messageid = request.getParameterValues("message_id");
		  int index = Integer.parseInt(messageid[0]);
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ReplyEmail";
		  //actionurl += "~amitabh/servlet/ReplyEmailServlet"; /* name of the servlet */
		  //actionurl += "8028~amitabh/servlet/ReplyForm"; /* name of the servlet */
		  
		  try {
		  htag.header(pw);
		  
		  pw.println("<CENTER>");
		  pw.println("<FORM action=" + actionurl + " method=get>"); 
		  pw.println("<input type=hidden name=message_id value="+ message_id[index] +"><BR>");
		  pw.println("<input type=hidden name=replyname value=\""+ replyto_name[index] +"\"><BR>");
		  pw.println("<input type=hidden name=replyemailid value="+ replyto_emailid[index] +"><BR>");
		  pw.println("<input type=hidden name=datetime value=\""+ emaildate[index] +"\"><BR>");
		  pw.println("<input type=hidden name=subject value=\""+ subject[index] +"\"><BR>");
		  pw.println("<TABLE border=0 cellspacing=2 cellpadding=2>");

		  
		  pw.println("<TR><TD nowrap bgcolor=cccccc>");
		  
		  
		  pw.println("<TABLE border=0 cellspacing=2 cellpadding=2>");
		  pw.println("<TR><TD nowrap bgcolor=B080FF>");
		  pw.println("<B>From :</B></TD><TD>" + 
					from_name[index] + "&nbsp;&nbsp;<" + from_emailid[index] + ">" 
					+ "</TD></TR>");
		  
		  pw.println("<TR><TD nowrap bgcolor=B080FF>");
		  pw.println("<B>Reply-To :</B></TD><TD>" + 
					replyto_name[index] + "&nbsp;&nbsp;<" + replyto_emailid[index] + ">" 
					+ "</TD></TR>");
		  
		  pw.println("<TR><TD nowrap bgcolor=B080FF>");
		  pw.println("<B>Subject :</B></TD><TD>" + 
					subject[index]   	
					+ "</TD></TR>");
		  
		  pw.println("<TR><TD nowrap bgcolor=B080FF>");
		  pw.println("<B>Date :</B></TD><TD>" + 
					emaildate[index] + "\t" +  time[index] 
					+ "</TD></TR>");
		  
		  pw.println("</TABLE>");
		  
		  pw.println("</TD></TR>");
		  
		  pw.println("<TR><TD bgcolor=FFFFFF>");
		  //
		  pw.println("<BR> Message-id index : " + index + "<BR>");
		  pw.println("<BR><PRE><font size=0>" + 
					sfe.execQuery("SELECT CustomerEmail.body FROM CustomerEmail WHERE message_id='" + message_id[index].trim() +"'")[1] 
					+"</font></PRE><BR>");
		  
		  pw.println("</TD></TR>");
		  pw.println("<TR><TD bgcolor=#000077>");
		  pw.println("<FONT COLOR=#FFFFFF>");
		  pw.println("<CENTER>");
		  pw.println("<input type=submit name=Reply      value=Reply>");
		  pw.println("<input type=submit name=Replytoall value=ReplyToAll>");
		  pw.println("<input type=submit name=Forward    value=Forward>");
		  pw.println("</FORM>");
		  pw.println("</CENTER>");
		  pw.println("</FORM>");
		  pw.println("</TD></TR>");

		  pw.println("</TABLE>");
		  pw.println("</CENTER>");
		  
		  htag.footer(pw);
		  } catch (ArrayIndexOutOfBoundsException aie) {
			   pw.println("<B> A problem occured will fetching the email content .Please try again later.</B>");
			   pw.println("</BODY></HTML>");
			   aie.printStackTrace();
		  }
	 }
}
