create table Person(
       email varchar(100),
	   Name varchar(50) not null ,
	   FirstLine varchar(100) not null,
	   City varchar(20) not null,
	   State varchar(20) not null,
	   Country varchar(20) not null,
	   Phone varchar(20) not null,
	   Fax varchar(20) not null,
	   primary key (email));
	   
create table Reviewer ( email varchar(100) primary key,
                        field varchar(100) not null,
						password varchar(10) not null,
						foreign key(email) references Person);

create table Message ( mesgId integer primary key,
                       content varchar(3000),
					   paperId integer not null,
					   postedBy varchar(100) not null,
					   postingDate date not null);

create table NewMessage ( mesgId integer,
                          ID varchar(100),
						  primary key(mesgId, ID), 
						  foreign key(mesgId) references Message);
						  

create table MailingList ( listId varchar(5),
                           email varchar(100),
						   primary key(listId,email) );
						   
create table Admin ( email varchar(100) primary key,
                     password varchar(10), 
					 foreign key(email) references Person );

create table Participant ( email varchar(100) primary key,
                           affiliation varchar(50) not null,
                           nameOnTag varchar(50),
						   affiliationOnTag varchar(50),
						   institutionOnTag varchar(50),
						   specialneeds varchar(100),
						   foreign key(email) references Person);

create table Program ( programId integer,
                       name varchar(100) not null,
					   affiliation varchar(50) not null,
					   charge number(8,2) not null,
					   primary key (programId, affiliation));

create table Hotel ( hotel varchar(30),
                     roomType varchar(30),
					 charge number(8,2) not null,
					 primary key(hotel,roomType) );

create table Event ( eventId integer primary key,
                     name varchar(500) not null,
					 charge number(8,2) not null);

create table Bookings ( email varchar(100),
                        hotel varchar(30),
						checkInDate date,
						checkOutDate date,
						roomType varchar(30),
						primary key(email,hotel),
						foreign key(email) references Participant,
						foreign key(hotel,roomType) references Hotel );

create table Participation ( programID integer,
                             affiliation varchar(50),
                             email varchar(100),
						     primary key(programId,email),
							 foreign key(programId,affiliation) references Program,
						     foreign key(email) references Participant );



create table EventParticipation ( eventID integer,
                                  email varchar(100),
								  primary key(eventId,email),
								  foreign key(eventId) references Event,
								  foreign key(email) references Participant );

create table Author(
       email varchar(100),
	   Name varchar(50) not null,
	   primary key (email));

create table Paper(
       PaperID integer,
	   Title varchar(200) not null,
	   Category varchar(30),
	   Abstract varchar(3000),
	   Extn varchar(10),
	   Password varchar(10),
	   primary key(PaperID));

create table AuthoredBy(
       PaperID integer not null,
	   email varchar(100) not null,
	   isContact integer not null,
	   Rank integer,
	   primary key(PaperID, email),
	   foreign key(PaperID) references Paper,
	   foreign key (email) references Author);
	   

create table Payment (
       email varchar(100),
	   Amount number (8,2),
	   madePayment integer not null,
	   PaymentMode varchar(20),
	   Currency varchar(20),
	   primary key (email),
	   foreign key (email) references Person);

create table CreditCardPayment (
       email varchar (100),
	   CreditCardNo varchar (18) not null,
	   ExpiryDate date not null,
	   Type varchar (20) not null,
	   primary key (email),
	   foreign key (email) references Person);

create table ChequePayment (
       email varchar (100),
	   ChequeNo integer not null,
	   chequeBank varchar (100) not null,
	   IssueDate date not null,
	   primary key (email),
	   foreign key (email) references Person);	   

create table DemandDraftPayment (
       email varchar (100),
	   DDNo integer not null,
	   DDBank varchar (100) not null,
	   primary key (email),
	   foreign key (email) references Person);	   

create table AcceptedPaper (
       paperId integer primary key,
	   extn2 varchar(10) );

create table Review ( PaperId integer references Paper ,
							 email varchar(100) references Reviewer,
							 CommentsToPCExtn varchar(10),
							 CommentsToAuthorExtn varchar(10),
							 SummaryExtn varchar(10),
							 Contribution integer,
							 Relevance integer,
							 Significance integer,
							 Originality integer,
							 Readability integer,
							 Familiarity integer,
							 check(Contribution>-1 and Contribution <11
							 	    and Relevance>-1 and Relevance<11
							 	    and Significance>-1 and Significance<11
							 	    and Originality>-1 and Originality<11
							 	    and Readability>-1 and Readability<11
							 	    and Familiarity>-1 and Familiarity<11),
							 primary key(PaperId, email));

create table Clash      ( PaperId integer references Paper,
						  StdDeviation number(6,5),
						  primary key(PaperId) );

create table FinalAssignments        ( PaperId integer references Paper,
									  email varchar(100) references Reviewer,
									  primary key(PaperId, email));
									 
									  
create table tentativeassignments    ( paperid integer references paper,
									  email varchar(100) references reviewer,
									  primary key(paperid, email));
									
create table Bids   ( PaperId integer references Paper,
					  email varchar(100) references Reviewer,
					  BidValue integer,
					  check(BidValue>=-2 and BidValue<=2),
					  primary key(PaperId, email));

create table flag(val integer primary key);
insert into flag values(0);

create table deadline( val integer primarykey,
                       dline date not null);

create table Weightage(Attribute varchar(20) primary key,
                       weightage integer );
