import java.io.*;
import java.lang.*;
import java.util.*;
import java.sql.*;

/**
 * This java file is executed when the admin initially configures the system.
 * This is done thro' the makefile itself.  This program asks him to enter
 * certain parameters required for the conference (like the host name for 
 * servlets, port no, some deadlines etc) and makes Config.java file.
 * Other servlet files read these parameters from Config.java file.
 */

public class Configure 
{
  	public static void main(String[] args) throws IOException
	{
	  	//configFile is the file into which the things are to be written.
  	        String configFile = "./src/util/Config.java";
	  	FileWriter fw = new FileWriter(configFile);
		PrintWriter out = new PrintWriter(fw);
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String answer;
		String staticStr = "public static final ";
		out.println("package util;");
		out.println("import java.util.*;");
		out.println("public class Config { ");
		try{
		  	System.out.println("Enter your email id (this is to be used as the id for your login): ");
			String adminId = removeBlank(br.readLine());
			System.out.println("Enter your password: ");
			String password = removeBlank(br.readLine());
			
			System.out.println("Enter the host name for the servlets: ");
			answer = removeBlank(br.readLine());
			String host = answer;
			out.println(printLine("String","_HOST", answer));
			
			System.out.println("Enter the port number to be used for servlets: ");
			answer = removeBlank(br.readLine());
			String port = answer;
			out.println(printLine("int","_PORT",answer));
			
			System.out.println("Enter the SMTP host (default is the servlet host itself): ");
			answer = removeBlank(br.readLine());
			if (answer.equals(""))
			  	answer = host;
			out.println(printLine("String","_SMTP_HOST",answer));
			
			System.out.println("Enter the SMTP port (default is 25): ");
			answer = removeBlank(br.readLine());
			if (answer.equals(""))
			  	answer = "25";
			out.println(printLine("int","_SMTP_PORT",answer));
			int driverFlag = 0;
			String driverType="", connectionStr="";
			
			//this while loop checks whether the driver type and connection string that
			//he enters are correct by opening a connection.
			//If it is wrong, then it asks the user to enter the values again.
			Connection con = null;
			while(driverFlag == 0)
			{
			      System.out.println("Enter the driver type of the database (default is oracle.jdbc.driver.OracleDriver) : ");
			      answer = removeBlank(br.readLine());
			      if (answer.equals(""))
			    	   answer = "oracle.jdbc.driver.OracleDriver";
			      driverType = answer;
			
			      System.out.println("Enter the connection string for the database (default is jdbc:oracle:thin:@:1521:GEN : ");
			      answer = removeBlank(br.readLine());
			      if (answer.equals(""))
			  	   answer = "jdbc:oracle:thin:@:1521:GEN";
			      connectionStr = answer;
			      
			      System.out.println("Enter the database username : ");
			      answer = removeBlank(br.readLine());
			      out.println(printLine("String","_USERID",answer));
			      String username = answer;
			
			      System.out.println("Enter the database password : ");
			      answer = br.readLine();
			      out.println(printLine("String","_PASSWD",answer));
			      String passwd = answer;
			      driverFlag = 1;
			      try
			      {
				      Class.forName(driverType);
			      }
			      catch(ClassNotFoundException c)
			      {
				      System.out.println("There is something wrong with your driver type.  Please enter again.");
				      driverFlag = 0;
			      }
			      
			      try
			      {
				      con = DriverManager.getConnection(connectionStr, username, passwd);
			      }
			      catch(SQLException sqle)
			      {
				      if (driverFlag != 0)
					   System.out.println("There is something wrong with your driver type or connection string or login.  Please enter again.");
				      driverFlag=0;
			      }
			}
			System.out.println("Making all the tables in the database.....");
			makeTables(con);
			System.out.println("Done");

			Statement st=null;
			try
			{
			  	st = con.createStatement();
				st.executeUpdate("insert into person values('"+adminId+"','0','0','0','0','0','0','0')");
				st.executeUpdate("insert into admin values('"+adminId+"','"+password+"')");
			}
			catch(SQLException sqle)
			{
			  	System.out.println(sqle);
				System.out.println("Could not insert into admin table");
			}
			
			out.println(printLine("String","_DRIVERTYPE",driverType));
			out.println(printLine("String","_CONNECTIONSTRING",connectionStr));
			//Store the db admin and password in the data base here.
			System.out.println("Enter the directory where the papers would be stored :");
			answer = removeBlank(br.readLine());
			out.println(printLine("String","_FILE_REPOSITORY",slashEnd(answer)));
			
			System.out.println("Enter the directory where all the html files would be stored :");
			answer = removeBlank(br.readLine());
			out.println(printLine("String","_HTML_REPOSITORY",slashEnd(answer)));

			System.out.println("Enter the directory where the reviews would be stored :");
			answer = removeBlank(br.readLine());
			out.println(printLine("String","_REVIEW_REPOSITORY",slashEnd(answer)));

			System.out.println("Enter the url root where the html files reside :");
			answer = removeBlank(br.readLine());
			out.println(printLine("String","_HTMLROOT",slashEnd(answer)));

			out.println(printLine("String","_MAIL_ID",adminId));

			System.out.println("Enter the max no of authors to be allowed for a paper :");
			answer = removeBlank(br.readLine());
			out.println(printLine("int","_NO_OF_AUTHORS",answer));

			out.println(printLine("int","_MAX_REVIEW_SIZE","5*1024*1024"));

			System.out.println("Enter the scale on which a reviewer can rate a paper (default is 10) :");
			answer = removeBlank(br.readLine());
			if(answer.equals(""))
			  	answer = "10";
			out.println(printLine("int","_REVIEW_SCALE",answer));

			int dateFlag = 0;
			while(dateFlag == 0)
			{
			  	System.out.println("Enter the deadline for paper submission (dd-mm-yyyy) :");
				answer = removeBlank(br.readLine());
				if (!convertDate(answer).equals(""))
				{
				      try
				      {
					     st = con.createStatement();
					     st.executeUpdate("insert into DEADLINE values('0',to_date('"+answer+"','dd-mm-yyyy'))");
					     dateFlag = 1;
				      }
				      catch(SQLException sqle)
				      {System.out.println("Could not enter Paper submission in the database");}
				}
				else System.out.println("You have entered wrong date. Please do again.");
			}
			
			dateFlag = 0;
			while(dateFlag == 0)
			{
			  	System.out.println("Enter the deadline for participant registration (dd-mm-yyyy) :");
				answer = removeBlank(br.readLine());
				if (!convertDate(answer).equals(""))
				{
				      try
				      {
					     st = con.createStatement();
					     st.executeUpdate("insert into DEADLINE values('1',to_date('"+answer+"','dd-mm-yyyy'))");
					     dateFlag = 1;
				      }
				      catch(SQLException sqle)
				      {System.out.println("Could not enter participation submission in the database");}
				}
				else System.out.println("You have entered wrong date. Please do again.");
			}

			System.out.println("Enter the blindness constant (0 for single blindness, 1 for double blindness)");
			answer = removeBlank(br.readLine());
			if(answer.equals(""))
			  	answer = "0";
			out.println(printLine("int","_BLINDNESS",answer));

			System.out.println("Enter the max no. of reviews per paper :");
			answer = removeBlank(br.readLine());
			out.println(printLine("int","_REVIEWS_PER_PAPER",answer));

		}
		catch(IOException ioe)
		{System.out.println(ioe);}
		out.println("}");
		out.close();
	}

	//finds whether the ith variable (defined above) is a string or not.
	private static String printLine(String type, String name, String value)
	{
	  	if(removeBlank(type).equals("String"))
		  	return("\tpublic static final "+ type + " " + name + " = \"" + value + "\";");
		else 
		  	return("\tpublic static final "+ type + " " + name + " = " + value + ";");
	}
	
	private static void makeTables(Connection con)
	{
	  	Statement st=null;
		try
		{
		    st = con.createStatement();
		}
		catch(SQLException sqle)
		{System.out.println("Could not make a statement out of connection.");}
	  	try
		{
		    st.executeUpdate("create table Person( email varchar(100), Name varchar(50) not null, FirstLine varchar(100) not null,  City varchar(20) not null, State varchar(20) not null, Country varchar(20) not null, Phone varchar(20) not null, Fax varchar(20) not null, primary key (email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Person.  So, please delete it before starting again.");}

	  	try
		{
		    st.executeUpdate("create table Reviewer ( email varchar(100) primary key, field varchar(100) not null, password varchar(10) not null, foreign key(email) references Person)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Reviewer.  So, please delete it before starting again.");}
		
	  	try
		{
		     st.executeUpdate("create table Message ( mesgId integer primary key, content varchar(3000), paperId integer not null, postedBy varchar(100) not null, postingDate date not null)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Message.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table NewMessage ( mesgId integer, ID varchar(100), primary key(mesgId, ID),  foreign key(mesgId) references Message)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table NewMessage.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table MailingList ( listId varchar(5), email varchar(100), primary key(listId,email) )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table MailingList.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table Admin ( email varchar(100) primary key, password varchar(10),  foreign key(email) references Person )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Admin.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Participant ( email varchar(100) primary key, affiliation varchar(50) not null, nameOnTag varchar(50), affiliationOnTag varchar(50), institutionOnTag varchar(50), specialneeds varchar(100), foreign key(email) references Person)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Participant.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Program ( programId integer, name varchar(100) not null, affiliation varchar(50) not null, charge number(8,2) not null, primary key (programId, affiliation))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Program.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Hotel ( hotel varchar(30), roomType varchar(30), charge number(8,2) not null, primary key(hotel,roomType))"); 
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Hotel.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Event ( eventId integer primary key, name varchar(500) not null, charge number(8,2) not null)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Event.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Bookings ( email varchar(100), hotel varchar(30), checkInDate date, checkOutDate date, roomType varchar(30), primary key(email,hotel), foreign key(email) references Participant, foreign key(hotel,roomType) references Hotel )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Bookings.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Participation ( programID integer, affiliation varchar(50), email varchar(100), primary key(programId,email), foreign key(programId,affiliation) references Program, foreign key(email) references Participant )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Participation.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table EventParticipation ( eventID integer, email varchar(100), primary key(eventId,email), foreign key(eventId) references Event, foreign key(email) references Participant )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table EventParticipation.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Author( email varchar(100), Name varchar(50) not null, primary key (email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Author.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Paper( PaperID integer, Title varchar(200) not null, Category varchar(30), Abstract varchar(3000), Extn varchar(10), Password varchar(10), primary key(PaperID))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Paper.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table AuthoredBy( PaperID integer not null, email varchar(100) not null, isContact integer not null, Rank integer, primary key(PaperID, email), foreign key(PaperID) references Paper, foreign key (email) references Author)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table AuthoredBy.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Payment (email varchar(100), Amount number (8,2), madePayment integer not null, PaymentMode varchar(20), Currency varchar(20), primary key (email), foreign key (email) references Person)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Payment.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table CreditCardPayment ( email varchar (100), CreditCardNo varchar (18) not null, ExpiryDate date not null, Type varchar (20) not null, primary key (email), foreign key (email) references Person)"); 
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table CreditCardPayment.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table ChequePayment ( email varchar (100), ChequeNo integer not null, chequeBank varchar (100) not null, IssueDate date not null, primary key (email), foreign key (email) references Person)");  
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table ChequePayment.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table DemandDraftPayment ( email varchar (100), DDNo integer not null, DDBank varchar (100) not null, primary key (email), foreign key (email) references Person)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table DemandDraftPayment.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table AcceptedPaper ( paperId integer primary key, extn2 varchar(10) )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table AcceptedPaper.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Review ( PaperId integer references Paper , email varchar(100) references Reviewer, CommentsToPCExtn varchar(100), CommentsToAuthorExtn varchar(100), SummaryExtn varchar(100), Contribution integer, Relevance integer, Significance integer, Originality integer, Readability integer, Familiarity integer, check(Contribution>-1 and Contribution <11 and Relevance>-1 and Relevance<11	and Significance>-1 and Significance<11 and Originality>-1 and Originality<11 and Readability>-1 and Readability<11 and Familiarity>-1 and Familiarity<11), primary key(PaperId, email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Review.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table Clash      ( PaperId integer references Paper, StdDeviation number(6,5), primary key(PaperId) )");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Clash.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table FinalAssignments        ( PaperId integer references Paper, email varchar(100) references Reviewer, primary key(PaperId, email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table FinalAssignments.  So, please delete it before starting again.");}
			
	  	try
		{
		     st.executeUpdate("create table tentativeassignments    ( paperid integer references paper, email varchar(100) references reviewer, primary key(paperid, email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table TentativeAssignments.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table Bids( PaperId integer references Paper, email varchar(100) references Reviewer, BidValue integer, check(BidValue>=-2 and BidValue<=2), primary key(PaperId, email))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Bids.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("create table flag(val integer)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Flag.  So, please delete it before starting again.");}
			
	  	try
		{
		    st.executeUpdate("insert into flag values(0)");
		}
		catch(SQLException sqle)
		{}
			
	  	try
		{
		    st.executeUpdate("create table Weightage(attribute varchar(20) primary key, weightage integer)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table Weightage.  So, please delete it before starting again.");}
	  	
		try
		{
		    st.executeUpdate("create table deadline(val integer, dline date)");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table DeadLine.  So, please delete it before starting again.");}
		
		try
		{
		    st.executeUpdate("create table KeyWords(PaperId integer references Paper, keyword varchar(100))");
		}
		catch(SQLException sqle)
		{System.out.println("There is already a table KeyWords.  So, please delete it before starting again.");}
	}

	private static String removeBlank(String str) //removes the leading and trailing blank in the string str.
	{
	  	char[] resultArr1 = new char[200];
		int j = 0;
		if (str == null)
		     return("");
		for(int i=0; i < str.length(); i++)
		{
		      if(str.charAt(i) != ' ') {
			     resultArr1[j] = str.charAt(i); 
			     j++;
		      }
		}
		char[] resultArr2 = new char[j];
		if(j==0)
		      return("");
		for(int i=0; i<j; i++)
		      resultArr2[i] = resultArr1[i];	
		return(new String(resultArr2));
	}

	private static String slashEnd(String str)
	{
	  	int len = str.length();
		if(str.charAt(len-1) != '/')
		   	return(str + "/");
		else return(str);
	}

	private static String convertDate(String str)
	{
	  	StringTokenizer st = new StringTokenizer(str,"-");
		int date,month,year;
		try
		{
		      try
		      {
			  date = Integer.parseInt(st.nextToken());
		          month = Integer.parseInt(st.nextToken());
		          year = Integer.parseInt(st.nextToken());
		      }
		      catch(NoSuchElementException ne)
		      {return("");}
		}
		catch(NumberFormatException nf)
		{ return("");}
		if ((date > 31) || (month > 12) || (year < 1900))
		  	return("");
		else
			return("(" + (year - 1900) + "," + (month - 1) + "," + date + ")");
	}
}
