import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.*;
import java.sql.*;

import util.*;

/**
 * This file is executed when the admin initially configures the system.
 * This basically generates all the html files required taking into 
 * consideration the hostname and the port no that he has entered and puts 
 * them in the directory of his choice.
 */

public class GenerateHtml {
  	public static void main(String[] args)
	{
		File htmlDir=new File(Config._HTML_REPOSITORY);
		if (!htmlDir.exists()) {
			 htmlDir.mkdirs();
		}
	  	makeLogin();		//This makes the file Login.html
		makeForgotPsw();	//forgotpsw.html
		makeChRevPsw();		//chrevpsw.html
		makeAdminInfo();	//admininfo.html
		makeQueryPage();	//QueryPage.html
		makePaperReg();		//PaperReg.html
		makeReupload();		//Re-Upload.html
		makeRevInfo();		//revinfo.html
		makeEventInit();	//EventInit.html
		makeAppletFiles();		//Makes the Config.class in the html repository.
		makeStyle();
		makeRevParameters();
	}


   	private static void makeRevParameters()
		{
			try {

				FileWriter fw=new FileWriter(Config._HTML_REPOSITORY+"TakeRevParam.html");
				PrintWriter out=new PrintWriter(fw);
				
				out.println("<html><head><title>Take Review Parameters</title>");
				out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"Style.css\">");
				out.println("</head> ");
				out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
				out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
				out.println("<tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
				out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td><td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
				out.println("");
				out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr valign=top><td width=150 bgcolor=#000080>");
				out.println("<table width=150 border=0 cellspacing=0 cellpadding=0><tr><td width=150 colspan=3></td></tr><tr><td width=150 colspan=3></td></tr></table><br>");
				out.println("<td width=610>");
				out.println("");
				out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%><TR><TD width=8>&nbsp;</TD></tr>");
				out.println("<TR><TD width=10> &nbsp; </td> <TD><font class=TITLEFONT size=5 color=000080><b>Review Parameters</b></font><p>");
	         out.println("<font size=2 class=TDFONT><p>Please fill in the details below and submit the form.");
				out.println("");
				out.println("<p>All fields are required.</font><br><p><hr>");
				out.println("<p> A paper is evaluated according to following parameters.</font><br><p><hr>");
				
				out.println("<form name=\"GetRevParam\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/TakeRevParam\">");
				out.println("</td></tr>");
				
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Relevance:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"relevance\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
         	
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Significance:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"significance\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
         	
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Originality:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"originality\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
           
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Readability:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"readability\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
				
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Familiarity:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"familiarity\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");

				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Contribution:</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"contribution\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
				
				out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Maximum allowed Standard Deviation amongst marks awarded by reviewers. All above parameters are evaluated at scale of "+Config._REVIEW_SCALE+". A standard deviation more than this will be highlighted as a clash! :</b></td>");
				out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				out.println("<input type=\"text\" name=\"maxstddev\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		out.println("<tr><td><input type=\"submit\" name=\"go\" value=\"Submit\"> </td></tr></center></form>");
				out.println("</td></tr><tr></table></table> <table width=760> <tr bgcolor=#000000><td width=760>&nbsp</td><tr></table>");
				out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
				out.println("</font></body></html>");
				out.close();
			}
			catch(IOException ioe)
			{ 
				System.out.println("Can't write onto file");
			}
		}






	
	private static void makeLogin()
	{
	  	FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
	  	     fw = new FileWriter(Config._HTML_REPOSITORY+"Login.html");
		     out = new PrintWriter(fw);

		     out.println("<html><head><title>Login</title>");
		     out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=http://"+Config._HTMLROOT+"Style.css>");
		     out.println("</head>");
		     out.println("");
		     out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
		     out.println("<td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr>");
		     out.println("");
		     out.println("</table>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("<tr valign=top>");
		     out.println("<td width=150 bgcolor=#000080>");
		     out.println("<table width=150 border=0 cellspacing=0 cellpadding=0>");
		     out.println("<tr><td width=150 colspan=3></td></tr>");
		     out.println("<tr><td width=150 colspan=3></td></tr>");
		     out.println("</table><br>");
		     out.println("");
		     out.println("");
		     out.println("<form method=\"post\" action=http://"+Config._HOST+":"+Config._PORT+"/servlet/LoginServlet>");
		     out.println("");
		     out.println("<td width=610>");
		     out.println("");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("<TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("<TR><TD width=10> &nbsp; </td> ");
		     out.println("<TD><font class=TITLEFONT size=4 color=000080><b>Welcome Dear User </b></font><p><br></td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td><font class=TDFONT size=2>Please enter your login name and password to log into the system.</font>   ");
		     out.println("		</td></tr>");
		     out.println("</table>	");
		     out.println("<p>  ");
		     out.println("");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td width=60><font size=2 class=TDFONT><b>USERID</b></font></td>");
		     out.println("	   <td width=70> ");
		     out.println("	       <font class=TDFONT size=\"1\">");
		     out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"userId\"></td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td width=60><font size=2 class=TDFONT><b>PASSWORD</b></font></td>");
		     out.println("	   <td width=70> ");
		     out.println("	       <font class=TDFONT size=\"1\">");
		     out.println("		         <input type=\"password\" size=\"30\" maxlength=10 name=\"passwd\"></td></tr>");
		     out.println("</table><p>");
		     out.println("");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("<TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td><font class=TDFONT size=\"2\">Please indicate the capacity in which you want to log into ");
		     out.println("the system.</font></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=60%>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td width=40><font class=TDFONT size=2><b> ADMINISTRATOR</b></font></td>");
		     out.println("<td> <input type=\"radio\" value=\"Admin\" name=\"whoami\"CHECKED> </td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td width=40><font class=TDFONT size=2><b> REVIEWER </b></font></td>");
		     out.println("<td> <input type=\"radio\" value=\"Reviewer\" name=\"whoami\"> </td></tr>");
		     out.println("");
		     out.println("<tr><td width=10>&nbsp;</td>");
		     out.println("<td width=40><font class=TDFONT size=2><b> AUTHOR </b></font></td>");
		     out.println("<td><input type=\"radio\" value=\"Author\" name=\"whoami\"></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<br>");
		     out.println("<p>");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td><input type=\"submit\" value=\"Login\"></td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td>&nbsp;</td></tr>");
		     out.println("");
		     out.println("");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td>&nbsp;</td></tr>");
		     out.println("");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td><a href=http://"+Config._HTMLROOT+"ParticipantRegistration.html><font size=3 class=TITLEFONT>CALL FOR PARTICIPATION</font></a>");
		     out.println("</td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td><a href=http://"+Config._HTMLROOT+"PaperReg.html><font size=3 class=TITLEFONT>CALL FOR PAPERS</font></a>");
		     out.println("</td></tr>");
		     out.println("");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("<td><a href=http://"+Config._HTMLROOT+"forgotpsw.html><font size=3 class=TITLEFONT>Forgot Your Password </font></a>");
		     out.println("</td></tr>");
		     out.println("");
		     out.println("");
		     out.println("");
		     out.println("");
		     out.println("");
		     out.println("<tr><td>");
		     out.println("");
		     out.println("<br><br><br><br><br><br><br>");
		     out.println("</td></tr>");
		     out.println("</table>");
		     out.println("</td>");
		     out.println("</table> ");
		     out.println("");
		     out.println("<table width=760> ");
		     out.println("<tr bgcolor=#000000><td width=760>&nbsp;</td></tr>");
		     out.println("</table>");
		     out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		     out.println("</font>");
		     out.println("</body>");
		     out.println("</html>");
		}
		catch(IOException io)
		{System.out.println(io);}
		out.close();
	}

	private static void makeForgotPsw()
	{
	  	FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
	  	     fw = new FileWriter(Config._HTML_REPOSITORY+"forgotpsw.html");
		     out = new PrintWriter(fw);
		     		     
		     out.println("<html><head><title>Forgot Password?</title>");
		     out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"http://"+Config._HTMLROOT+"Style.css\">");
		     out.println("</head> ");
		     out.println("");
		     out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
		     out.println("    <td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr>");
		     out.println("");
		     out.println("</table>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("<tr valign=top>");
		     out.println("<td width=150 bgcolor=#000080>");
		     out.println("  <table width=150 border=0 cellspacing=0 cellpadding=0>");
		     out.println("  <tr><td width=150 colspan=3></td></tr>");
		     out.println("  <tr><td width=150 colspan=3></td></tr>");
		     out.println("  </table><br>");
		     out.println("");
		     out.println("");
		     out.println("<form method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailPassword\">");
		     out.println("");
		     out.println("<td width=610>");
		     out.println(" ");
		     out.println("   <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("   <TR><TD width=10> &nbsp; </td> ");
		     out.println("      <TD><font class=TITLEFONT size=4 color=000080><b>Welcome Dear User </b></font><p><br></td></tr>");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("       <td><font class=TDFONT size=2>Please enter your login name.</font>   ");
		     out.println("		</td></tr>");
		     out.println("   </table>	");
		     out.println("<p>  ");
		     out.println("");
		     out.println("     <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("       <td width=60><font size=2 class=TDFONT><b>USERID</b></font></td>");
		     out.println("	   <td width=70> ");
		     out.println("	       <font class=TDFONT size=\"1\">");
		     out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"userId\"></td></tr>");
		     out.println("</table><p>");
		     out.println("");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("  <tr><td width=10>&nbsp;</td>");
		     out.println("      <td><font class=TDFONT size=\"2\">Please indicate the capacity in which you want to log into ");
		     out.println("	         the system.</font></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=60%>");
		     out.println("  <tr><td width=10>&nbsp;</td>");
		     out.println("     <td width=40><font class=TDFONT size=2><b> ADMINISTRATOR </b></font></td>");
		     out.println("    <td> <input type=\"radio\" value=\"Admin\" name=\"whoami\" CHECKED> </td></tr>");
		     out.println("  <tr><td width=10>&nbsp;</td>");
		     out.println("     <td width=40><font class=TDFONT size=2><b> REVIEWER </b></font></td>");
		     out.println("	 <td> <input type=\"radio\" value=\"Reviewer\" name=\"whoami\"> </td></tr>");
		     out.println("  ");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("     <td width=40><font class=TDFONT size=2><b> AUTHOR </b></font></td>");
		     out.println("	<td><input type=\"radio\" value=\"Author\" name=\"whoami\"></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<br>");
		     out.println("<p>");
		     out.println(" <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>");
		     out.println("   <tr><td width=10>&nbsp;</td> ");
		     out.println("   <td><input type=\"submit\" value=\"Mail\"></td></tr>");
		     out.println("<tr><td width=10>&nbsp;</td> ");
		     out.println("   <td>&nbsp;</td></tr>");
		     out.println("");
		     out.println("");
		     out.println("	<tr><td>");
		     out.println("");
		     out.println("          <br><br><br><br><br><br><br>");
		     out.println("          </td></tr>");
		     out.println("   </table>");
		     out.println("   </td>");
		     out.println("</table> ");
		     out.println("");
		     out.println("<table width=760> ");
		     out.println("<tr bgcolor=#000000><td width=760>&nbsp;</td></tr>");
		     out.println("</table>");
		     out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		     out.println("</font>");
		     out.println("</body>");
		     out.println("</html>");
		     out.println("");
		}
		catch(IOException io)
		{System.out.println(io);}
		out.close();
	}

	private static void makeChRevPsw()
	{
	  	FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
	  	     fw = new FileWriter(Config._HTML_REPOSITORY+"chrevpsw.html");
		     out = new PrintWriter(fw);

		     out.println("<html><head><title>Change Reviewer/Author Password</title>");
		     out.println("<link rel=\"Stylesheet\" href=\"Style.css\">");
		     out.println("<script language=\"javascript\">");
		     out.println("function isblank(s)");
		     out.println("{");
		     out.println("	 for(var i = 0; i < s.length; i++) {");
		     out.println("		  var c = s.charAt(i);");
		     out.println("		  if ((c != ' ') && (c != '\n') && (c != '\t')) return false;");
		     out.println("	 }");
		     out.println("	 return true;");
		     out.println("}");
		     out.println("function verify(f)");
		     out.println("{");
		     out.println("	 var msg;");
		     out.println("	 var empty_fields = \"\";");
		     out.println("	 var errors = \"\";");
		     out.println("	  for(var i = 0; i < f.length; i++) {");
		     out.println("		  var e = f.elements[i];");
		     out.println("		  if (((e.type == \"text\") || (e.type == \"textarea\")) && e.noptional) {");
		     out.println("			   if ((e.value == null) || (e.value == \"\") || isblank(e.value)) {");
		     out.println("					empty_fields += \"\n          \" + e.name;");
		     out.println("					continue;");
		     out.println("			   }");
		     out.println("		  }");
		     out.println("	 }");
		     out.println("	 if (!empty_fields && !errors) return true;");
		     out.println("	 msg  = \"______________________________________________________\n\n\"");
		     out.println("		  msg += \"The form was not submitted because of the following error(s).\n\";");
		     out.println("	 msg += \"Please correct these error(s) and re-submit.\n\";");
		     out.println("	 msg += \"______________________________________________________\n\n\"");
		     out.println("		  if (empty_fields) {");
		     out.println("			   msg += \"- The following required field(s) are empty:\" ");
		     out.println("					+ empty_fields + \"\n\";");
		     out.println("			   if (errors) msg += \"\n\";");
		     out.println("		  }");
		     out.println("	 msg += errors;");
		     out.println("	 alert(msg);");
		     out.println("	 return false;");
		     out.println("}");
		     out.println("</script>");
		     out.println("");
		     out.println("");
		     out.println("");
		     out.println("</head>");
		     out.println("");
		     out.println("");
		     out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr bgcolor=#000080>");
		     out.println("<td width=150>&nbsp;</td>");
		     out.println("<td width=610> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
		     out.println("    <td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr>");
		     out.println("");
		     out.println("</table>");
		     out.println("");
		     out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		     out.println("<tr valign=top>");
		     out.println("<td width=150 bgcolor=#000080>");
		     out.println("  <table width=150 border=0 cellspacing=0 cellpadding=0>");
		     out.println("  <tr><td width=150 colspan=3></td></tr>");
		     out.println("  <tr><td width=150 colspan=3></td></tr>");
		     out.println("  </table><br>");
		     out.println("");
		     out.println("");
		     out.println("");
		     out.println("<form method=\"post\" onSubmit=\"this.userId.noptional=true; return verify(this);\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">");
		     out.println("");
		     out.println("<td width=610>");
		     out.println(" ");
		     out.println("   <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("   <TR><TD width=10> &nbsp; </td> ");
		     out.println("      <TD><font class=TITLEFONT size=4 color=000080><b>Change Password</b></font><p><br></td></tr>");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("       <td><font class=TDFONT size=2>Please enter the login name and new password.</font>   ");
		     out.println("		</td></tr>");
		     out.println("   </table>	");
		     out.println("");
		     out.println("<p>  ");
		     out.println("");
		     out.println("     <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("       <td width=60><font size=2 class=TDFONT><b>USERID</b></font></td>");
		     out.println("	   <td width=70> ");
		     out.println("	       <font class=TDFONT size=\"1\">");
		     out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"userId\"></td></tr>");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("       <td width=60><font size=2 class=TDFONT><b>PASSWORD</b></font></td>");
		     out.println("	   <td width=70> ");
		     out.println("	       <font class=TDFONT size=\"1\">");
		     out.println("		         <input type=\"password\" size=\"30\" maxlength=10 name=\"pwd1\"></td></tr>");
		     out.println("</table><p>");
		     out.println("");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		     out.println("   <TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("  <tr><td width=10>&nbsp;</td>");
		     out.println("      <td><font class=TDFONT size=\"2\">Please indicate the group identifier.</font></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=60%>");
		     out.println("  <tr><td width=10>&nbsp;</td>");
		     out.println("     <td width=40><font class=TDFONT size=2><b> REVIEWER </b></font></td>");
		     out.println("	 <td> <input type=\"radio\" value=\"Reviewer\" name=\"whoami\" CHECKED> </td></tr>");
		     out.println("  ");
		     out.println("   <tr><td width=10>&nbsp;</td>");
		     out.println("     <td width=40><font class=TDFONT size=2><b> AUTHOR </b></font></td>");
		     out.println("	<td><input type=\"radio\" value=\"Author\" name=\"whoami\"></td></tr>");
		     out.println("</table>");
		     out.println("<p>");
		     out.println("<br>");
		     out.println("<p>");
		     out.println(" <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>");
		     out.println("   <tr><td width=10>&nbsp;</td> ");
		     out.println("   <td><input type=\"submit\" value=\"Login\"></td>");
		     out.println("   </tr>");
		     out.println("");
		     out.println("	<tr><td>");
		     out.println("");
		     out.println("          <br><br><br><br><br><br><br>");
		     out.println("          </td></tr>");
		     out.println("   </table>");
		     out.println("   </td>");
		     out.println("</table> ");
		     out.println("");
		     out.println("<table width=760> ");
		     out.println("<tr bgcolor=#000000><td width=760>&nbsp;</td></tr>");
		     out.println("</table>");
		     out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		     out.println("</font>");
		     out.println("</body>");
		     out.println("</html>");
		     out.println("	  	");
		}
		catch(IOException io)
		{System.out.println(io);}
		out.close();
	}

	private static void makeAdminInfo()
	{
	  	FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
	  	     fw = new FileWriter(Config._HTML_REPOSITORY+"admininfo.html");
		     out = new PrintWriter(fw);

		     out.println("<html>");
		     out.println("<head><title>Admin Information</title>");
		     out.println("");
		     out.println("<style type=\"text/css\">");
		     out.println(".input {background: \"#ffffcc\";color: \"#FFFF00\" ;font-weight: normal;}");
		     out.println("a.nav:link { text-decoration: none; color: \"#000000\"; }");
		     out.println("a.nav:visited { text-decoration: none; color: \"#000000\"; }");
		     out.println("a.nav:hover { text-decoration: underline; color: \"#000000\"; }");
		     out.println("</style>");
		     out.println("");
		     out.println("<script language=\"javascript\">");
		     out.println("function isblank(s)");
		     out.println("{");
		     out.println("	 for(var i = 0; i < s.length; i++) {");
		     out.println("		  var c = s.charAt(i);");
		     out.println("		  if ((c != ' ') && (c != '\n') && (c != '\t')) return false;");
		     out.println("	 }");
		     out.println("	 return true;");
		     out.println("}");
		     out.println("function verify(f)");
		     out.println("{");
		     out.println("	 var msg;");
		     out.println("	 var empty_fields = \"\";");
		     out.println("	 var errors = \"\";");
		     out.println("	  for(var i = 0; i < f.length; i++) {");
		     out.println("		  var e = f.elements[i];");
		     out.println("		  if (((e.type == \"text\") || (e.type == \"textarea\")) && e.noptional) {");
		     out.println("			   if ((e.value == null) || (e.value == \"\") || isblank(e.value)) {");
		     out.println("					empty_fields += \"\n          \" + e.name;");
		     out.println("					continue;");
		     out.println("			   }");
		     out.println("		  }");
		     out.println("	 }");
		     out.println("	 if (!empty_fields && !errors) return true;");
		     out.println("	 msg  = \"______________________________________________________\n\n\"");
		     out.println("		  msg += \"The form was not submitted because of the following error(s).\n\";");
		     out.println("	 msg += \"Please correct these error(s) and re-submit.\n\";");
		     out.println("	 msg += \"______________________________________________________\n\n\"");
		     out.println("		  if (empty_fields) {");
		     out.println("			   msg += \"- The following required field(s) are empty:\" ");
		     out.println("					+ empty_fields + \"\n\";");
		     out.println("			   if (errors) msg += \"\n\";");
		     out.println("		  }");
		     out.println("	 msg += errors;");
		     out.println("	 alert(msg);");
		     out.println("	 return false;");
		     out.println("}");
		     out.println("</script>");
		     out.println("</head>");
		     out.println("");
		     out.println("");
		     out.println("<body bgcolor=\"#ffffff\" marginheight=\"2\" marginwidth=\"2\" topmargin=\"2\" leftmargin=\"2\" alink=\"#0000ff\" vlink=\"#996699\" link=\"#6699cc\">");
		     out.println("");
		     out.println("");
		     out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		     out.println("");
		     out.println("<tr bgcolor=\"000080\">");
		     out.println("<td width=\"150\">&nbsp;</td>");
		     out.println("<td width=\"610\"> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr bgcolor=\"000080\">");
		     out.println("<td width=\"150\">&nbsp;</td>");
		     out.println("<td width=\"610\"> &nbsp;</td> </tr>");
		     out.println("");
		     out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
		     out.println("<td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
		     out.println("");
		     out.println("");
		     out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		     out.println("");
		     out.println("<tr valign=\"top\">");
		     out.println("<td width=\"150\" bgcolor=\"#000080\">");
		     out.println("<table width=\"150\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		     out.println("");
		     out.println("<tr><td width=\"150\" colspan=\"3\"></td>");
		     out.println("</tr>");
		     out.println("");
		     out.println("<tr>");
		     out.println("<td width=\"150\" colspan=\"3\"></td>");
		     out.println("</tr>");
		     out.println("</table>");
		     out.println("<br>");
		     out.println("");
		     out.println("");
		     out.println("<td width=\"610\"><a name=\"main\"></a>");
		     out.println("<!-- start body -->");
		     out.println("<TABLE CELLPADDING=\"0\" CELLSPACING=\"0\" BORDER=\"0\" width=\"100%\">");
		     out.println("");
		     out.println("<TR><TD width=8>&nbsp;</TD></tr>");
		     out.println("");
		     out.println("<TR><TD width=10> &nbsp; </td> <TD><font face=\"Arial, sans-serif\" size=\"4\" color=\"000080\"><b> Admin Information </b></font></td></tr>");
		     out.println("");
		     out.println("<TR><TD HEIGHT=\"18\" colspan=\"4\" width=\"100%\">&nbsp;</TD></TR>");
		     out.println("");
		     out.println("<TR><TD width=8>&nbsp;</TD>");
		     out.println("<TD colspan=3><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\"><br>Please fill in the details below and submit the form. ");
		     out.println("");
		     out.println("<p>The fields indicated with an asterisk (<b>*</b>) are required.<br>");
		     out.println(" ");
		     out.println("");
		     out.println("");
		     out.println("</FONT>");
		     out.println("");
		     out.println("<!-- FORM AND REFERER INFO -->");
		     out.println("<FORM name=\"admininfo\"");
		     out.println("onSubmit=\"this.name.noptional=true;this.email.noptional=true;this.firstline.noptional=true;this.city.noptional=true;this.state.noptional=true;return verify(this);\" ");
		     out.println("ACTION=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/FirstLoginServlet\" METHOD=POST>");
		     out.println("");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("<tr><!-- border -->");
		     out.println("<td colspan=\"4\"> ");
		     out.println("<br clear=\"LEFT\"> <hr> </td>");
		     out.println("</tr>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\"><b>Name*:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"30\" maxlength=50 name=\"name\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                <b>First line of address*:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"30\" maxlength=\"100\" name=\"firstline\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                <b>City*:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"30\" maxlength=20 name=\"city\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                <b>State*:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<td BGColor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"30\" maxlength=20 name=\"state\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("");
		     out.println("<TR><TD width=8>&nbsp;</TD><TD width=\"33%\" valign=top><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                     <b>Country*:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD><TD bgcolor=\"#87cefa\" width=\"66%\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("     <SELECT NAME=\"country\" SIZE=1>");
		     out.println("");
		     out.println("<option selected>No selection</option>");
		     out.println("            <option value=\"Afghanistan\">Afghanistan</option>");
		     out.println("            <option value=\"Albania\">Albania</option>");
		     out.println("            <option value=\"Algeria\">Algeria</option>");
		     out.println("            <option value=\"American Samoa\">American Samoa</option>");
		     out.println("            <option value=\"Andorra\">Andorra</option>");
		     out.println("            <option value=\"Angola\">Angola</option>");
		     out.println("            <option value=\"Antigua\">Antigua</option>");
		     out.println("            <option value=\"Argentina\">Argentina</option>");
		     out.println("            <option value=\"Armenia\">Armenia</option>");
		     out.println("            <option value=\"Aruba\">Aruba</option>");
		     out.println("            <option value=\"Australia\">Australia</option>");
		     out.println("            <option value=\"Austria\">Austria</option>");
		     out.println("            <option value=\"Azerbaijan\">Azerbaijan</option>");
		     out.println("            <option value=\"Azores\">Azores</option>");
		     out.println("            <option value=\"Bahamas\">Bahamas</option>");
		     out.println("            <option value=\"Bahrain\">Bahrain</option>");
		     out.println("            <option value=\"Bangladesh\">Bangladesh</option>");
		     out.println("            <option value=\"Barbados\">Barbados</option>");
		     out.println("            <option value=\"Belarus\">Belarus</option>");
		     out.println("            <option value=\"Belgium\">Belgium</option>");
		     out.println("            <option value=\"Belize\">Belize</option>");
		     out.println("            <option value=\"Benin\">Benin</option>");
		     out.println("            <option value=\"Bermuda\">Bermuda</option>");
		     out.println("            <option value=\"Bhutan\">Bhutan</option>");
		     out.println("            <option value=\"Bolivia\">Bolivia</option>");
		     out.println("            <option value=\"Bosnia/Herzegovina\">Bosnia/Herzegovina</option>");
		     out.println("            <option value=\"Botswana\">Botswana</option>");
		     out.println("            <option value=\"Brazil\">Brazil</option>");
		     out.println("            <option value=\"British West Indies\">British West Indies</option>");
		     out.println("            <option value=\"Brunei\">Brunei</option>");
		     out.println("            <option value=\"Bulgaria\">Bulgaria</option>");
		     out.println("            <option value=\"Burkina Faso\">Burkina Faso</option>");
		     out.println("            <option value=\"Burundi\">Burundi</option>");
		     out.println("            <option value=\"Cambodia\">Cambodia</option>");
		     out.println("            <option value=\"Cameroon\">Cameroon</option>");
		     out.println("            <option value=\"Canada\">Canada</option>");
		     out.println("            <option value=\"Cape Verde\">Cape Verde</option>");
		     out.println("            <option value=\"Central African Republic\">Central African Republic</option>");
		     out.println("            <option value=\"Chad\">Chad</option>");
		     out.println("            <option value=\"Chile\">Chile</option>");
		     out.println("            <option value=\"China, People's Republic of\">China, People's Republic ");
		     out.println("            of</option>");
		     out.println("            <option value=\"Colombia\">Colombia</option>");
		     out.println("            <option value=\"Comoros\">Comoros</option>");
		     out.println("            <option value=\"Congo\">Congo</option>");
		     out.println("            <option value=\"Costa Rica\">Costa Rica</option>");
		     out.println("            <option value=\"Croatia\">Croatia</option>");
		     out.println("            <option value=\"Cyprus\">Cyprus</option>");
		     out.println("            <option value=\"Czech Republic\">Czech Republic</option>");
		     out.println("            <option value=\"Denmark\">Denmark</option>");
		     out.println("            <option value=\"Djibouti\">Djibouti</option>");
		     out.println("            <option value=\"Dominica, Commonwealth of\">Dominica, Commonwealth ");
		     out.println("            of</option>");
		     out.println("            <option value=\"Dominican Republic\">Dominican Republic</option>");
		     out.println("            <option value=\"Ecuador\">Ecuador</option>");
		     out.println("            <option value=\"Egypt\">Egypt</option>");
		     out.println("            <option value=\"El Salvador\">El Salvador</option>");
		     out.println("            <option value=\"England\">England</option>");
		     out.println("            <option value=\"Equatorial Guinea\">Equatorial Guinea</option>");
		     out.println("            <option value=\"Eritrea\">Eritrea</option>");
		     out.println("            <option value=\"Estonia\">Estonia</option>");
		     out.println("            <option value=\"Ethiopia\">Ethiopia</option>");
		     out.println("            <option value=\"Fiji\">Fiji</option>");
		     out.println("            <option value=\"Finland\">Finland</option>");
		     out.println("            <option value=\"France\">France</option>");
		     out.println("            <option value=\"French Guiana\">French Guiana</option>");
		     out.println("            <option value=\"French Polynesia\">French Polynesia</option>");
		     out.println("            <option value=\"Gabon\">Gabon</option>");
		     out.println("            <option value=\"Gambia\">Gambia</option>");
		     out.println("            <option value=\"Gaza Strip\">Gaza Strip</option>");
		     out.println("            <option value=\"Georgia\">Georgia</option>");
		     out.println("            <option value=\"Germany\">Germany</option>");
		     out.println("            <option value=\"Ghana\">Ghana</option>");
		     out.println("            <option value=\"Greece\">Greece</option>");
		     out.println("            <option value=\"Greeland\">Greeland</option>");
		     out.println("            <option value=\"Grenada\">Grenada</option>");
		     out.println("            <option value=\"Guadeloupe\">Guadeloupe</option>");
		     out.println("            <option value=\"Guam\">Guam</option>");
		     out.println("            <option value=\"Guatemala\">Guatemala</option>");
		     out.println("            <option value=\"Guinea\">Guinea</option>");
		     out.println("            <option value=\"Guinea-Bissau\">Guinea-Bissau</option>");
		     out.println("            <option value=\"Guyana\">Guyana</option>");
		     out.println("            <option value=\"Haiti\">Haiti</option>");
		     out.println("            <option value=\"Honduras\">Honduras</option>");
		     out.println("            <option value=\"Hong Kong\">Hong Kong</option>");
		     out.println("            <option value=\"Hungary\">Hungary</option>");
		     out.println("            <option value=\"Iceland\">Iceland</option>");
		     out.println("            <option value=\"India\">India</option>");
		     out.println("            <option value=\"Indonesia\">Indonesia</option>");
		     out.println("            <option value=\"Ireland\">Ireland</option>");
		     out.println("            <option value=\"Isle of Man\">Isle of Man</option>");
		     out.println("            <option value=\"Israel\">Israel</option>");
		     out.println("            <option value=\"Italy\">Italy</option>");
		     out.println("            <option value=\"Ivory Coast\">Ivory Coast</option>");
		     out.println("            <option value=\"Jamaica\">Jamaica</option>");
		     out.println("            <option value=\"Japan\">Japan</option>");
		     out.println("            <option value=\"Jordan\">Jordan</option>");
		     out.println("            <option value=\"Kazakstan\">Kazakstan</option>");
		     out.println("            <option value=\"Kenya\">Kenya</option>");
		     out.println("            <option value=\"Kiribati\">Kiribati</option>");
		     out.println("            <option value=\"Korea\">Korea</option>");
		     out.println("            <option value=\"Kuwait\">Kuwait</option>");
		     out.println("            <option value=\"Kyrgystan\">Kyrgystan</option>");
		     out.println("            <option value=\"Laos\">Laos</option>");
		     out.println("            <option value=\"Latvia\">Latvia</option>");
		     out.println("            <option value=\"Lebanon\">Lebanon</option>");
		     out.println("            <option value=\"Lesotho\">Lesotho</option>");
		     out.println("            <option value=\"Liberia\">Liberia</option>");
		     out.println("            <option value=\"Libya\">Libya</option>");
		     out.println("            <option value=\"Liechtenstein\">Liechtenstein</option>");
		     out.println("            <option value=\"Lithuania\">Lithuania</option>");
		     out.println("            <option value=\"Luxembourg\">Luxembourg</option>");
		     out.println("            <option value=\"Macau\">Macau</option>");
		     out.println("            <option value=\"Macedonia\">Fmr Yugoslav Rep Macedonia</option>");
		     out.println("            <option value=\"Madagascar\">Madagascar</option>");
		     out.println("            <option value=\"Madeira Islands\">Madeira Islands</option>");
		     out.println("            <option value=\"Malawi\">Malawi</option>");
		     out.println("            <option value=\"Malaysia\">Malaysia</option>");
		     out.println("            <option value=\"Maldives\">Maldives</option>");
		     out.println("            <option value=\"Mali\">Mali</option>");
		     out.println("            <option value=\"Malta\">Malta</option>");
		     out.println("            <option value=\"Marshall Islands\">Marshall Islands</option>");
		     out.println("            <option value=\"Martinque\">Martinque</option>");
		     out.println("            <option value=\"Mauritania\">Mauritania</option>");
		     out.println("            <option value=\"Mauritius\">Mauritius</option>");
		     out.println("            <option value=\"Mexico\">Mexico</option>");
		     out.println("            <option value=\"Micronesia, Federated States of\">Micronesia, Federated ");
		     out.println("            States of</option>");
		     out.println("            <option value=\"Moldova\">Moldova</option>");
		     out.println("            <option value=\"Monaco\">Monaco</option>");
		     out.println("            <option value=\"Mongolia\">Mongolia</option>");
		     out.println("            <option value=\"Montserrat\">Montserrat</option>");
		     out.println("            <option value=\"Morocco\">Morocco</option>");
		     out.println("            <option value=\"Mozambique\">Mozambique</option>");
		     out.println("            <option value=\"Myanmar\">Myanmar</option>");
		     out.println("            <option value=\"Namibia\">Namibia</option>");
		     out.println("            <option value=\"Nauru\">Nauru</option>");
		     out.println("            <option value=\"Nepal\">Nepal</option>");
		     out.println("            <option value=\"Netherlands\">Netherlands</option>");
		     out.println("            <option value=\"Netherlands Antilles\">Netherlands Antilles</option>");
		     out.println("            <option value=\"New Caledonia\">New Caledonia</option>");
		     out.println("            <option value=\"New Zealand\">New Zealand</option>");
		     out.println("            <option value=\"Nicaragua\">Nicaragua</option>");
		     out.println("            <option value=\"Niger\">Niger</option>");
		     out.println("            <option value=\"Nigeria\">Nigeria</option>");
		     out.println("            <option value=\"Northern Ireland\">Northern Ireland</option>");
		     out.println("            <option value=\"Northern Mariana Islands\">Northern Mariana Islands</option>");
		     out.println("            <option value=\"Norway\">Norway</option>");
		     out.println("            <option value=\"Oman\">Oman</option>");
		     out.println("            <option value=\"Pakistan\">Pakistan</option>");
		     out.println("            <option value=\"Palau\">Palau</option>");
		     out.println("            <option value=\"Panama\">Panama</option>");
		     out.println("            <option value=\"Papua New Guinea\">Papua New Guinea</option>");
		     out.println("            <option value=\"Paraguay\">Paraguay</option>");
		     out.println("            <option value=\"Peru\">Peru</option>");
		     out.println("            <option value=\"Philippines\">Philippines</option>");
		     out.println("            <option value=\"Poland\">Poland</option>");
		     out.println("            <option value=\"Portugal\">Portugal</option>");
		     out.println("            <option value=\"Puerto Rico\">Puerto Rico</option>");
		     out.println("            <option value=\"Qatar\">Qatar</option>");
		     out.println("            <option value=\"Reunion\">Reunion</option>");
		     out.println("            <option value=\"Romania\">Romania</option>");
		     out.println("            <option value=\"Russia\">Russia</option>");
		     out.println("            <option value=\"Rwanda\">Rwanda</option>");
		     out.println("            <option value=\"Saint Kitts\">Saint Kitts</option>");
		     out.println("            <option value=\"Saint Lucia\">Saint Lucia</option>");
		     out.println("            <option value=\"Saint Vincent\">Saint Vincent</option>");
		     out.println("            <option value=\"San Marino\">San Marino</option>");
		     out.println("            <option value=\"Sao Tome and Principe\">Sao Tome and Principe</option>");
		     out.println("            <option value=\"Saudi Arabia\">Saudi Arabia</option>");
		     out.println("            <option value=\"Scotland\">Scotland</option>");
		     out.println("            <option value=\"Senegal\">Senegal</option>");
		     out.println("            <option value=\"Seychelles\">Seychelles</option>");
		     out.println("            <option value=\"Sierra Leone\">Sierra Leone</option>");
		     out.println("            <option value=\"Singapore\">Singapore</option>");
		     out.println("            <option value=\"Slovak Republic\">Slovak Republic</option>");
		     out.println("            <option value=\"Slovenia\">Slovenia</option>");
		     out.println("            <option value=\"Solomon Islands\">Solomon Islands</option>");
		     out.println("            <option value=\"South Africa\">South Africa</option>");
		     out.println("            <option value=\"Spain\">Spain</option>");
		     out.println("            <option value=\"Sri Lanka\">Sri Lanka</option>");
		     out.println("            <option value=\"Sudan\">Sudan</option>");
		     out.println("            <option value=\"Suriname\">Suriname</option>");
		     out.println("            <option value=\"Swaziland\">Swaziland</option>");
		     out.println("            <option value=\"Sweden\">Sweden</option>");
		     out.println("            <option value=\"Switzerland\">Switzerland</option>");
		     out.println("            <option value=\"Syria\">Syria</option>");
		     out.println("            <option value=\"Tahiti\">Tahiti</option>");
		     out.println("            <option value=\"Taiwan\">Taiwan</option>");
		     out.println("            <option value=\"Tajikistan\">Tajikistan</option>");
		     out.println("            <option value=\"Tanzania\">Tanzania</option>");
		     out.println("            <option value=\"Thailand\">Thailand</option>");
		     out.println("            <option value=\"Togo\">Togo</option>");
		     out.println("            <option value=\"Tongo\">Tongo</option>");
		     out.println("            <option value=\"Trinida and Tobago\">Trinida and Tobago</option>");
		     out.println("            <option value=\"Tunisia\">Tunisia</option>");
		     out.println("            <option value=\"Turkey\">Turkey</option>");
		     out.println("            <option value=\"Turkmenistan\">Turkmenistan</option>");
		     out.println("            <option value=\"Tuvalu\">Tuvalu</option>");
		     out.println("            <option value=\"US Virgin Islands\">US Virgin Islands</option>");
		     out.println("            <option value=\"Uganda\">Uganda</option>");
		     out.println("            <option value=\"Ukraine\">Ukraine</option>");
		     out.println("            <option value=\"United Arab Emirates\">United Arab Emirates</option>");
		     out.println("            <option value=\"United Kingdom\">United Kingdom</option>");
		     out.println("            <option value=\"United States of America\">United States of America</option>");
		     out.println("            <option value=\"Uruguay\">Uruguay</option>");
		     out.println("            <option value=\"Uzbekistan\">Uzbekistan</option>");
		     out.println("            <option value=\"Vanuatu\">Vanuatu</option>");
		     out.println("            <option value=\"Vatican City\">Vatican City</option>");
		     out.println("            <option value=\"Venezuela\">Venezuela</option>");
		     out.println("            <option value=\"Vietnam\">Vietnam</option>");
		     out.println("            <option value=\"Wales\">Wales</option>");
		     out.println("            <option value=\"West Bank\">West Bank</option>");
		     out.println("            <option value=\"Western Samoa\">Western Samoa</option>");
		     out.println("            <option value=\"Yemen\">Yemen</option>");
		     out.println("            <option value=\"Yugoslavia\">Yugoslavia</option>");
		     out.println("            <option value=\"Zaire\">Zaire</option>");
		     out.println("            <option value=\"Zambia\">Zambia</option>");
		     out.println("            <option value=\"Zimbabwe\">Zimbabwe</option>");
		     out.println("");
		     out.println("</SELECT><br>&nbsp;</TD></TR>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                <b>Telephone:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"10\" maxlength=10 name=\"phone\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("<TR><TD width=\"8\">&nbsp;</TD>");
		     out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
		     out.println("                <b>Fax:</b></FONT></TD>");
		     out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
		     out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
		     out.println("             <input type=\"text\" size=\"10\" maxlength=10 name=\"fax\"><br>&nbsp;");
		     out.println("</TD>");
		     out.println("</TR>");
		     out.println("");
		     out.println("</TABLE>");
		     out.println("</TD></TR></TABLE>");
		     out.println("<br>");
		     out.println("<p>");
		     out.println("<br>");
		     out.println("<p>");
		     out.println("");
		     out.println("<!-- end body -->");
		     out.println("&nbsp;</td></tr></table>");
		     out.println("");
		     out.println("<br>");
		     out.println("<p>");
		     out.println("<hr>");
		     out.println("<p>");
		     out.println("<center>");
		     out.println("");
		     out.println("<TABLE width=\"200\" CELLPADDING=\"0\" CELLSPACING=\"0\" BORDER=\"0\">");
		     out.println("<TR><TD><input type=\"submit\" name=\"SEND\" value=\"Submit\"></TD>");
		     out.println("<TD width=\"50\">&nbsp;</TD><TD><input type=\"reset\" name=\"RESET\" value=\"Clear\"></TD></TR></TABLE><br>");
		     out.println("</center>");
		     out.println("</TD></TR>");
		     out.println("</form>");
		     out.println("");
		     out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		     out.println("<tr bgcolor=\"#000000\">");
		     out.println("<td width=\"760\">&nbsp;</td></tr>");
		     out.println("</table>");
		     out.println("</body>");
		     out.println("</html>");
		     out.println("	  	");
		}
		catch(IOException io)
		{System.out.println(io);}
		out.close();
	}

	private static void makeQueryPage()
	{
	        FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
		      fw=new FileWriter(Config._HTML_REPOSITORY+"ParticipantQuery.html");
		      out=new PrintWriter(fw);

		      out.println("<html><head><title>Participant Query Form</title>");
		      out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"http://"+Config._HTMLROOT+"Style.css\">");
		      out.println("</head> <body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		      out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
		      out.println("<tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
		      out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td><td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
		      out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr valign=top><td width=150 bgcolor=#000080>");
		      out.println("<table width=150 border=0 cellspacing=0 cellpadding=0><tr><td width=150 colspan=3></td></tr><tr><td width=150 colspan=3></td></tr></table><br>");
		      out.println("<td width=610><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%><TR><TD width=8>&nbsp;</TD></tr>");
		      out.println("<TR><TD width=10> &nbsp; </td> <TD><font class=TITLEFONT size=4 color=000080><b>Participant Query Form </b></font><p>");
		      out.println("<p><table width=360 border=0 cellspacing=0 cellpadding=0>");
		      out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr>");
		      out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
		      out.println("</table>");
		      out.println("<form method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/QueryParticipant\">");
		      
		      out.println("<table>");
		      out.println("<tr><td> Please select the attributes to be printed from the following. </td></tr>");
		      out.println("</table>");
		      out.println("<table>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"email1\" value=\"1\">EMAIL</td>");
		      out.println("<td><input type=\"text\" name=\"email2\" size=50 maxlength=100></td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"name1\" value=\"1\">NAME</td>");
		      out.println("<td> <input type=\"text\" name=\"name2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"firstline1\" value=\"1\">FIRSTLINE</td>");
		      out.println("<td> <input type=\"text\" name=\"firstline2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"city1\" value=\"1\">CITY</td>");
		      out.println("<td> <input type=\"text\" name=\"city2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"state1\" value=\"1\">STATE</td>");
		      out.println("<td> <input type=\"text\" name=\"state2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"country1\" value=\"1\">COUNTRY</td>");
		      out.println("<td> <input type=\"text\" name=\"country2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"phone1\" value=\"1\">PHONE</td>");
		      out.println("<td> <input type=\"text\" name=\"phone2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"fax1\" value=\"1\">FAX</td>");
		      out.println("<td> <input type=\"text\" name=\"fax2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"affiliation1\" value=\"1\">AFFILIATION</td>");
		      out.println("<td> <input type=\"text\" name=\"affiliation2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"nameontag1\" value=\"1\">NAMEONTAG</td>");
		      out.println("<td> <input type=\"text\" name=\"nameontag2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"affiliationontag1\" value=\"1\">AFFILIATIONONTAG</td>");
		      out.println("<td> <input type=\"text\" name=\"affiliationontag2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"institutionontag1\" value=\"1\">INSTITUTIONONTAG</td>");
		      out.println("<td> <input type=\"text\" name=\"institutionontag2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"specialneeds1\" value=\"1\">SPECIALNEEDS</td>");
		      out.println("<td> <input type=\"text\" name=\"specialneeds2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"hotel1\" value=\"1\">HOTEL</td>");
		      out.println("<td> <input type=\"text\" name=\"hotel2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"checkindate1\" value=\"1\">CHECKINDATE</td>");
		      out.println("<td> <input type=\"text\" name=\"checkindate2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"checkoutdate1\" value=\"1\">CHECKOUTDATE</td>");
		      out.println("<td> <input type=\"text\" name=\"checkoutdate2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"roomtype1\" value=\"1\">ROOMTYPE</td>");
		      out.println("<td> <input type=\"text\" name=\"roomtype2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"programid1\" value=\"1\">PROGRAMID</td>");
		      out.println("<td> <input type=\"text\" name=\"programid2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"eventid1\" value=\"1\">EVENTID</td>");
		      out.println("<td> <input type=\"text\" name=\"eventid2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"amount1\" value=\"1\">AMOUNT</td>");
		      out.println("<td> <input type=\"text\" name=\"amount2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"madepayment1\" value=\"1\">MADEPAYMENT</td>");
		      out.println("<td> <input type=\"text\" name=\"madepayment2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"paymentmode1\" value=\"1\">PAYMENTMODE</td>");
		      out.println("<td> <input type=\"text\" name=\"paymentmode2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"currency1\" value=\"1\">CURRENCY</td>");
		      out.println("<td> <input type=\"text\" name=\"currency2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"creditcardno1\" value=\"1\">CREDITCARDNO</td>");
		      out.println("<td> <input type=\"text\" name=\"creditcardno2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"expirydate1\" value=\"1\">EXPIRYDATE</td>");
		      out.println("<td> <input type=\"text\" name=\"expirydate2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"type1\" value=\"1\">TYPE</td>");
		      out.println("<td> <input type=\"text\" name=\"type2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"chequeno1\" value=\"1\">CHEQUENO</td>");
		      out.println("<td> <input type=\"text\" name=\"chequeno2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"chequebank1\" value=\"1\">CHEQUEBANK</td>");
		      out.println("<td> <input type=\"text\" name=\"chequebank2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"issuedate1\" value=\"1\">ISSUEDATE</td>");
		      out.println("<td> <input type=\"text\" name=\"issuedate2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"ddno1\" value=\"1\">DDNO</td>");
		      out.println("<td> <input type=\"text\" name=\"ddno2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td> <input type=\"checkbox\" name=\"ddbank1\" value=\"1\">DDBANK</td>");
		      out.println("<td> <input type=\"text\" name=\"ddbank2\" size=20 maxlength=50> </td></tr>");
		      out.println("<tr><td>Give an SQL query of your own</td><td><input type=\"text\" name =\"sqlquery\" size=50 maxlength=200></td></tr>");
		      out.println("</table>");
		      out.println("<input type=\"Submit\" value=\"Submit\">");
		      out.println("</form>");
		      out.println("<br>");
		      out.println("</td></tr><tr></table></table> <table width=760> <tr bgcolor=#000000><td width=760>&nbsp</td><tr></table>");
		      out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		      out.println("</font></body></html>");
		}
		catch(IOException io)
		{System.out.println(io);}
		out.close();
	}
	
	private static void makePaperReg()
	{
		try {
	
		    FileWriter fw=new FileWriter(Config._HTML_REPOSITORY+"PaperReg.html");
		    PrintWriter out=new PrintWriter(fw);
	
		    out.println("<html><head><title>Paper Registration</title>");
		    out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"Style.css\">");
		    out.println("</head> ");
		    out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		    out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
		    out.println("<tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
		    out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td><td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
		    out.println("");
		    out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr valign=top><td width=150 bgcolor=#000080>");
		    out.println("<table width=150 border=0 cellspacing=0 cellpadding=0><tr><td width=150 colspan=3></td></tr><tr><td width=150 colspan=3></td></tr></table><br>");
		    out.println("<td width=610>");
		    out.println("");
		    out.println("<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%><TR><TD width=8>&nbsp;</TD></tr>");
		    out.println("<TR><TD width=10> &nbsp; </td> <TD><font class=TITLEFONT size=5 color=000080><b>Paper Registration </b></font><p>");
		    out.println("<font size=2 class=TDFONT><p>Please fill in the details below and submit the form.");
		    out.println("");
		    out.println("<p>The fields indicated with an asterisk (<b>*</b>) are required.</font><br><p><hr>");
		    out.println("");
		    out.println("<form name=\"GetReg\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/PaperRegistration\">");
		    out.println("</td></tr>");
		    out.println("");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Title:</b></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"title\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Category:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"category\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Abstract:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<textarea name=\"abstract\" rows=10 cols=30></textarea><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Contact author email:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-email\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Contact author name:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-name\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Contact author address-firstline:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-firstline\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>City:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-city\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>State:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-state\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Country:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-country\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("");
		    out.println("");
		    out.println("");
		    out.println("");
		    out.println("");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Phone:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-phone\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Fax:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-fax\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
		    out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>Contact author's rank:</b></font></td>");
		    out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
		    out.println("<input type=\"text\" name=\"contact-rank\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
			
			for(int i=0; i<Config._NO_OF_AUTHORS; i++) {
				 int j=i+1;
				 out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>"+j+".Author email:</b></font></td>");
				 out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				 out.println("<input type=\"text\" name=\"author-email"+i+"\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
				 out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>"+j+".Author name:</b></font></td>");
				 out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				 out.println("<input type=\"text\" name=\"author-name"+i+"\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
				 out.println("<tr><td width=8>&nbsp;</td><td width=142><br clear=\"ALL\"<font size=1 class=TDFONT><b>"+j+".Author rank:</b></font></td>");
				 out.println("<td width=8 bgcolor=#87cefa>&nbsp;</td><td bgcolor=#87cefa width=292><br clear=ALL><font size=1 class=TDFONT>&nbsp;<br>");
				 out.println("<input type=\"text\" name=\"author-rank"+i+"\" size=30 maxlength=\"60\"><br>&nbsp;</td></tr>");
			}

			out.println("<tr><td><input type=\"submit\" name=\"go\" value=\"RegisterNow\"> </td></tr></center></form>");
		    out.println("</td></tr><tr></table></table> <table width=760> <tr bgcolor=#000000><td width=760>&nbsp</td><tr></table>");
		    out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		    out.println("</font></body></html>");
		    out.close();
		  }
		catch(IOException ioe)
		{ 
		    System.out.println("Can't write onto file"); }
	}
		
	private static void makeReupload()
	{
		try {
		  
			FileWriter fw=new FileWriter(Config._HTML_REPOSITORY+"Re-Upload.html");
			PrintWriter out=new PrintWriter(fw);

			out.println("<html><head><title>Upload</title>");
			out.println("<link rel=\"Stylesheet\" href=\"Style.css\">");
			out.println("</head>");
			out.println("<body bgcolor=white>");
			out.println("<form method=\"post\" enctype=\"multipart/form-data\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Upload\">");
			out.println("<br> </br>");
			out.println("<center> <input type=\"file\" name=\"filename\" size=60> </center> <br> </br>");
			out.println("<center><input type=\"submit\" value=\"upload\"></center> </form>");
			out.println("</body>");
			out.println("</html>");
			out.println("");
			out.close();			
		}
		catch(IOException ioe)
		{ 
			System.out.println("Can't write onto file");
		}
	}
		
	private static void makeRevInfo()
	{
		try {

			FileWriter fw=new FileWriter(Config._HTML_REPOSITORY+"revinfo.html");
			PrintWriter out=new PrintWriter(fw);

			out.println("<html>");
			out.println("<head><title>Reviewer Information</title>");
			out.println("");
			out.println("<style type=\"text/css\">");
			out.println(".input {background: \"#ffffcc\";color: \"#FFFF00\" ;font-weight: normal;}");
			out.println("a.nav:link { text-decoration: none; color: \"#000000\"; }");
			out.println("a.nav:visited { text-decoration: none; color: \"#000000\"; }");
			out.println("a.nav:hover { text-decoration: underline; color: \"#000000\"; }");
			out.println("</style>");
			out.println("");
			out.println("<script language=\"javascript\">");
			out.println("function isblank(s)");
			out.println("{");
			out.println("	 for(var i = 0; i < s.length; i++) {");
			out.println("		  var c = s.charAt(i);");
			out.println("		  if ((c != ' ') && (c != '\\n') && (c != '\\t')) return false;");
			out.println("	 }");
			out.println("	 return true;");
			out.println("}");
			out.println("function verify(f)");
			out.println("{");
			out.println("	 var msg;");
			out.println("	 var empty_fields = \"\";");
			out.println("	 var errors = \"\";");
			out.println("	  for(var i = 0; i < f.length; i++) {");
			out.println("		  var e = f.elements[i];");
			out.println("		  if (((e.type == \"text\") || (e.type == \"textarea\")) && e.noptional) {");
			out.println("			   if ((e.value == null) || (e.value == \"\") || isblank(e.value)) {");
			out.println("					empty_fields += \"\\n          \" + e.name;");
			out.println("					continue;");
			out.println("			   }");
			out.println("		  }");
			out.println("	 }");
			out.println("	 if (!empty_fields && !errors) return true;");
			out.println("	 msg  = \"______________________________________________________\\n\\n\"");
			out.println("		  msg += \"The form was not submitted because of the following error(s).\\n\";");
			out.println("	 msg += \"Please correct these error(s) and re-submit.\\n\";");
			out.println("	 msg += \"______________________________________________________\\n\\n\"");
			out.println("		  if (empty_fields) {");
			out.println("			   msg += \"- The following required field(s) are empty:\" ");
			out.println("					+ empty_fields + \"\\n\";");
			out.println("			   if (errors) msg += \"\\n\";");
			out.println("		  }");
			out.println("	 msg += errors;");
			out.println("	 alert(msg);");
			out.println("	 return false;");
			out.println("}");
			out.println("</script>");
			out.println("</head>");
			out.println("");
			out.println("");
			out.println("<body bgcolor=\"#ffffff\" marginheight=\"2\" marginwidth=\"2\" topmargin=\"2\" leftmargin=\"2\" alink=\"#0000ff\" vlink=\"#996699\" link=\"#6699cc\">");
			out.println("");
			out.println("");
			out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
			out.println("");
			out.println("<tr bgcolor=\"000080\">");
			out.println("<td width=\"150\">&nbsp;</td>");
			out.println("<td width=\"610\"> &nbsp;</td> </tr>");
			out.println("");
			out.println("<tr bgcolor=\"000080\">");
			out.println("<td width=\"150\">&nbsp;</td>");
			out.println("<td width=\"610\"> &nbsp;</td> </tr>");
			out.println("");
			out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
			out.println("<td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
			out.println("");
			out.println("");
			out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
			out.println("");
			out.println("<tr valign=\"top\">");
			out.println("<td width=\"150\" bgcolor=\"#000080\">");
			out.println("<table width=\"150\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
			out.println("");
			out.println("<tr><td width=\"150\" colspan=\"3\"></td>");
			out.println("</tr>");
			out.println("");
			out.println("<tr>");
			out.println("<td width=\"150\" colspan=\"3\"></td>");
			out.println("</tr>");
			out.println("</table>");
			out.println("<br>");
			out.println("");
			out.println("");
			out.println("<td width=\"610\"><a name=\"main\"></a>");
			out.println("<!-- start body -->");
			out.println("<TABLE CELLPADDING=\"0\" CELLSPACING=\"0\" BORDER=\"0\" width=\"100%\">");
			out.println("");
			out.println("<TR><TD width=8>&nbsp;</TD></tr>");
			out.println("");
			out.println("<TR><TD width=10> &nbsp; </td> <TD><font face=\"Arial, sans-serif\" size=\"4\" color=\"000080\"><b> Reviewer Information </b></font></td></tr>");
			out.println("");
			out.println("<TR><TD HEIGHT=\"18\" colspan=\"4\" width=\"100%\">&nbsp;</TD></TR>");
			out.println("");
			out.println("<TR><TD width=8>&nbsp;</TD>");
			out.println("<TD colspan=3><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\"><br>Please fill in the details below and submit the form. ");
			out.println("");
			out.println("<p>The fields indicated with an asterisk (<b>*</b>) are required.<br>");
			out.println(" ");
			out.println("");
			out.println("");
			out.println("</FONT>");
			out.println("");
			out.println("<!-- FORM AND REFERER INFO -->");
			out.println("<FORM name=\"revinfo\"");
			out.println("onSubmit=\"this.name.noptional=true;this.email.noptional=true;this.firstline.noptional=true;this.city.noptional=true;this.state.noptional=true;this.field.noptional=true;return verify(this);\" ");
			out.println("ACTION=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/FirstLoginServlet\" METHOD=POST>");
			out.println("");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("<tr><!-- border -->");
			out.println("<td colspan=\"4\"> ");
			out.println("<br clear=\"LEFT\"> <hr> </td>");
			out.println("</tr>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\"><b>Name*:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"30\" maxlength=50 name=\"name\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>First line of address*:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"30\" maxlength=\"100\" name=\"firstline\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>City*:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"30\" maxlength=20 name=\"city\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>State*:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<td BGColor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"30\" maxlength=20 name=\"state\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("");
			out.println("<TR><TD width=8>&nbsp;</TD><TD width=\"33%\" valign=top><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                     <b>Country*:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD><TD bgcolor=\"#87cefa\" width=\"66%\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("     <SELECT NAME=\"country\" SIZE=1>");
			out.println("");
			out.println("<option selected>No selection</option>");
			out.println("            <option value=\"Afghanistan\">Afghanistan</option>");
			out.println("            <option value=\"Albania\">Albania</option>");
			out.println("            <option value=\"Algeria\">Algeria</option>");
			out.println("            <option value=\"American Samoa\">American Samoa</option>");
			out.println("            <option value=\"Andorra\">Andorra</option>");
			out.println("            <option value=\"Angola\">Angola</option>");
			out.println("            <option value=\"Antigua\">Antigua</option>");
			out.println("            <option value=\"Argentina\">Argentina</option>");
			out.println("            <option value=\"Armenia\">Armenia</option>");
			out.println("            <option value=\"Aruba\">Aruba</option>");
			out.println("            <option value=\"Australia\">Australia</option>");
			out.println("            <option value=\"Austria\">Austria</option>");
			out.println("            <option value=\"Azerbaijan\">Azerbaijan</option>");
			out.println("            <option value=\"Azores\">Azores</option>");
			out.println("            <option value=\"Bahamas\">Bahamas</option>");
			out.println("            <option value=\"Bahrain\">Bahrain</option>");
			out.println("            <option value=\"Bangladesh\">Bangladesh</option>");
			out.println("            <option value=\"Barbados\">Barbados</option>");
			out.println("            <option value=\"Belarus\">Belarus</option>");
			out.println("            <option value=\"Belgium\">Belgium</option>");
			out.println("            <option value=\"Belize\">Belize</option>");
			out.println("            <option value=\"Benin\">Benin</option>");
			out.println("            <option value=\"Bermuda\">Bermuda</option>");
			out.println("            <option value=\"Bhutan\">Bhutan</option>");
			out.println("            <option value=\"Bolivia\">Bolivia</option>");
			out.println("            <option value=\"Bosnia/Herzegovina\">Bosnia/Herzegovina</option>");
			out.println("            <option value=\"Botswana\">Botswana</option>");
			out.println("            <option value=\"Brazil\">Brazil</option>");
			out.println("            <option value=\"British West Indies\">British West Indies</option>");
			out.println("            <option value=\"Brunei\">Brunei</option>");
			out.println("            <option value=\"Bulgaria\">Bulgaria</option>");
			out.println("            <option value=\"Burkina Faso\">Burkina Faso</option>");
			out.println("            <option value=\"Burundi\">Burundi</option>");
			out.println("            <option value=\"Cambodia\">Cambodia</option>");
			out.println("            <option value=\"Cameroon\">Cameroon</option>");
			out.println("            <option value=\"Canada\">Canada</option>");
			out.println("            <option value=\"Cape Verde\">Cape Verde</option>");
			out.println("            <option value=\"Central African Republic\">Central African Republic</option>");
			out.println("            <option value=\"Chad\">Chad</option>");
			out.println("            <option value=\"Chile\">Chile</option>");
			out.println("            <option value=\"China, People's Republic of\">China, People's Republic ");
			out.println("            of</option>");
			out.println("            <option value=\"Colombia\">Colombia</option>");
			out.println("            <option value=\"Comoros\">Comoros</option>");
			out.println("            <option value=\"Congo\">Congo</option>");
			out.println("            <option value=\"Costa Rica\">Costa Rica</option>");
			out.println("            <option value=\"Croatia\">Croatia</option>");
			out.println("            <option value=\"Cyprus\">Cyprus</option>");
			out.println("            <option value=\"Czech Republic\">Czech Republic</option>");
			out.println("            <option value=\"Denmark\">Denmark</option>");
			out.println("            <option value=\"Djibouti\">Djibouti</option>");
			out.println("            <option value=\"Dominica, Commonwealth of\">Dominica, Commonwealth ");
			out.println("            of</option>");
			out.println("            <option value=\"Dominican Republic\">Dominican Republic</option>");
			out.println("            <option value=\"Ecuador\">Ecuador</option>");
			out.println("            <option value=\"Egypt\">Egypt</option>");
			out.println("            <option value=\"El Salvador\">El Salvador</option>");
			out.println("            <option value=\"England\">England</option>");
			out.println("            <option value=\"Equatorial Guinea\">Equatorial Guinea</option>");
			out.println("            <option value=\"Eritrea\">Eritrea</option>");
			out.println("            <option value=\"Estonia\">Estonia</option>");
			out.println("            <option value=\"Ethiopia\">Ethiopia</option>");
			out.println("            <option value=\"Fiji\">Fiji</option>");
			out.println("            <option value=\"Finland\">Finland</option>");
			out.println("            <option value=\"France\">France</option>");
			out.println("            <option value=\"French Guiana\">French Guiana</option>");
			out.println("            <option value=\"French Polynesia\">French Polynesia</option>");
			out.println("            <option value=\"Gabon\">Gabon</option>");
			out.println("            <option value=\"Gambia\">Gambia</option>");
			out.println("            <option value=\"Gaza Strip\">Gaza Strip</option>");
			out.println("            <option value=\"Georgia\">Georgia</option>");
			out.println("            <option value=\"Germany\">Germany</option>");
			out.println("            <option value=\"Ghana\">Ghana</option>");
			out.println("            <option value=\"Greece\">Greece</option>");
			out.println("            <option value=\"Greeland\">Greeland</option>");
			out.println("            <option value=\"Grenada\">Grenada</option>");
			out.println("            <option value=\"Guadeloupe\">Guadeloupe</option>");
			out.println("            <option value=\"Guam\">Guam</option>");
			out.println("            <option value=\"Guatemala\">Guatemala</option>");
			out.println("            <option value=\"Guinea\">Guinea</option>");
			out.println("            <option value=\"Guinea-Bissau\">Guinea-Bissau</option>");
			out.println("            <option value=\"Guyana\">Guyana</option>");
			out.println("            <option value=\"Haiti\">Haiti</option>");
			out.println("            <option value=\"Honduras\">Honduras</option>");
			out.println("            <option value=\"Hong Kong\">Hong Kong</option>");
			out.println("            <option value=\"Hungary\">Hungary</option>");
			out.println("            <option value=\"Iceland\">Iceland</option>");
			out.println("            <option value=\"India\">India</option>");
			out.println("            <option value=\"Indonesia\">Indonesia</option>");
			out.println("            <option value=\"Ireland\">Ireland</option>");
			out.println("            <option value=\"Isle of Man\">Isle of Man</option>");
			out.println("            <option value=\"Israel\">Israel</option>");
			out.println("            <option value=\"Italy\">Italy</option>");
			out.println("            <option value=\"Ivory Coast\">Ivory Coast</option>");
			out.println("            <option value=\"Jamaica\">Jamaica</option>");
			out.println("            <option value=\"Japan\">Japan</option>");
			out.println("            <option value=\"Jordan\">Jordan</option>");
			out.println("            <option value=\"Kazakstan\">Kazakstan</option>");
			out.println("            <option value=\"Kenya\">Kenya</option>");
			out.println("            <option value=\"Kiribati\">Kiribati</option>");
			out.println("            <option value=\"Korea\">Korea</option>");
			out.println("            <option value=\"Kuwait\">Kuwait</option>");
			out.println("            <option value=\"Kyrgystan\">Kyrgystan</option>");
			out.println("            <option value=\"Laos\">Laos</option>");
			out.println("            <option value=\"Latvia\">Latvia</option>");
			out.println("            <option value=\"Lebanon\">Lebanon</option>");
			out.println("            <option value=\"Lesotho\">Lesotho</option>");
			out.println("            <option value=\"Liberia\">Liberia</option>");
			out.println("            <option value=\"Libya\">Libya</option>");
			out.println("            <option value=\"Liechtenstein\">Liechtenstein</option>");
			out.println("            <option value=\"Lithuania\">Lithuania</option>");
			out.println("            <option value=\"Luxembourg\">Luxembourg</option>");
			out.println("            <option value=\"Macau\">Macau</option>");
			out.println("            <option value=\"Macedonia\">Fmr Yugoslav Rep Macedonia</option>");
			out.println("            <option value=\"Madagascar\">Madagascar</option>");
			out.println("            <option value=\"Madeira Islands\">Madeira Islands</option>");
			out.println("            <option value=\"Malawi\">Malawi</option>");
			out.println("            <option value=\"Malaysia\">Malaysia</option>");
			out.println("            <option value=\"Maldives\">Maldives</option>");
			out.println("            <option value=\"Mali\">Mali</option>");
			out.println("            <option value=\"Malta\">Malta</option>");
			out.println("            <option value=\"Marshall Islands\">Marshall Islands</option>");
			out.println("            <option value=\"Martinque\">Martinque</option>");
			out.println("            <option value=\"Mauritania\">Mauritania</option>");
			out.println("            <option value=\"Mauritius\">Mauritius</option>");
			out.println("            <option value=\"Mexico\">Mexico</option>");
			out.println("            <option value=\"Micronesia, Federated States of\">Micronesia, Federated ");
			out.println("            States of</option>");
			out.println("            <option value=\"Moldova\">Moldova</option>");
			out.println("            <option value=\"Monaco\">Monaco</option>");
			out.println("            <option value=\"Mongolia\">Mongolia</option>");
			out.println("            <option value=\"Montserrat\">Montserrat</option>");
			out.println("            <option value=\"Morocco\">Morocco</option>");
			out.println("            <option value=\"Mozambique\">Mozambique</option>");
			out.println("            <option value=\"Myanmar\">Myanmar</option>");
			out.println("            <option value=\"Namibia\">Namibia</option>");
			out.println("            <option value=\"Nauru\">Nauru</option>");
			out.println("            <option value=\"Nepal\">Nepal</option>");
			out.println("            <option value=\"Netherlands\">Netherlands</option>");
			out.println("            <option value=\"Netherlands Antilles\">Netherlands Antilles</option>");
			out.println("            <option value=\"New Caledonia\">New Caledonia</option>");
			out.println("            <option value=\"New Zealand\">New Zealand</option>");
			out.println("            <option value=\"Nicaragua\">Nicaragua</option>");
			out.println("            <option value=\"Niger\">Niger</option>");
			out.println("            <option value=\"Nigeria\">Nigeria</option>");
			out.println("            <option value=\"Northern Ireland\">Northern Ireland</option>");
			out.println("            <option value=\"Northern Mariana Islands\">Northern Mariana Islands</option>");
			out.println("            <option value=\"Norway\">Norway</option>");
			out.println("            <option value=\"Oman\">Oman</option>");
			out.println("            <option value=\"Pakistan\">Pakistan</option>");
			out.println("            <option value=\"Palau\">Palau</option>");
			out.println("            <option value=\"Panama\">Panama</option>");
			out.println("            <option value=\"Papua New Guinea\">Papua New Guinea</option>");
			out.println("            <option value=\"Paraguay\">Paraguay</option>");
			out.println("            <option value=\"Peru\">Peru</option>");
			out.println("            <option value=\"Philippines\">Philippines</option>");
			out.println("            <option value=\"Poland\">Poland</option>");
			out.println("            <option value=\"Portugal\">Portugal</option>");
			out.println("            <option value=\"Puerto Rico\">Puerto Rico</option>");
			out.println("            <option value=\"Qatar\">Qatar</option>");
			out.println("            <option value=\"Reunion\">Reunion</option>");
			out.println("            <option value=\"Romania\">Romania</option>");
			out.println("            <option value=\"Russia\">Russia</option>");
			out.println("            <option value=\"Rwanda\">Rwanda</option>");
			out.println("            <option value=\"Saint Kitts\">Saint Kitts</option>");
			out.println("            <option value=\"Saint Lucia\">Saint Lucia</option>");
			out.println("            <option value=\"Saint Vincent\">Saint Vincent</option>");
			out.println("            <option value=\"San Marino\">San Marino</option>");
			out.println("            <option value=\"Sao Tome and Principe\">Sao Tome and Principe</option>");
			out.println("            <option value=\"Saudi Arabia\">Saudi Arabia</option>");
			out.println("            <option value=\"Scotland\">Scotland</option>");
			out.println("            <option value=\"Senegal\">Senegal</option>");
			out.println("            <option value=\"Seychelles\">Seychelles</option>");
			out.println("            <option value=\"Sierra Leone\">Sierra Leone</option>");
			out.println("            <option value=\"Singapore\">Singapore</option>");
			out.println("            <option value=\"Slovak Republic\">Slovak Republic</option>");
			out.println("            <option value=\"Slovenia\">Slovenia</option>");
			out.println("            <option value=\"Solomon Islands\">Solomon Islands</option>");
			out.println("            <option value=\"South Africa\">South Africa</option>");
			out.println("            <option value=\"Spain\">Spain</option>");
			out.println("            <option value=\"Sri Lanka\">Sri Lanka</option>");
			out.println("            <option value=\"Sudan\">Sudan</option>");
			out.println("            <option value=\"Suriname\">Suriname</option>");
			out.println("            <option value=\"Swaziland\">Swaziland</option>");
			out.println("            <option value=\"Sweden\">Sweden</option>");
			out.println("            <option value=\"Switzerland\">Switzerland</option>");
			out.println("            <option value=\"Syria\">Syria</option>");
			out.println("            <option value=\"Tahiti\">Tahiti</option>");
			out.println("            <option value=\"Taiwan\">Taiwan</option>");
			out.println("            <option value=\"Tajikistan\">Tajikistan</option>");
			out.println("            <option value=\"Tanzania\">Tanzania</option>");
			out.println("            <option value=\"Thailand\">Thailand</option>");
			out.println("            <option value=\"Togo\">Togo</option>");
			out.println("            <option value=\"Tongo\">Tongo</option>");
			out.println("            <option value=\"Trinida and Tobago\">Trinida and Tobago</option>");
			out.println("            <option value=\"Tunisia\">Tunisia</option>");
			out.println("            <option value=\"Turkey\">Turkey</option>");
			out.println("            <option value=\"Turkmenistan\">Turkmenistan</option>");
			out.println("            <option value=\"Tuvalu\">Tuvalu</option>");
			out.println("            <option value=\"US Virgin Islands\">US Virgin Islands</option>");
			out.println("            <option value=\"Uganda\">Uganda</option>");
			out.println("            <option value=\"Ukraine\">Ukraine</option>");
			out.println("            <option value=\"United Arab Emirates\">United Arab Emirates</option>");
			out.println("            <option value=\"United Kingdom\">United Kingdom</option>");
			out.println("            <option value=\"United States of America\">United States of America</option>");
			out.println("            <option value=\"Uruguay\">Uruguay</option>");
			out.println("            <option value=\"Uzbekistan\">Uzbekistan</option>");
			out.println("            <option value=\"Vanuatu\">Vanuatu</option>");
			out.println("            <option value=\"Vatican City\">Vatican City</option>");
			out.println("            <option value=\"Venezuela\">Venezuela</option>");
			out.println("            <option value=\"Vietnam\">Vietnam</option>");
			out.println("            <option value=\"Wales\">Wales</option>");
			out.println("            <option value=\"West Bank\">West Bank</option>");
			out.println("            <option value=\"Western Samoa\">Western Samoa</option>");
			out.println("            <option value=\"Yemen\">Yemen</option>");
			out.println("            <option value=\"Yugoslavia\">Yugoslavia</option>");
			out.println("            <option value=\"Zaire\">Zaire</option>");
			out.println("            <option value=\"Zambia\">Zambia</option>");
			out.println("            <option value=\"Zimbabwe\">Zimbabwe</option>");
			out.println("");
			out.println("</SELECT><br>&nbsp;</TD></TR>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>Telephone:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"10\" maxlength=10 name=\"phone\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>Fax:</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"10\" maxlength=10 name=\"fax\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("");
			out.println("<TR><TD width=\"8\">&nbsp;</TD>");
			out.println("<TD width=\"142\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">");
			out.println("                <b>Field*</b></FONT></TD>");
			out.println("<TD width=8 bgcolor=\"#87cefa\">&nbsp;</TD>");
			out.println("<TD bgcolor=\"#87cefa\" width=\"292\"><BR CLEAR=\"ALL\"><font face=\"Arial, sans-serif\" COLOR=\"#000000\" size=\"-1\">&nbsp;<br>");
			out.println("             <input type=\"text\" size=\"10\" maxlength=10 name=\"field\"><br>&nbsp;");
			out.println("</TD>");
			out.println("</TR>");
			out.println("");
			out.println("");
			out.println("</TABLE>");
			out.println("</TD></TR></TABLE>");
			out.println("<br>");
			out.println("<p>");
			out.println("<br>");
			out.println("<p>");
			out.println("");
			out.println("<!-- end body -->");
			out.println("&nbsp;</td></tr></table>");
			out.println("");
			out.println("<br>");
			out.println("<p>");
			out.println("<hr>");
			out.println("<p>");
			out.println("<center>");
			out.println("");
			out.println("<TABLE width=\"200\" CELLPADDING=\"0\" CELLSPACING=\"0\" BORDER=\"0\">");
			out.println("<TR><TD><input type=\"submit\" name=\"SEND\" value=\"Submit\"></TD>");
			out.println("<TD width=\"50\">&nbsp;</TD><TD><input type=\"reset\" name=\"RESET\" value=\"Clear\"></TD></TR></TABLE><br>");
			out.println("</center>");
			out.println("</TD></TR>");
			out.println("</form>");
			out.println("");
			out.println("<table width=\"760\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
			out.println("<tr bgcolor=\"#000000\">");
			out.println("<td width=\"760\">&nbsp;</td></tr>");
			out.println("</table>");
			out.println("</body>");
			out.println("</html>");
			out.println("		");
			out.println("");
			out.println("				");
			out.close();
		}
		catch(IOException ioe)
		{ 
			System.out.println("Can't write onto file");
		}
	}

	private static void makeStyle() {
		 FileWriter fw = null;
		 PrintWriter out = null;
		 try
		 {
			  	fw = new FileWriter(Config._HTML_REPOSITORY+"Style.css");
			    out = new PrintWriter(fw);
				out.println(".STDTABLE");
				out.println("{");
				out.println("	border: 0;");
				out.println("	cellspacing: 0;");
				out.println("	cellpadding: 0; ");
				out.println("}");
				out.println("");
				out.println(".BANNER");
				out.println("{");
				out.println("	font-family:\"Verdana\";");
				out.println("	font-variant:sans-serif;");
				out.println("	color:#000000;");
				out.println("}");
				out.println("");
				out.println(".TITLEFONT");
				out.println("{");
				out.println("	font-family:\"Arial\";");
				out.println("	font-variant:sans-serif;");
				out.println("	color:#000080;");
				out.println("}");
				out.println("   ");
				out.println(".TDFONT");
				out.println("{");
				out.println("	font-family:\"Arial\";");
				out.println("	font-variant:sans-serif;");
				out.println("	color:#000000;");
				out.println("}");
				out.close();
		 }
		catch(IOException ioe)
		{ 
			System.out.println("Can't write onto file");
		}
	}

	private static void makeEventInit()
	{
	        FileWriter fw = null;
		PrintWriter out = null;
	  	try
		{
			fw=new FileWriter(Config._HTML_REPOSITORY+"EventInitialize.html");
			out=new PrintWriter(fw);
		  	
			out.println("<html><head><title>Initialize Your Conference</title>");
		  	out.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"http://"+Config._HTMLROOT+"Style.css\">");
		  	out.println("</head> ");
		  	out.println("");
		  	out.println("<body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
		  	out.println("");
		  	out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		  	out.println("");
		  	out.println("<tr bgcolor=#000080>");
		  	out.println("<td width=150>&nbsp;</td>");
		  	out.println("<td width=610> &nbsp;</td> </tr>");
		  	out.println("");
		  	out.println("<tr bgcolor=#000080>");
		  	out.println("<td width=150>&nbsp;</td>");
		  	out.println("<td width=610> &nbsp;</td> </tr>");
		  	out.println("");
		  	out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td>");
		  	out.println("    <td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr>");
		  	out.println("");
		  	out.println("</table>");
		  	out.println("");
		  	out.println("<table width=760 border=0 cellspacing=0 cellpadding=0>");
		  	out.println("<tr valign=top>");
		  	out.println("<td width=150 bgcolor=#000080>");
		  	out.println("  <table width=150 border=0 cellspacing=0 cellpadding=0>");
		  	out.println("  <tr><td width=150 colspan=3></td></tr>");
		  	out.println("  <tr><td width=150 colspan=3></td></tr>");
		  	out.println("  </table><br>");
		  	out.println("");
		  	out.println("");
		  	out.println("<form action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/EventInitialize\">");
		  	out.println("");
		  	out.println("<td width=610>");
		  	out.println(" ");
		  	out.println("   <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		  	out.println("   <TR><TD width=8>&nbsp;</TD></tr>");
		  	out.println("   <TR><TD width=10> &nbsp; </td> ");
		  	out.println("      <TD><font class=TITLEFONT size=4 color=000080><b>Enter Conference Information </b></font><p><br></td></tr>");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td><font class=TDFONT size=2>Please enter the number of hotels, programs, events and affiliations of relevance to your conference.</font>   ");
		  	out.println("		</td></tr>");
		  	out.println("   </table>	");
		  	out.println("<p>  ");
		  	out.println("");
		  	out.println("     <TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%>");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60><font size=2 class=TDFONT><b>HOTELS</b></font></td>");
		  	out.println("	   <td width=70> ");
		  	out.println("	       <font class=TDFONT size=\"1\">");
		  	out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"noofhotels\"></td></tr>");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60><font size=2 class=TDFONT><b>PROGRAMS</b></font></td>");
		  	out.println("	   <td width=70> ");
		  	out.println("	       <font class=TDFONT size=\"1\">");
		  	out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"noofprograms\"></td></tr>");
		  	out.println("   ");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60><font size=2 class=TDFONT><b>EVENTS</b></font></td>");
		  	out.println("	   <td width=70> ");
		  	out.println("	       <font class=TDFONT size=\"1\">");
		  	out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"noofevents\"></td></tr>");
		  	out.println("");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60><font size=2 class=TDFONT><b>AFFILIATIONS</b></font></td>");
		  	out.println("	   <td width=70> ");
		  	out.println("	       <font class=TDFONT size=\"1\">");
		  	out.println("		         <input type=\"text\" size=\"30\" maxlength=50 name=\"noofaffiliations\"></td></tr>");
		  	out.println("");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60>&nbsp;</td>");
		  	out.println("	   <td width=70> &nbsp;</td></tr>");
		  	out.println("");
		  	out.println("   <tr><td width=10>&nbsp;</td>");
		  	out.println("       <td width=60>&nbsp;</td>");
		  	out.println("	   <td width=70> <input type=\"submit\" name=\"Submit\" value=\"submit\"></td>");
		  	out.println("</tr>");
		  	out.println("");
		  	out.println("");
		  	out.println("   ");
		  	out.println("	<tr><td>");
		  	out.println("");
		  	out.println("          <br><br><br><br><br><br><br>");
		  	out.println("          </td></tr>");
		  	out.println("   </table>");
		  	out.println("   </td>");
		  	out.println("</table> ");
		  	out.println("");
		  	out.println("<table width=760> ");
		  	out.println("<tr bgcolor=#000000><td width=760>&nbsp;</td></tr>");
		  	out.println("</table>");
		  	out.println("<font size=2><center>Copyright &copy 2000 All Rights Reserved.</center>");
		  	out.println("</font>");
		  	out.println("</body>");
		  	out.println("</html>");
			out.close();
		}
		catch(IOException ioe)
		{ 
			System.out.println("Can't write onto file");
		}
	}
	
	private static void fileCopy(File fsrc, String fdest)
	{
		try
		{
			FileInputStream instr=new FileInputStream(fsrc);
			FileOutputStream outstr=new FileOutputStream(new File(fdest));
			int b1=instr.read();
			while(b1!=-1)
			{
				outstr.write(b1);
				b1=instr.read();
			}
		} 
		catch (IOException ioe) 
		{
		}
	}

	/** This function copies all class files required to be in HTML_REPOSITORY
	 * to run the Applet */
	private static void makeAppletFiles() {
	  File utilDir=new File(Config._HTML_REPOSITORY+"util");
	  utilDir.mkdirs();
	  File config=new File("util"+File.separatorChar+"Config.class");
	  String newConfig=Config._HTML_REPOSITORY+"util"+File.separatorChar+"Config.class";
	  fileCopy(config, newConfig);  
	  
	  File applet=new File("servlets"+File.separatorChar+"AssignApplet.class");
	  String newApplet=Config._HTML_REPOSITORY+"AssignApplet.class";
	  fileCopy(applet, newApplet);

	  applet=new File("servlets"+File.separatorChar+"AssignApplet$HttpMessage.class");
	  newApplet=Config._HTML_REPOSITORY+"AssignApplet$HttpMessage.class";
	  fileCopy(applet, newApplet);

	}

}
