import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet is the interface for the PC Chair (Admin)
 *  It provides the PC Chair with all the interfaces required in the process.
 *
 *  @author Aameek Singh
 *  @version 1.00, Sun Nov 12 16:54:31 IST 2000
 */

public class AdminServlet extends HttpServlet {
     
	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Present all the related info and links to perform various operation 
	  * @param res HttpServletResponse
	  * @param req HttpServletRequest
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(false);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity. Only admin allowed */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  Connection con=null;
		  String ID=(String)session.getValue("ID");

		  try {
			   con=DB.getConnection();

		       ShowStuff.printHeader("Welcome!",out);

			   /* Links for various interfaces for the admin */
			   out.println("<p><table width=360 border=0 cellspacing=0 cellpadding=0>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailServlet\">Send Mail</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/CreateMailingList\">Create Mailing List</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AddReviewer\">Add Reviewers</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AllPapers\">Papers' Information</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ShiftDeadline\">Shift Deadlines</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HTMLROOT+"TakeRevParam.html\">Insert/Update Review Parameters</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HTMLROOT+"chrevpsw.html\">Change Reviewer/Author Password</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Tentative\">Assign Papers to Reviewers</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MarkAssigned\">Mark Assigned</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/SelectPaper\">Accept/Reject Papers</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HTMLROOT+"EventInitialize.html\">About hotels, events, programs ...</a></td></tr>");
			   out.println("</table>");
			   out.println("<p><hr><br><font class=TITLEFONT size=3 color=blue>New Messages</font><br>");
			   out.println("<table width=600 border=0 cellspacing=1 cellpadding=1>");

			   /* Reading New Messages */
			   Statement st=con.createStatement();
			   String query="SELECT CONTENT,POSTEDBY,POSTINGDATE,MESSAGE.MESGID FROM MESSAGE, NEWMESSAGE WHERE (MESSAGE.PAPERID=0) AND (MESSAGE.MESGID=NEWMESSAGE.MESGID) AND (NEWMESSAGE.ID='"+ID+"')";
			   
			   ResultSet rs=st.executeQuery(query); 
			   ResultSetMetaData rt=rs.getMetaData();
			   Stack newMsgId=new Stack();
			   out.println("<tr><font class=TDFONT size=2><td width=85>Posted By</td><td width=85>Date of Posting</td><td width=450>Message</td></font></tr>");
			   while (rs.next()) {
					newMsgId.push(rs.getString(4));   /* Put MesgId in stack */
					out.println("<tr><font class=TDFONT size=1><td width=50> "+rs.getString(2)+" </td><td width=50> "+rs.getString(3)+" </td><td width=500> "+rs.getString(1)+" </td></font></tr>");
			   }

			   out.println("</table><p>");
			   
			  if (newMsgId.empty()) {
				out.println("<table width=600 border=0 cellspacing=1 cellpadding=1><tr><td><font size=2 class=TITLEFONT>No New Messages</font></td></tr></table><p><br>");

			  } else {    /* The read messages are then deleted from NEWMESSAGES table */
					String delStatement="DELETE FROM NEWMESSAGE WHERE (ID='"+ID+"') ";
					int i=0;
					String tmp="";
					while (!newMsgId.empty()) {
						 i++;
						 if (i==1) {
							  tmp+=" (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 } else {
							  tmp+=" OR (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 }
					}
					if (i==1) {
						 delStatement+=" AND "+tmp;
					} else {
						 delStatement+=" AND ("+tmp+" )";
					}
					st.executeUpdate(delStatement);
			   }
               
			   ShowStuff.formTag("get","http://"+Config._HOST+":"+Config._PORT+"/servlet/PostMessage",out);
	
			   /* Other interfaces */
			   out.println("<hr><br><table width=600 border=0 cellspacing=0 cellpadding=0>");
			   out.println("<tr><td><font class=TITLEFONT size=3 color=blue>Post A Message</font></td></tr>");
			   out.println("<tr><td><select name=\"towhom\">");
			   out.println("<option value=\"0\"><font class=TDFONT size=1>Post to all PC members</font></option>");
			   out.println("<option value=\"1\"><font class=TDFONT size=1>Post to reviewers of a specific paper</font></option>");
			   out.println("</select></td></tr><tr><td>");
			   ShowStuff.textBox("paperId",10,out);
			   out.println("</td></tr><tr><td>");
			   ShowStuff.submitButton("Post",out);
			   out.println("</td></tr></table></form>");
		        out.println("<br>");
			   out.println("<hr size=1><br><p>");

			   ShowStuff.formTag("get","http://"+Config._HOST+":"+Config._PORT+"/servlet/EditMailingList",out);
               out.println("<table width=600 border=0 cellspacing=0 cellpadding=0>");
			   out.println("<tr><td><font class=TITLEFONT size=3 color=blue>Edit Mailing Lists</font></td></tr>");
               out.println("<tr><td>");			   
			   ShowStuff.textBox("ListId",10,out);
			   out.println("</td></tr><tr><td>");
			   ShowStuff.submitButton("Edit",out);
			   out.println("</td></tr></table></form>");
					
			   ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/QueryReviewer",out);
			   out.println("<h2>Some standard queries for Reviewers and Papers</h2>");
			   
			   out.println("<table>");
			   out.println("<tr><td><input type=\"radio\" value=\"0\" name=\"query\" CHECKED> Give the paperId whose details you want in the text box (blank gives u the details of all papers)</td>");
			   out.println("<td><input type=\"text\" size=\"5\" name=\"paperid0\"> </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"1\" name=\"query\"> Give the paperId whose authors you want to know (blank gives the list for all papers) </td>");
			   out.println("<td><input type=\"text\" size=\"5\" name=\"paperid1\"> </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"2\" name=\"query\"> Give the paperId whose contact author you want to know (blank gives the list for all papers) </td>");
			   out.println("<td><input type=\"text\" size=\"5\" name=\"paperid2\"> </td></tr>");
			   out.println("<tr><td><input type=\"radio\"value=\"3\" name=\"query\"> List of emails of all Reviewers </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"4\" name=\"query\"> List of emails, names and fields of all Reviewers </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"5\" name=\"query\"> Details of each review submitted by the reviewers (like paperid, papername, ratings etc.)  </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"6\" name=\"query\"> Details of all papers for which there is clash (paperid, papername, stddeviation) </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"7\" name=\"query\"> Details of the paperids, titles and authors of acceptedpapers </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"8\" name=\"query\"> List of all final assignments </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"9\" name=\"query\"> List of tentative assignments </td></tr>");
			   out.println("<tr><td><input type=\"radio\" value=\"10\" name=\"query\"> List of all the bids put by the reviewers </td></tr>");
			   out.println("</table>");
			   ShowStuff.submitButton("Submit",out);
			   out.println("</form>");

			   out.println("<table>");
			   ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/StandardQuery",out);
			   out.println("<h2> Some standard queries for Participants </h2>");
			   
			   out.println("<tr><td><input type= \"radio\" value=\"0\" name = \"query\" CHECKED> List of the emails of all the participants </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"1\" name = \"query\"> List of the emails and names of all the participants </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"2\" name = \"query\"> List of personal details (name, address, phone and fax) of all participants </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"3\" name = \"query\"> List of all participants with their emails, name on tag, affiliation on tag and institution on tag</td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"4\" name = \"query\"> List of emails of the participants and the hotel that they have been allotted</td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"5\" name = \"query\"> List of booking details of all the participants like the hotel, roomtype, check in date and check out date</td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"6\" name = \"query\"> List of the participants (with their emails, names) and the details of the programs (program Id, program name) that they are attending </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"7\" name = \"query\"> List of the participants (with their emails, names) and the details of the events (event Id, event name) that they are attending </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"8\" name = \"query\"> List of the participants along with their payment status (whether they have done it or not) </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"9\" name = \"query\"> List of the participants along with their payment details (like the amount, currency and payment mode) </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"10\" name = \"query\"> List of the participants who have made payments thro' cheques and also the complete details of the concerned payment (like cheque no, bank no etc) </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"11\" name = \"query\"> List of the participants who have made payments thro' credit cards and also the complete details of the concerned payment (like credit card no, type etc) </td></tr>");
			   out.println("<tr><td><input type= \"radio\" value=\"12\" name = \"query\"> List of the participants who have made payments thro' demand drafts and also the complete details of the concerned payment (like dd no, bank no etc) </td></tr>");
			   out.println("</table>");
			   ShowStuff.submitButton("Query",out);
			   out.println("</form>");
			   
			   out.println("<h3> <a href=http://"+Config._HTMLROOT+"ParticipantQuery.html> click here </a> for executing any general query about Participants</h3>");
			   
               ShowStuff.printFooter(out);
			   con.close();
		  } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) {con =null; } }
	 }
}
