import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet displays all papers along with the PaperId's and other
 * info.Takes care of blindness as well.
 *
 * @author Aameek Singh
 * @version 1.00, Mon Oct  2 01:02:29 IST 2000
 */

public class AllPapers extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Displays all papers along with Ids
	  * @param req HttpServletRequest
	  * @param req HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin or Reviewer only.*/
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("reviewer") || whoisit.equalsIgnoreCase("admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");   /* Id of the user */

		  Connection con=null;
		  try {
			   /* Open a DB Connection */
			   con=DB.getConnection(); 

			   ShowStuff.printHeader("Papers",out);
			   out.println("<body>");

			   out.println("<table>");

			   Statement st=con.createStatement();
			   ResultSet rs;
			   String query;
			   int paperId=0;
			   java.util.Date PresentDate=new java.util.Date();
			   rs=st.executeQuery("SELECT * FROM FLAG");

			   if ((rs.next()) && (Integer.parseInt(rs.getString(1))==0) ) 
			   {
					if (Config._BLINDNESS==1) {
						 out.println("<tr><th>PaperID</th><th>Title</th><th>Category</th><th>Abstract</th></tr>");
						 query="SELECT DISTINCT PAPERID,TITLE,CATEGORY FROM PAPER";
						 rs=st.executeQuery(query);
						 while(rs.next())
						 {
							  paperId = Integer.parseInt(rs.getString(1));
							  out.println("<tr><td>"+paperId+"</td><td>"+rs.getString(2)+"</td><td>"+rs.getString(3)+"</td>");
							  out.println("<td> <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/GetAbstract?paperId="+paperId+"\">Abstract</a> </td>");
							  out.println("</tr>");
						 }
					} else {
						 out.println("<tr><th>PaperID</th><th>Title</th><th>Category</th><th>Abstract</th><th>Authors</th></tr>");
						 query="SELECT PAPER.PAPERID,TITLE,CATEGORY,EMAIL FROM PAPER,AUTHOREDBY WHERE PAPER.PAPERID=AUTHOREDBY.PAPERID";
						 rs=st.executeQuery(query);
						 int oldPaperId=-1;
						 String output="";
						 while(rs.next())
						 {
							  paperId = Integer.parseInt(rs.getString(1));
							  if (oldPaperId != paperId) {
								   if (oldPaperId!=-1) {
										out.println(output);
										out.println("</td></tr>");
								   }
								   output="<tr><td>"+paperId+"</td><td>"+rs.getString(2)+"</td><td>"+rs.getString(3)+"</td><td> <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/GetAbstract?paperId="+paperId+"\">Abstract</a> </td><td>"+rs.getString(4);
							  } else {
								   output+=","+rs.getString(4);
							  }
							  oldPaperId=paperId;
						 }
						 out.println(output);
						 out.println("</td></tr>");

					}
			   } 
			   else 
			   {
					out.println("<tr><th>PaperID</th><th>Title</th><th>Category</th><th>Abstract</th><th>ReviewerID</th></tr>");
					query="SELECT DISTINCT PAPER.PAPERID,TITLE,CATEGORY,EMAIL FROM PAPER,ACCEPTEDPAPER,FINALASSIGNMENTS WHERE (PAPER.PAPERID=ACCEPTEDPAPER.PAPERID) AND (PAPER.PAPERID=FINALASSIGNMENTS.PAPERID)";
					rs = st.executeQuery(query);

					//The paperReviewer hashtable contains reviewer ids delimited by a comma 
					//along with the paperId..  The otherAttr contains the title,
					//category along with a particular paperId.

					Hashtable paperReviewer = new Hashtable();
					Hashtable otherAttr = new Hashtable();
					Enumeration papers;
					String reviewerString=""; //This is the String which has till now been inserted.
					String attrString;
					while(rs.next())
					{
						 paperId = Integer.parseInt(rs.getString(1));
						 papers = otherAttr.keys();
						 if (exists(new Integer(paperId),papers))
						 {
							  reviewerString = (String) paperReviewer.get(new Integer(paperId));
							  reviewerString += ", "+rs.getString(4);
							  paperReviewer.put(new Integer(paperId), reviewerString);
						 }
						 else
						 {
							  attrString = "<tr><td>"+paperId+"</td><td>"+rs.getString(2)+"</td><td>"+rs.getString(3)+"</td>";
							  otherAttr.put(new Integer(paperId), attrString);
							  paperReviewer.put(new Integer(paperId),rs.getString(4));
						 }
					}
					Integer currPaper;
					papers = paperReviewer.keys();
					while(papers.hasMoreElements())
					{
						 currPaper = (Integer)papers.nextElement();
						 attrString = (String) otherAttr.get(currPaper);
						 out.println(attrString);
						 out.println("<td> <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/GetAbstract?paperId="+paperId+"\">Abstract</a> </td>");
						 out.println("<td>"+paperReviewer.get(currPaper)+"</td>");
						 out.println("</tr>");
					}
			   }
			   out.println("</table><br><br><br><br><hr size=1><br>");
			   ShowStuff.printFooter(out);
			   con.close();

		  } catch (SQLException e) { System.out.println(e); ShowStuff.throwError("Database Access Error",out); if (con != null) { con=null;} }
	 }

	 private boolean exists(Integer elmt, Enumeration e)
	 {
		  Integer currPaper;
		  while(e.hasMoreElements())
		  {
			   currPaper = (Integer)e.nextElement();
			   if (currPaper.equals(elmt))
					return(true);
		  }
		  return(false);
	 }
}
