import java.awt.*;
import java.applet.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import java.util.*;

import util.*;

public class AssignApplet extends Applet implements ActionListener 
{
	 private Panel paperp=null, reviewerp=null, submitp=null;
	 private Hashtable currassign=null;
	 private Hashtable finalassign=null;
	 private Vector allrev=null;

	 /* These map the button and textfield objects to the paperId string. */
	 private Hashtable addbuttons=null, removebuttons=null, tfields=null, tareas=null;
	 private Hashtable plabels=null, rlabels=null;
	 private Hashtable revPapernum=null;
	 private Hashtable revnum=null;
	 private Hashtable revnum2=null;

	 //	private Vector papervec = null; //reqd to always print the row 
	 // corresponding to a paper in same position	
	 private String currentp=null; // after an update only areas corresponding to currentp are updated
	 private String currentr=null; //only label corresponding to the current rev is updated.

	 private boolean add, remove;
	 public void init()
	 {
		  System.out.println("applet");
		  setBackground(Color.white);

		  /* get currentassignment values */
		  try 
		  {
			   URL url=new URL("http://"+Config._HOST+":"+Config._PORT+"/servlet/AssignPapers");
			   HttpMessage msg=new HttpMessage(url);

			   InputStream in = msg.sendGetMessage();
			   ObjectInputStream result=new ObjectInputStream(in);
			   Object obj=result.readObject();
			   currassign = (Hashtable)obj;

			   int numpapers = Integer.parseInt((String)currassign.get("Count"));
			   allrev = (Vector)currassign.get("All");
			   currassign.remove("All");
			   currassign.remove("Count");

			   //			   paperp = new Panel(new GridLayout());
			   int spacing1=((500/numpapers-50)>0)?(500/numpapers-50):10;			   
			   int spacing2=((500/allrev.size()-50)>0)?(500/allrev.size()-50):10;			   
			   paperp = new Panel(new GridLayout(numpapers,5,10,spacing1));
			   //			   paperp = new Panel(new GridLayout(10,5));
			   //			   reviewerp = new Panel(new GridLayout(10,1));
			   reviewerp = new Panel(new GridLayout(allrev.size(),1,10,spacing2));
			   //			   reviewerp = new Panel(new GridLayout());

			   submitp=new Panel();
			   Button submit = new Button("Submit");
			   submit.addActionListener(this);
			   submitp.add(submit);


			   Enumeration papers = currassign.keys();

			   addbuttons=new Hashtable();
			   removebuttons=new Hashtable();
			   tfields=new Hashtable();
			   tareas=new Hashtable();
			   plabels=new Hashtable();
			   rlabels=new Hashtable();
			   revPapernum = new Hashtable();

			   Button addbut=null;
			   Button removebut=null;
			   TextField tf=null;
			   TextArea ta=null;
			   Label paperlab=null;
			   String currpaper=null;
			   Vector revvec=null;
			   String currrev=null;

			   String Revs="";

			   add=false;
			   remove=false; //made true when the button is pressed

			   finalassign=new Hashtable();

			   Label revlab=null;
			   revnum = new Hashtable();
			   revnum2 = new Hashtable();

			   for(int i=0; i<allrev.size(); i++)
			   {
					currrev = (String)allrev.elementAt(i);
					revnum2.put(currrev,i+"");
			   }

			   while(papers.hasMoreElements())
			   {
					currpaper=(String)papers.nextElement();
					revvec = (Vector)currassign.get(currpaper);

					finalassign.put(currpaper, revvec);
					String revstring="";
					Revs="";

					for (int i=0; i<revvec.size(); i++)
					{
						 currrev = (String)revvec.elementAt(i);
						 if (i==revvec.size()-1) {
							  revstring+=currrev;
							  Revs+=revnum2.get(currrev);
						 } else {
							  revstring+=currrev+"\n";
							  Revs+=revnum2.get(currrev)+", ";
						 }
						 if(revPapernum.containsKey(currrev))
						 {
							  revPapernum.put(currrev, new Integer(((Integer)revPapernum.get(currrev)).intValue() + 1));
						 }
						 else
						 {
							  revPapernum.put(currrev, new Integer(1));
						 }
					}	


					paperlab = new Label(currpaper+" ("+ revvec.size() +") ");
					paperp.add(paperlab);
					plabels.put(currpaper, paperlab);

					addbut=new Button("Add");
					addbut.addActionListener(this);
					paperp.add(addbut);
					addbuttons.put(addbut, currpaper);

					removebut=new Button("Remove");
					removebut.addActionListener(this);
					paperp.add(removebut);
					removebuttons.put(removebut, currpaper);

					tf=new TextField(5);
					tf.addActionListener(this);
					paperp.add(tf);
					tfields.put(tf, currpaper);

					ta=new TextArea(Revs,2, 10,TextArea.SCROLLBARS_NONE);
					ta.setEditable(false);
					paperp.add(ta);
					tareas.put(currpaper, ta);

					/*					ta=new TextArea(revstring,2, 10,TextArea.SCROLLBARS_BOTH);
										ta.setEditable(false);
										paperp.add(ta);
										tareas.put(currpaper, ta);*/
			   }

			   /*   Label revlab=null;
					revnum = new Hashtable();
				*/
			   for(int i=0; i<allrev.size(); i++)
			   {
					currrev = (String)allrev.elementAt(i);
					Integer noOfPap=(Integer)revPapernum.get(currrev);
					String tmp="";
					if (noOfPap==null) { 
						 tmp="0";
						 revPapernum.put(currrev,new Integer(0));

					} else {
						 tmp=noOfPap.toString();
					}

					revlab=new Label(i+":= " +currrev+"("+tmp+")");
					rlabels.put(currrev, revlab);
					revnum.put(i+"", currrev);
					reviewerp.add(revlab);
			   } 
		  }
		  catch (UnknownHostException uhe)
		  {
			   System.out.println("Host not found");
			   System.exit(1);
		  }
		  catch (StreamCorruptedException sce)
		  {
			   System.out.println("Stream problem");
			   System.exit(1);
		  }

		  catch (IOException ioe)
		  {
			   ioe.printStackTrace();
			   System.out.println("IO problem ");
			   System.exit(1);
		  }
		  catch (Exception e)
		  {
			   e.printStackTrace();
			   System.out.println(e);
			   System.exit(1);
		  }

		  // this.setLayout(new GridLayout(2,1));
		  this.setLayout(new BorderLayout());
		  this.add(reviewerp,BorderLayout.EAST);
		  this.add(paperp,BorderLayout.WEST);
		  this.add(submitp,BorderLayout.SOUTH);

	 }

	 public void actionPerformed(ActionEvent ae)
	 {

		  if (ae.getSource() instanceof Button)
		  {
			   if (ae.getActionCommand().equals("Submit"))
			   {
					try
					{
						 URL url2=new URL ("http://"+Config._HOST+":"+Config._PORT+"/servlet/AssignPapers");
						 HttpMessage msg2=new HttpMessage(url2);
						 InputStream in=msg2.sendPostMessage(finalassign);

						 /* Close the applet window */
						 this.hide();
					}
					catch(IOException ioe)
					{
						 System.out.println("IO");
						 System.exit(1);
					}
			   }

			   if (ae.getActionCommand().equals("Add"))
			   {
					add=true;
					remove=false;
					currentp=(String)addbuttons.get((Button)ae.getSource());
			   }

			   if (ae.getActionCommand().equals("Remove"))
			   {
					remove=true;
					add=false;
					currentp=(String)removebuttons.get((Button)ae.getSource());
			   }
		  }
		  else if (ae.getSource() instanceof TextField)
		  {
			   if(!add && !remove)
					showStatus("Press the Add or Remove Button first.");
			   else 
			   {
					showStatus("");

					TextField tf=(TextField) ae.getSource();
					if (!((String)tfields.get(tf)).equals(currentp))
						 showStatus("Press the *Correct* button or write in the correct field!!");
					else 
					{
						 showStatus("");
						 String value=tf.getText();
						 tf.setText("");
						 try
						 {
							  int valueint=Integer.parseInt(value);
							  if ((valueint<0) || (valueint>=allrev.size()))
								   showStatus("Please write the integer value from the provided range.");
							  else  
							  {
								   showStatus("");
								   String currentr = (String)revnum.get(value);
								   Vector revlist=(Vector)finalassign.get(currentp);
								   if (add)
								   {
										if (!revlist.contains(currentr))
										{
											 revlist.addElement(currentr);
											 revPapernum.put(currentr, new Integer(((Integer)revPapernum.get(currentr)).intValue() + 1));
											 add=false;
											 showStatus("");
										}
										else
											 showStatus("Reviewer "+currentr+" is already assigned to paper "+currentp+".");

								   }
								   else if (remove)
								   {
										boolean found=revlist.removeElement(currentr);
										remove=false;
										if (found) {
											 revPapernum.put(currentr, new Integer(((Integer)revPapernum.get(currentr)).intValue() - 1));
											 showStatus("");
										} else {
											 showStatus("Reviewer "+currentr+" was not assigned even earlier!!");
										}
								   }  
								   finalassign.put(currentp, revlist);
								   Label paperlab = (Label)plabels.get(currentp);  
								   paperlab.setText(currentp +" ("+revlist.size()+") ");	  
								   plabels.put(currentp, paperlab);
								   Label revlab = (Label)rlabels.get(currentr);
								   revlab.setText(value+":= "+currentr+" ("+(Integer)revPapernum.get(currentr)+")");
								   rlabels.put(currentr, revlab);


								   TextArea ta = (TextArea)tareas.get(currentp);
								   String revstring="";
								   for (int i=0; i<revlist.size(); i++)
								   {
										if (i==revlist.size()-1)
											 revstring+=revnum2.get((String)revlist.elementAt(i));
										else
											 revstring+=revnum2.get((String)revlist.elementAt(i))+", ";
								   }
								   ta.setText(revstring); 
							  }     
						 }	  
						 catch(NumberFormatException nfe)
						 {
							  showStatus("Please write the integer value from the provided range.");
						 }  

					}
			   }

		  }
	 }	
/** This class files allow the applet to communicate to the servlet
 *  It can simulate POST/GET methods on a servlet
 *
 *  @author Aameek Singh
 *  @version 1.00, Sun Nov 12 17:11:42 IST 2000
 */

class HttpMessage {
	 URL servlet = null;
	 String args = null;

	 /** Constructor 
	  *  @param servlet URL
	  */
	 public HttpMessage(URL servlet) {
		  this.servlet=servlet;
	 }

	 /**
	  * GET request with zero arguments 
	  */
	 public InputStream sendGetMessage() throws IOException {
		  return sendGetMessage(null);
	 }

	 /** GET request with arguments
	  *  @param args Properties  Contains the parameters to be submitted
	  *  with the GET request
	  */
	 public InputStream sendGetMessage(Properties args) throws IOException {
		  String argString="";
		  if (args != null) {
			   argString="?"+toEncodedString(args);
		  }
		  URL url=new URL(servlet.toExternalForm()+argString);
		  URLConnection con=url.openConnection();
		  con.setUseCaches(false);
		  InputStream res=con.getInputStream();
		  return res;
	 }

	 /** POST request with zero arguments 
	  */
	 public InputStream sendPostMessage() throws IOException {
		  return sendPostMessage(null);
	 }

	 /** POST request with posting a serializable object 
	  * @param obj Serializable The object to be posted
	  */
	 public InputStream sendPostMessage(Serializable obj) throws IOException {
		  URLConnection con=servlet.openConnection();
		  con.setDoInput(true);
		  con.setDoOutput(true);
		  con.setUseCaches(false);
		  con.setRequestProperty("Content-Type","java-internal/"+obj.getClass().getName());
		  ObjectOutputStream out=new ObjectOutputStream(con.getOutputStream());
		  out.writeObject(obj);
		  out.flush();
		  out.close();
		  return con.getInputStream();
	 }

	 /** POST request with a string to be posted 
	  *  @param args Properties Contains the parameters to be posted
	  */
	 public InputStream sendPostMessage(Properties args) throws IOException {
		  String argString="";
		  if (args != null) {
			   argString=toEncodedString(args);
		  }

		  URLConnection con=servlet.openConnection();

		  con.setDoInput(true);
		  con.setDoOutput(true);

		  con.setUseCaches(false);

		  con.setRequestProperty("Content-Type","application/x-www-form-urlencoded");

		  DataOutputStream out=new DataOutputStream(con.getOutputStream());
		  out.writeBytes(argString);
		  out.flush();
		  out.close();
		  return con.getInputStream();
	 }

	 /** Converts a Properties obj to the corresponding String
	  * @param args Properties
	  */
	 private String toEncodedString(Properties args) {
		  StringBuffer buf=new StringBuffer();
		  Enumeration names=args.propertyNames();
		  while (names.hasMoreElements()) {
			   String name=(String)names.nextElement();
			   String value=args.getProperty(name);
			   buf.append(URLEncoder.encode(name)+"="+URLEncoder.encode(value));
			   if (names.hasMoreElements()) buf.append("&");
		  }
		  return buf.toString();
	 }
}
}
