import java.io.*;
import java.util.*;
import java.lang.*;
import java.sql.*;
import util.*;


/** This class will be used to assign papers to reviewers on the basis of their 
 * bids which are stored in the table Bids. 
 *
 * @author 		Anjali Gupta
 * @version     1.00, Thu Nov  9 21:07:59 IST 2000
 */

class AssignReviewers
{ 

	 /** This is the function which will accomplish the assignments -- all information 
	  * is extracted from the database.
	  */
	 
	 public void assignPapers () 
		  throws SQLException
		  {
			   int Bids[][], Assign[][]; // will keep track of bids and assignments
			   String Reviewers[];       // will keep a mapping from an index to a reviewer. 

			   int RevsPerPaper = Config._REVIEWS_PER_PAPER; // the no of reviews expected per paper.
			   Connection con = DB.getConnection();
			   ResultSet RsRev, RsPap;
			   ResultSetMetaData rsmd;

			   Statement st = con.createStatement();
			   int i=0;
			   int countp=0;  // count of papers
			   int countr=0;  // count of reviewers

			   /* First let us extract all the bids from the Bids table and store them each 
				* according to reviewer in a sorted order */

			   // First get the no of distinct reviewers
			   RsRev = st.executeQuery("SELECT DISTINCT EMAIL FROM BIDS");
			   while (RsRev.next())
			   {
					countr ++;
			   }


			   // get the no of distinct papers - must be in consecutive order of papers.
			   RsPap = st.executeQuery("SELECT DISTINCT PAPERID FROM BIDS");
			   while (RsPap.next())
			   {
					countp ++;
			   }

			   
			   Bids = new int [countr][countp+1];
			   Assign = new int [countr][countp+1];
			   Reviewers  = new String [countr];
			   int RevCount [] = new int [countr];
			   int PapCount [] = new int [countp+1];
			   String reviewer;
			   PreparedStatement prepst=null; 
			   String query;
			   int bid, j=0;
			   i=0;


			   // for each reviewer store the name tagged to an index.
			   // NOTE : for each i, Bids[i][0] stores the index number which will
			   // next be considered/ read. Done for purposes of efficiency.
			   
			   RsRev = st.executeQuery("SELECT DISTINCT EMAIL FROM BIDS");
			   while (RsRev.next())
			   {
					Reviewers[i] = RsRev.getString(1); 
					Bids[i][0] = 1; 
					i++;
			   }

			   // for each reviewer get the bids and store them.
			   for(i=0; i<countr; i++)
			   {
					RsPap=st.executeQuery("SELECT PAPERID, BIDVALUE FROM BIDS WHERE EMAIL='"+Reviewers[i]+"' ORDER BY BIDVALUE DESC");           
					while (RsPap.next())
					{
						 j = Integer.parseInt(RsPap.getString(1));
						 bid = Integer.parseInt(RsPap.getString(2)); 
						 Bids[i][j] = bid;
					}
					i++;
			   }

			   // initialize Assign and PapCount -- PapCount indicates the number of reviewers
			   // already given to the paper.
			   
			   boolean flag=true;
			   int paper=0;
			   for (i=0; i<countr; i++)
			   {
					for (j=0; j<= countp; j++)
					{
						 Assign[i][j] = 0;
					}
			   }

			   for (j=0; j<= countp; j++)
			   {
					PapCount[j] = 0;
			   }


			   // Algo begins:
			  
			   for (int k=0; k <countp; k++)
			   {
					for (i=0; i<countr; i++)
					{
						 paper = Bids[i][0];
						 while ((paper <= countp) && (PapCount[paper] >= RevsPerPaper))
						 {
							  paper++;
						 }
						 if (paper <= countp)
						 {
							  PapCount[paper] = PapCount[paper] + 1;
							  Assign[i][paper]=1;
						 }
						 Bids[i][0] = paper + 1;

					}

			   }

			   for (i=0; i<countr; i++)
			   {
					for (j=1; j<=countp; j++)
					{
						 if (Assign[i][j] == 1)
						 {

							  st.executeUpdate("INSERT INTO TENTATIVEASSIGNMENTS VALUES ("+j+" , '"+Reviewers[i]+"')");
							  st.executeUpdate("INSERT INTO FINALASSIGNMENTS VALUES ("+j+" , '"+Reviewers[i]+"')");
						 }
					}
			   }
		  }
}

