import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import util.*;

/** This servlet is the interface for Authors - all authors have valid logins before the 
 * the deadline for paper submission.
 *
 * @author Anjali Gupta
 * @version 1.00 Mon Nov 13 21:22:02 IST 2000
 */ 

public class AuthorServlet extends HttpServlet 
{

	 /** Initialise the servlet 
	  * @param config ServletConfig
	  */ 

	 public void init(ServletConfig config) throws ServletException 
	 {
		  super.init(config);
	 }


	 /** Present all the related info and links to perform various operations
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse 
	  */ 

	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException,IOException 
		  {
			   HttpSession session=req.getSession(false);
			   res.setContentType("text/html");
			   PrintWriter out=res.getWriter();

			   /* Check session validity. Only authors allowed */

			   String whoisit=(String)session.getValue("whoami");

			   if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("author"))) ) 
			   {
					throw new UnavailableException(this,"Invalid Access Attempt");
			   }

			   Connection con=null;
			   String ID=(String)session.getValue("ID");

			   try {
					con=DB.getConnection();

					ShowStuff.printHeader("Welcome!",out);

					// just print out all the available links
					out.println("<a href=\"http://"+Config._HTMLROOT+"Re-Upload.html\">Re-Upload Paper</a>");
					out.println("<br></br>");
					out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a>");
					out.println("<br></br>");
					out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a>");
					out.println("<br><br>");
					out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Change\">Change Author or Paper Information</a>");

					ShowStuff.printFooter(out);

					con.close();

			   } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) {con =null; } }
		  }

	 /** This function is invoked to change author and paper information - it is invoked from
	  * within the Change class
	  *
	  * @param HttpServletRequest request
	  * @param HttpServletResponse response
	  */ 

	 public void doPost (HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   HttpSession session=request.getSession(false);
			   response.setContentType("text/html");
			   PrintWriter out=response.getWriter();

			   /* Check session validity. Only authors allowed */

			   String whoisit=(String)session.getValue("whoami");

			   if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("author"))) ) 
			   {
					throw new UnavailableException(this,"Invalid Access Attempt");
			   }

			   Connection con=null;
			   String ID=(String)session.getValue("ID");

			   String[] PersonAttributes, AuthorAttributes, PaperAttributes, AuthoredByAttributes;

			   try
			   {    

					con = DB.getConnection();
					ResultSet rs;
					ResultSetMetaData rsmd;
					Statement st = con.createStatement();

					/* Get the names of all columns in person table */

					rs = st.executeQuery("SELECT * FROM PERSON");
					rsmd = rs.getMetaData();
					int NoOfAttributes = rsmd.getColumnCount();
					PersonAttributes = new String[NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PersonAttributes[i] = rsmd.getColumnName(i+1);

					// primary stores, for future reference the column number
					// of the primary key which is EMAIL.

					int primary=0;
					rs = st.executeQuery("SELECT * FROM AUTHOR");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount(); 
					AuthorAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
					{
						 AuthorAttributes[i] = rsmd.getColumnName(i+1);
						 if (AuthorAttributes[i].equalsIgnoreCase("EMAIL"))
							  primary = i;
					}

					String password=""; 
					rs = st.executeQuery("SELECT * FROM PAPER WHERE PAPERID="+ID+" ");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					PaperAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PaperAttributes[i] = rsmd.getColumnName(i+1);
					while (rs.next())
					{
						 for (int i=0; i<NoOfAttributes; i++)
						 {
							  if (PaperAttributes[i].equalsIgnoreCase("Password"))
							  {
								   password = rs.getString(i+1);
							  }
						 }
					}


					rs = st.executeQuery("SELECT * FROM AUTHOREDBY");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					AuthoredByAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 AuthoredByAttributes[i] = rsmd.getColumnName(i+1);

					ShowStuff.printHeader("Changes Done",out);

					PreparedStatement prepst=null; 
					String update="";
					String ContactEmail="";

					// first delete the original entries related to this paper and then 
					// insert the new entries.

					// find the contact author here.

					rs = st.executeQuery("SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID="+ID+"AND ISCONTACT=1");
					while(rs.next())
					{
						 ContactEmail = rs.getString(1);
					}

					st.executeUpdate("DELETE FROM PERSON WHERE EMAIL='"+ContactEmail+"'");

					rs = st.executeQuery("SELECT EMAIL FROM AUTHOR WHERE EMAIL IN (SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID="+ID+")");

					st.executeUpdate("DELETE FROM AUTHOREDBY WHERE PAPERID="+ID);

					while (rs.next())
					{
						 st.executeUpdate("DELETE FROM AUTHOR WHERE EMAIL='"+rs.getString(primary)+"'");
					}

					st.executeUpdate("DELETE FROM PAPER WHERE PAPERID="+ID);

					String NewEmail=request.getParameter("contact-email");

					rs = st.executeQuery("SELECT * FROM PERSON WHERE EMAIL='"+NewEmail+"'");
					int Count = 0;
					while (rs.next())
					{   
						 Count++;  
					}

					//If there are no such entries, insert ...
					if (Count == 0)
					{
						 update="INSERT INTO PERSON values(";
						 for (int i=0; i<PersonAttributes.length;i++) {
							  update += (i==0) ? "" : ",";
							  update +="?";
						 }
						 update += ")";
						 prepst=con.prepareStatement(update);
						 for (int i=0; i<PersonAttributes.length; i++) 
						 {
							  prepst.setString(i+1,request.getParameter("contact-"+PersonAttributes[i].toLowerCase()));
						 }
						 prepst.executeUpdate();
					}

					// there was already such a person in the database having the same email id as 
					// you have just tried to insert. This cannot be allowed. 
					else
					{
						 out.println("I am sorry but the new email id was not allowed.<br> You might want to rechange it! <br>"); 
						 //but you are not permitted to make the change of contact author to"+NewEmail);

					}

					update="INSERT INTO PAPER values(";
					for (int i=0; i<PaperAttributes.length;i++) {
						 update += (i==0) ? "" : ",";
						 update +="?";
					}
					update += ")";
					prepst=con.prepareStatement(update);

					for (int i=0; i<PaperAttributes.length; i++) 
					{
						 //All other attributes come from the document - PaperID is assigned.
						 if (PaperAttributes[i].equalsIgnoreCase("PaperID"))
							  prepst.setString(i+1,ID);
						 else 
						 {
							  // Password is also assigned!
							  if (PaperAttributes[i].equalsIgnoreCase("Password"))
								   prepst.setString(i+1,""+password);
							  else 
							  {
								   //default extension is .txt : will be updated in the Upload servlet
								   if (PaperAttributes[i].equalsIgnoreCase("Extn"))
										prepst.setString(i+1,".txt");
								   else prepst.setString(i+1,request.getParameter(PaperAttributes[i].toLowerCase()));
							  }
						 } 
					}
					prepst.executeUpdate();


					update="INSERT INTO AUTHOR values(";
					for (int i=0; i<AuthorAttributes.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					prepst=con.prepareStatement(update);
					rs = st.executeQuery("SELECT * FROM AUTHOR WHERE EMAIL='"+request.getParameter("contact-email")+"'");
					Count = 0;

					// just as in the insertion in the Person table we have to check change of email
					// information that already exists in the database but is not related to this 
					// paper :

					while (rs.next())
					{   
						 Count++;  
					}


					if (Count == 0)
					{
						 for (int i=0; i<AuthorAttributes.length; i++) 
						 { 
							  prepst.setString(i+1,request.getParameter("contact-"+AuthorAttributes[i].toLowerCase()));
						 }
						 prepst.executeUpdate();
					}
					else 
					{
						 out.println("I am sorry but you are not authorised to make the contact-author email change.<br> You might want to re-change this information."); //but you are not allowed to make this change of information of contact author to"+NewEmail);
					}

					for (int j=0; j<(Config._NO_OF_AUTHORS - 2); j++)
					{
						 if (!((request.getParameter("author-email"+j).equals(""))
										|| (request.getParameter("author-email"+j).equals(null))))
						 {
							  rs = st.executeQuery("SELECT * FROM AUTHOR WHERE EMAIL='"+request.getParameter("author-email"+j)+"'");
							  Count = 0;
							  while (rs.next())
							  { 
								   Count ++;
							  }
							  if (Count == 0)
							  {
								   update="INSERT INTO AUTHOR values(";
								   for (int i=0; i<AuthorAttributes.length; i++) {
										update += (i==0) ? "" : ",";
										update += "?";
								   }
								   update += ")";
								   prepst=con.prepareStatement(update);
								   for (int i=0; i<AuthorAttributes.length; i++) 
								   {
										prepst.setString(i+1,request.getParameter("author-"+AuthorAttributes[i].toLowerCase()+j));
								   }
								   prepst.executeUpdate();
							  }
							  else 
							  {
								   out.println("I am sorry but this is not allowed. <br>"); //but you are not allowed to make this change of information to"+request.getParameter("author-"+AuthorAttributes[primary].toLowerCase()+j));
							  }
						 }
					}

					update="INSERT INTO AUTHOREDBY values(";
					for (int i=0; i<AuthoredByAttributes.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					prepst=con.prepareStatement(update);


					for (int i=0; i<AuthoredByAttributes.length; i++) 
					{
						 if (AuthoredByAttributes[i].equalsIgnoreCase("PaperID"))
							  prepst.setString(i+1, ID);
						 else
						 {
							  if (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))
								   prepst.setInt(i+1, 1);
							  else prepst.setString(i+1,request.getParameter("contact-"+AuthoredByAttributes[i].toLowerCase()));
						 }
					}
					prepst.executeUpdate();

					for (int j=0; j<(Config._NO_OF_AUTHORS - 2); j++)
					{
						 if ((request.getParameter("author-email"+j)).equalsIgnoreCase("")) continue;
						 for (int i=0; i<AuthoredByAttributes.length; i++) 
						 {
							  if (AuthoredByAttributes[i].equalsIgnoreCase("PaperID"))
								   prepst.setString(i+1, ID);
							  else
							  {
								   if (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))
										prepst.setInt(i+1, 0);
								   else prepst.setString(i+1,request.getParameter("author-"+AuthoredByAttributes[i].toLowerCase()+j));
							  }
						 }
						 prepst.executeUpdate();
					}

					out.println("<br>");
					out.println("Done!! <br>");
					out.println("<font size=3 class=TDFONT>Return to Your Page?</font>");
					out.println("<a href=\"http://"+Config._HOST+":" + Config._PORT + "/servlet/AuthorServlet\"><font size=3 class=TITLEFONT>There you go!!</font></a>");
					out.println("<br><br><br><br><br><br><br>");

					ShowStuff.printFooter(out);
					con.close();


			   }catch (SQLException sqle)
			   {    ShowStuff.printHeader("Error",out);
					ShowStuff.throwError("ERROR","The following exception occured in the processing of your query <br></br>"+sqle,out);
					ShowStuff.printFooter(out);
					if (con != null) con=null;
			   }


		  }
}
