import java.io.IOException;
import java.io.PrintWriter;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import util.*;

/** This class generates the form for change of author and paper information - it gives
 * the original information printed in textboxes which may then be changed.
 *
 * @author Anjali Gupta 
 * @version 1.00 Mon Nov 13 21:22:02 IST 2000
 */ 

public class Change extends HttpServlet
{

	 /** Initialize the servlet
	  *
	  * @param ServletConfig servletconfig
	  */

    public void init(ServletConfig servletconfig)
        throws ServletException
    {
        super.init(servletconfig);
    }

	/** This function generates the form.
	 *
	 * @param Httpservletrequest httpservletrequest
	 * @param HttpServletResponse httpservletresponse
	 */

    public void service(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse)
        throws IOException, ServletException
    {
        
		Connection connection = null;
        httpservletresponse.setContentType("text/html");
        PrintWriter printwriter = httpservletresponse.getWriter();
        
		try
        {
			 /* test session validity - only authors are allowed access here.*/

            HttpSession httpsession = httpservletrequest.getSession(false);
            
			String s = (String)httpsession.getValue("whoami");
            
			if(s == null || !s.equalsIgnoreCase("Author"))
                throw new UnavailableException(this, "Invalid Access Attempt");
            
			connection = DB.getConnection();
            
			// get session ID.
			String s1 = (String)httpsession.getValue("ID");
            
			connection.getMetaData();
            
			Statement statement = connection.createStatement();
            String s2 = "";
            
			ShowStuff.printHeader("Change Information", printwriter);
            printwriter.println("<form name=\"GoChange\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AuthorServlet\">");
            printwriter.println("<table width=500 border=0 cellspacing=0 cellpadding=0>");
            
			for(ResultSet resultset = statement.executeQuery("SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID=" + s1 + "AND ISCONTACT=1"); resultset.next();)
                s2 = resultset.getString(1);

            ResultSet resultset1 = statement.executeQuery("SELECT * FROM PERSON WHERE EMAIL='" + s2 + "'");
            ResultSetMetaData resultsetmetadata = resultset1.getMetaData();
            
			int i = resultsetmetadata.getColumnCount();
            
			PersonAttributes = new String[i];
            PersonValues = new String[i];
            
			while(resultset1.next()) 
            {
                for(int j = 0; j < i; j++)
                {
                    PersonAttributes[j] = resultsetmetadata.getColumnName(j + 1);
                    PersonValues[j] = resultset1.getString(j + 1);
                    ShowStuff.textBox("contact-" + PersonAttributes[j].toLowerCase(), PersonValues[j], 100, 100, printwriter);
                }

            }
            resultset1 = statement.executeQuery("SELECT * FROM AUTHOR WHERE EMAIL IN (SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID=" + s1 + " AND EMAIL <> '" + s2 + "')");
            
			resultsetmetadata = resultset1.getMetaData();
            i = resultsetmetadata.getColumnCount();
            AuthorAttributes = new String[i];
            AuthorValues = new String[i];
            
			int k = 0;
            byte byte0 = 6;
            while(resultset1.next()) 
            {
                for(int l = 0; l < i; l++)
                {
                    AuthorAttributes[l] = resultsetmetadata.getColumnName(l + 1);
                    AuthorValues[l] = resultset1.getString(l + 1);
                    ShowStuff.textBox("author-" + AuthorAttributes[l].toLowerCase() + k, AuthorValues[l], 60, 60, printwriter);
                }

                k++;
            }
            for(; k < byte0 - 1; k++)
            {
                for(int i1 = 0; i1 < i; i1++)
                {
                    AuthorAttributes[i1] = resultsetmetadata.getColumnName(i1 + 1);
                    ShowStuff.textBox("author-" + AuthorAttributes[i1].toLowerCase() + k, "", 60, 60, printwriter);
                }

            }

            resultset1 = statement.executeQuery("SELECT * FROM PAPER WHERE PAPERID=" + s1);
            resultsetmetadata = resultset1.getMetaData();
            i = resultsetmetadata.getColumnCount();
            PaperAttributes = new String[i];
            PaperValues = new String[i];
            while(resultset1.next()) 
            {
                for(int j1 = 0; j1 < i; j1++)
                {
                    PaperAttributes[j1] = resultsetmetadata.getColumnName(j1 + 1);
                    PaperValues[j1] = resultset1.getString(j1 + 1);
                    if(!PaperAttributes[j1].equalsIgnoreCase("PAPERID") && !PaperAttributes[j1].equalsIgnoreCase("Extn") && !PaperAttributes[j1].equalsIgnoreCase("Password"))
                        ShowStuff.textBox(PaperAttributes[j1].toLowerCase(), PaperValues[j1], 60, 60, printwriter);
                }

            }
            resultset1 = statement.executeQuery("SELECT * FROM AUTHOREDBY WHERE PAPERID=" + s1 + " AND EMAIL='" + s2 + "'");
            resultsetmetadata = resultset1.getMetaData();
            i = resultsetmetadata.getColumnCount();
            AuthoredByAttributes = new String[i];
            AuthoredByValues = new String[i];
            while(resultset1.next()) 
            {
                for(int k1 = 0; k1 < i; k1++)
                {
                    AuthoredByAttributes[k1] = resultsetmetadata.getColumnName(k1 + 1);
                    AuthoredByValues[k1] = resultset1.getString(k1 + 1);
                    if(!AuthoredByAttributes[k1].equalsIgnoreCase("email") && !AuthoredByAttributes[k1].equalsIgnoreCase("PaperID") && !AuthoredByAttributes[k1].equalsIgnoreCase("isContact"))
                        ShowStuff.textBox("contact-" + AuthoredByAttributes[k1].toLowerCase(), AuthoredByValues[k1], 60, 60, printwriter);
                }

            }
            resultset1 = statement.executeQuery("SELECT * FROM AUTHOREDBY WHERE PAPERID=" + s1 + " AND EMAIL <> '" + s2 + "'");
            resultsetmetadata = resultset1.getMetaData();
            i = resultsetmetadata.getColumnCount();
            AuthoredByAttributes = new String[i];
            AuthoredByValues = new String[i];
            for(k = 0; resultset1.next(); k++)
            {
                for(int l1 = 0; l1 < i; l1++)
                {
                    AuthoredByAttributes[l1] = resultsetmetadata.getColumnName(l1 + 1);
                    AuthoredByValues[l1] = resultset1.getString(l1 + 1);
                    if(!AuthoredByAttributes[l1].equalsIgnoreCase("email") && !AuthoredByAttributes[l1].equalsIgnoreCase("PaperID") && !AuthoredByAttributes[l1].equalsIgnoreCase("isContact"))
                        ShowStuff.textBox("author-" + AuthoredByAttributes[l1].toLowerCase() + k, AuthoredByValues[l1], 60, 60, printwriter);
                }

            }

            for(; k < byte0 - 1; k++)
            {
                for(int i2 = 0; i2 < i; i2++)
                {
                    AuthoredByAttributes[i2] = resultsetmetadata.getColumnName(i2 + 1);
                    if(!AuthoredByAttributes[i2].equalsIgnoreCase("email") && !AuthoredByAttributes[i2].equalsIgnoreCase("PaperID") && !AuthoredByAttributes[i2].equalsIgnoreCase("isContact"))
                        ShowStuff.textBox("author-" + AuthoredByAttributes[i2].toLowerCase() + k, "", 60, 60, printwriter);
                }

            }

            printwriter.println("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
            printwriter.println("<tr><td><input type=\"submit\" name=\"go\" value=\"ChangeNow\"></td><td>&nbsp;</td></tr></table> ");
            ShowStuff.printFooter(printwriter);
            connection.close();
            return;
        }
        catch(SQLException sqlexception)
        {
            ShowStuff.printHeader("Error", printwriter);
            ShowStuff.throwError("ERROR", "The following exception occured <br></br>" + sqlexception, printwriter);
            ShowStuff.printFooter(printwriter);
        if(connection != null)
            connection = null;
		}
    }

    public Change()
    {
    }

    static String PersonAttributes[];
    static String AuthorAttributes[];
    static String PaperAttributes[];
    static String AuthoredByAttributes[];
    static String PersonValues[];
    static String AuthorValues[];
    static String PaperValues[];
    static String AuthoredByValues[];
    static int PersonSizes[];
    static int AuthorSizes[];
    static int PaperSizes[];
    static int AuthoredBySizes[];
    static int NoOfAuthors;
    static int size = 7;

}
